/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.codeInsight.GruntfilePsiStructure;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTaskTreeView
extends JsbtTaskTreeView {
    private static final String NO_TASKS_FOUND = "No tasks found";
    private static final SimpleTextAttributes DEPENDENCIES_TEXT_ATTR = new SimpleTextAttributes(128, UIUtil.getInactiveTextColor());

    public GruntTaskTreeView(@NotNull GruntService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "<init>"));
        }
        super(service, project, layoutPlace);
    }

    @Override
    protected void addBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @NotNull JsbtFileStructure _structure) {
        if (buildfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfileTreeNode", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "addBuildfileChildren"));
        }
        if (_structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_structure", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "addBuildfileChildren"));
        }
        GruntfileStructure structure = (GruntfileStructure)_structure;
        for (GruntAliasTask aliasTask : structure.getAliasTasks()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(aliasTask, false);
            buildfileTreeNode.add(node);
        }
        for (GruntCoreTask coreTask : structure.getCoreTasks()) {
            DefaultMutableTreeNode coreTaskNode = new DefaultMutableTreeNode(coreTask, true);
            for (GruntTargetTask targetTask : coreTask.getTargetTasks()) {
                coreTaskNode.add(new DefaultMutableTreeNode(targetTask, false));
            }
            buildfileTreeNode.add(coreTaskNode);
        }
        if (structure.getAliasTasks().isEmpty() && structure.getCoreTasks().isEmpty()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(NO_TASKS_FOUND, false));
        }
    }

    @Override
    protected boolean hasTaskNodes(@NotNull DefaultMutableTreeNode gruntfileTreeNode) {
        if (gruntfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gruntfileTreeNode", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "hasTaskNodes"));
        }
        int childCount = gruntfileTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)gruntfileTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            GruntTask task = GruntTask.getUserObject(child);
            if (task == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void customizeCell(@NotNull Project project, @NotNull ColoredTreeCellRenderer renderer, @NotNull DefaultMutableTreeNode node) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "customizeCell"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "customizeCell"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "customizeCell"));
        }
        renderer.setToolTipText(null);
        GruntfileStructure structure = GruntfileStructure.getUserObject(node);
        if (structure != null) {
            renderer.setIcon(JavaScriptLanguageIcons.Grunt.Grunt);
            renderer.setIconOnTheRight(false);
            renderer.append(JsbtUtil.getRelativePath(project, structure.getBuildfile()));
            return;
        }
        if (NO_TASKS_FOUND.equals(node.getUserObject())) {
            renderer.append(NO_TASKS_FOUND, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return;
        }
        GruntTask task = GruntTask.getUserObject(node);
        if (task != null) {
            ImmutableList<String> dependencies;
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.BuildToolTask);
            SimpleTextAttributes nameAttr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (task instanceof GruntAliasTask && "default".equals(task.getName())) {
                nameAttr = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            String text = task.getName();
            if (task instanceof GruntTargetTask) {
                text = ((GruntTargetTask)task).getTargetName();
            }
            renderer.append(text, nameAttr);
            if (task.getInfo() != null && task instanceof GruntCoreTask) {
                renderer.setToolTipText(task.getInfo());
            }
            if (task instanceof GruntAliasTask && !(dependencies = ((GruntAliasTask)task).getDependencies()).isEmpty()) {
                renderer.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer.append(StringUtil.join(dependencies, (String)", "), DEPENDENCIES_TEXT_ATTR);
            }
        }
    }

    @Override
    @Nullable
    protected String getPersistentId(@Nullable DefaultMutableTreeNode node) {
        GruntfileStructure structure = GruntfileStructure.getUserObject(node);
        if (structure != null) {
            return structure.getBuildfile().getPath();
        }
        GruntTask gruntTask = GruntTask.getUserObject(node);
        return gruntTask != null ? gruntTask.getName() : null;
    }

    @Override
    protected String stringifyForSpeedSearch(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "stringifyForSpeedSearch"));
        }
        GruntTask task = GruntTask.getUserObject(node);
        if (task != null) {
            return task.getName();
        }
        return "";
    }

    @Override
    @Nullable
    protected JsbtTaskSet createTaskSetFromSelectedNodes() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        GruntfileStructure resultStructure = null;
        SmartList taskNames = new SmartList();
        for (DefaultMutableTreeNode node : nodes) {
            GruntTask task = GruntTask.getUserObject(node);
            if (task == null) {
                return null;
            }
            GruntfileStructure structure = task.getStructure();
            if (resultStructure != null && !resultStructure.equals(structure)) {
                return null;
            }
            resultStructure = structure;
            taskNames.add(task.getName());
        }
        if (resultStructure == null) {
            return null;
        }
        return new JsbtTaskSet(resultStructure, (List<String>)taskNames);
    }

    @Override
    @Nullable
    protected OpenFileDescriptor createJumpToSourceDescriptor(@NotNull Project project, @NotNull DefaultMutableTreeNode node) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "createJumpToSourceDescriptor"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "createJumpToSourceDescriptor"));
        }
        GruntTask task = GruntTask.getUserObject(node);
        if (task != null) {
            Location location;
            VirtualFile gruntfile = task.getStructure().getBuildfile();
            if (!gruntfile.isValid()) {
                return null;
            }
            String taskFilePath = task.getFilePath();
            PsiElement element = null;
            VirtualFile taskFile = null;
            if (taskFilePath != null) {
                taskFile = FileUtil.isAbsolutePlatformIndependent((String)taskFilePath) ? LocalFileSystem.getInstance().findFileByPath(taskFilePath) : gruntfile.getParent().findFileByRelativePath(taskFilePath);
            }
            boolean libraryTaskFile = false;
            if (taskFile != null && taskFile.isValid() && !taskFile.isDirectory() && !taskFile.equals(gruntfile) && !(libraryTaskFile = JSLibraryUtil.isProbableLibraryFile(taskFile))) {
                element = GruntTaskTreeView.findPsiElementInFile(project, task, taskFile);
            }
            if (element == null) {
                element = GruntTaskTreeView.findPsiElementInFile(project, task, gruntfile);
            }
            if (element == null && libraryTaskFile) {
                element = GruntTaskTreeView.findPsiElementInFile(project, task, taskFile);
            }
            if (element != null && (location = PsiLocation.fromPsiElement((PsiElement)element)) != null) {
                return location.getOpenFileDescriptor();
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement findPsiElementInFile(@NotNull Project project, @NotNull GruntTask task, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "findPsiElementInFile"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "findPsiElementInFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskTreeView", "findPsiElementInFile"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile instanceof JSFile) {
            GruntfilePsiStructure psiStructure = GruntfilePsiStructure.get((JSFile)psiFile);
            String taskName = task.getName();
            String targetName = null;
            if (task instanceof GruntTargetTask) {
                GruntTargetTask targetTask = (GruntTargetTask)task;
                taskName = targetTask.getCoreTask().getName();
                targetName = targetTask.getTargetName();
            }
            return psiStructure.getPsiElementToNavigateTo(taskName, targetName);
        }
        return null;
    }
}

