/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTree;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntfileStructure
extends JsbtFileStructure {
    private List<GruntAliasTask> myAliasTasks;
    private List<GruntCoreTask> myCoreTasks;
    private Map<String, GruntTask> myTaskByNameMap;

    public GruntfileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "<init>"));
        }
        super(buildfile);
        this.myAliasTasks = ImmutableList.of();
        this.myCoreTasks = ImmutableList.of();
        this.myTaskByNameMap = ImmutableMap.of();
    }

    @Override
    @NotNull
    public List<String> getTaskNames() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myTaskByNameMap.keySet());
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "getTaskNames"));
        }
        return immutableList;
    }

    @NotNull
    public List<GruntAliasTask> getAliasTasks() {
        List<GruntAliasTask> list = this.myAliasTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "getAliasTasks"));
        }
        return list;
    }

    public void setTasks(@NotNull List<GruntAliasTask> aliasTasks, @NotNull List<GruntCoreTask> coreTasks) {
        if (aliasTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasTasks", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "setTasks"));
        }
        if (coreTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreTasks", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "setTasks"));
        }
        GruntfileStructure.sort(aliasTasks);
        this.myAliasTasks = ImmutableList.copyOf(aliasTasks);
        GruntfileStructure.sort(coreTasks);
        this.myCoreTasks = ImmutableList.copyOf(coreTasks);
        LinkedHashMap taskByNameMap = ContainerUtil.newLinkedHashMap();
        for (GruntAliasTask aliasTask : aliasTasks) {
            taskByNameMap.put(aliasTask.getName(), aliasTask);
        }
        for (GruntCoreTask coreTask : coreTasks) {
            taskByNameMap.put(coreTask.getName(), coreTask);
            for (GruntTargetTask targetTask : coreTask.getTargetTasks()) {
                taskByNameMap.put(targetTask.getName(), targetTask);
            }
        }
        this.myTaskByNameMap = ImmutableMap.copyOf((Map)taskByNameMap);
    }

    @NotNull
    public List<GruntCoreTask> getCoreTasks() {
        List<GruntCoreTask> list = this.myCoreTasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "getCoreTasks"));
        }
        return list;
    }

    @Nullable
    public GruntTask findTaskByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "findTaskByName"));
        }
        return this.myTaskByNameMap.get(name);
    }

    @Nullable
    public static GruntfileStructure getUserObject(@Nullable DefaultMutableTreeNode node) {
        return JsbtTree.getUserObject(node, GruntfileStructure.class);
    }

    private static void sort(@NotNull List<? extends GruntTask> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/lang/javascript/buildTools/grunt/GruntfileStructure", "sort"));
        }
        Collections.sort(tasks, new Comparator<GruntTask>(){

            @Override
            public int compare(GruntTask o1, GruntTask o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }
}

