/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.execution;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

public class GruntNotifier {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Grunt Console", NotificationDisplayType.NONE, true, ToolWindowId.RUN);
    private final Project myProject;
    private final Alarm myAlarm;
    private boolean myPrevSuccess;

    public GruntNotifier(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/execution/GruntNotifier", "<init>"));
        }
        this.myPrevSuccess = true;
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    }

    public void scheduleNotification(final boolean success) {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                GruntNotifier.this.doNotify(success);
            }
        }, 300, ModalityState.any());
    }

    private void doNotify(boolean success) {
        NotificationGroup group = NOTIFICATION_GROUP;
        NotificationSettings oldSettings = null;
        if (this.myPrevSuccess == success) {
            NotificationsConfiguration notificationsConfiguration = NotificationsConfiguration.getNotificationsConfiguration();
            oldSettings = NotificationsConfigurationImpl.getSettings((String)group.getDisplayId());
            notificationsConfiguration.changeSettings(oldSettings.getGroupId(), NotificationDisplayType.NONE, oldSettings.isShouldLog(), oldSettings.isShouldReadAloud());
        }
        String message = GruntNotifier.formatMessage(success);
        Notification notification = group.createNotification(message, success ? MessageType.INFO : MessageType.ERROR);
        notification.notify(this.myProject);
        SystemNotifications.getInstance().notify("Grunt Console", message, "");
        if (oldSettings != null) {
            NotificationsConfiguration notificationsConfiguration = NotificationsConfiguration.getNotificationsConfiguration();
            notificationsConfiguration.changeSettings(oldSettings.getGroupId(), oldSettings.getDisplayType(), oldSettings.isShouldLog(), oldSettings.isShouldReadAloud());
        }
        this.myPrevSuccess = success;
        GruntNotifier.synchronizeFS();
    }

    private static void synchronizeFS() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                LocalFileSystem.getInstance().refresh(true);
            }
        });
    }

    private static String formatMessage(boolean success) {
        if (success) {
            return "Task \"watch\" passed";
        }
        return "Task \"watch\" failed";
    }

    public void stop() {
        this.myAlarm.cancelAllRequests();
        Disposer.dispose((Disposable)this.myAlarm);
    }
}

