/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpTask;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpTaskTreeView
extends JsbtTaskTreeView {
    private static final String NO_TASKS_FOUND = "No tasks found";
    private static final SimpleTextAttributes DEPENDENCIES_TEXT_ATTR = new SimpleTextAttributes(128, UIUtil.getInactiveTextColor());

    public GulpTaskTreeView(@NotNull GulpService service, @NotNull Project project, @Nullable String layoutPlace) {
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "<init>"));
        }
        super(service, project, layoutPlace);
    }

    @Override
    protected void addBuildfileChildren(@NotNull DefaultMutableTreeNode buildfileTreeNode, @NotNull JsbtFileStructure _structure) {
        if (buildfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfileTreeNode", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "addBuildfileChildren"));
        }
        if (_structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_structure", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "addBuildfileChildren"));
        }
        GulpfileStructure structure = (GulpfileStructure)_structure;
        for (GulpTask task : structure.getTasks()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(task, false));
        }
        if (structure.getTasks().isEmpty()) {
            buildfileTreeNode.add(new DefaultMutableTreeNode(NO_TASKS_FOUND, false));
        }
    }

    @Override
    protected boolean hasTaskNodes(@NotNull DefaultMutableTreeNode buildfileTreeNode) {
        if (buildfileTreeNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfileTreeNode", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "hasTaskNodes"));
        }
        int childCount = buildfileTreeNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)buildfileTreeNode.getChildAt(i), DefaultMutableTreeNode.class);
            GulpTask task = GulpTask.getUserObject(child);
            if (task == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void customizeCell(@NotNull Project project, @NotNull ColoredTreeCellRenderer renderer, @NotNull DefaultMutableTreeNode node) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "customizeCell"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "customizeCell"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "customizeCell"));
        }
        GulpfileStructure structure = GulpfileStructure.getUserObject(node);
        if (structure != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.Gulp16);
            renderer.setIconOnTheRight(false);
            renderer.append(JsbtUtil.getRelativePath(project, structure.getGulpfile()));
            return;
        }
        if (NO_TASKS_FOUND.equals(node.getUserObject())) {
            renderer.append(NO_TASKS_FOUND, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            return;
        }
        GulpTask task = GulpTask.getUserObject(node);
        if (task != null) {
            renderer.setIcon(JavaScriptLanguageIcons.BuildTools.BuildToolTask);
            List<String> dependencies = task.getDependencies();
            SimpleTextAttributes nameAttr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if ("default".equals(task.getName())) {
                nameAttr = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            }
            renderer.append(task.getName(), nameAttr);
            if (!dependencies.isEmpty()) {
                renderer.append("  ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                renderer.append(StringUtil.join(dependencies, (String)", "), DEPENDENCIES_TEXT_ATTR);
            }
        }
    }

    @Override
    @Nullable
    protected String getPersistentId(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "getPersistentId"));
        }
        GulpfileStructure structure = GulpfileStructure.getUserObject(node);
        if (structure != null) {
            return structure.getBuildfile().getPath();
        }
        GulpTask task = GulpTask.getUserObject(node);
        return task != null ? task.getName() : null;
    }

    @Override
    protected String stringifyForSpeedSearch(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "stringifyForSpeedSearch"));
        }
        GulpTask task = GulpTask.getUserObject(node);
        if (task != null) {
            return task.getName();
        }
        return "";
    }

    @Override
    @Nullable
    protected JsbtTaskSet createTaskSetFromSelectedNodes() {
        List<DefaultMutableTreeNode> nodes = this.getSelectedNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        GulpfileStructure resultStructure = null;
        SmartList taskNames = new SmartList();
        for (DefaultMutableTreeNode node : nodes) {
            GulpTask task = GulpTask.getUserObject(node);
            if (task == null) {
                return null;
            }
            GulpfileStructure structure = task.getStructure();
            if (resultStructure != null && !resultStructure.equals(structure)) {
                return null;
            }
            resultStructure = structure;
            taskNames.add(task.getName());
        }
        if (resultStructure == null) {
            return null;
        }
        return new JsbtTaskSet(resultStructure, (List<String>)taskNames);
    }

    @Override
    @Nullable
    protected OpenFileDescriptor createJumpToSourceDescriptor(@NotNull Project project, @NotNull DefaultMutableTreeNode node) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "createJumpToSourceDescriptor"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/buildTools/gulp/GulpTaskTreeView", "createJumpToSourceDescriptor"));
        }
        GulpTask task = GulpTask.getUserObject(node);
        if (task != null) {
            Location location;
            GulpfilePsiStructure psiStructure;
            JSCallExpression callExpression;
            VirtualFile virtualGulpfile = task.getStructure().getGulpfile();
            if (!virtualGulpfile.isValid()) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualGulpfile);
            if (psiFile instanceof JSFile && (callExpression = (psiStructure = GulpfilePsiStructure.get((JSFile)psiFile)).getPsiByName(task.getName())) != null && (location = PsiLocation.fromPsiElement((PsiElement)callExpression)) != null) {
                return location.getOpenFileDescriptor();
            }
        }
        return null;
    }
}

