/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettings;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpNonSharedSettingsManager;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ReadonlyFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpTasksFetchSettingsDialog
extends DialogWrapper {
    private final ReadonlyFieldWithHistoryWithBrowseButton myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final TextFieldWithHistoryWithBrowseButton myGulpPackageTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;
    private final Project myProject;

    protected GulpTasksFetchSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGulpfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpTasksFetchSettingsDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.setTitle("Gulp Settings");
        this.myNodeInterpreterField = NodeUIUtil.createNodeInterpreterTextField(project);
        this.myNodeOptionsEditor = GulpRunConfigurationEditor.createNodeOptionsEditor();
        this.myGulpPackageTextFieldWithBrowseButton = GulpRunConfigurationEditor.createGulpPackageDirTextFieldWithBrowseButton(project, contextGulpfile);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"gulp.rc.nodeInterpreter.label", (Object[])new Object[0]), this.myNodeInterpreterField.getComponent()).addLabeledComponent(JSBundle.message((String)"gulp.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"gulp.rc.gulpPackage.label", (Object[])new Object[0]), (JComponent)this.myGulpPackageTextFieldWithBrowseButton).addLabeledComponent(JSBundle.message((String)"gulp.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
        GulpNonSharedSettings settings = GulpNonSharedSettingsManager.getInstance(project).get(contextGulpfile);
        this.myNodeInterpreterField.set(settings.getNodeInterpreterPath());
        GulpRunSettings runSettings = GulpRunConfiguration.getTemplateRunSettings(project);
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.myGulpPackageTextFieldWithBrowseButton.setTextAndAddToHistory(settings.getGulpPackageDirPath());
        this.configurePreferredWidth();
        this.init();
    }

    private void configurePreferredWidth() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myGulpPackageTextFieldWithBrowseButton);
        int width = Math.max(this.myNodeInterpreterField.getComponent().getPreferredSize().width, this.myGulpPackageTextFieldWithBrowseButton.getPreferredSize().width);
        width = Math.max(width, 300);
        SwingHelper.setPreferredWidth((Component)this.myNodeInterpreterField.getComponent(), (int)width);
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String nodeInterpreterError = GulpTasksFetchSettingsDialog.validateNodeInterpreter(this.myNodeInterpreterField.get());
        if (nodeInterpreterError != null) {
            return new ValidationInfo(nodeInterpreterError, this.myNodeInterpreterField.getComponent());
        }
        String gulpPackageError = GulpTasksFetchSettingsDialog.validateGulpPackage(this.myGulpPackageTextFieldWithBrowseButton.getText());
        if (gulpPackageError != null) {
            return new ValidationInfo(gulpPackageError, (JComponent)((TextFieldWithHistory)this.myGulpPackageTextFieldWithBrowseButton.getChildComponent()).getTextEditor());
        }
        return null;
    }

    @Nullable
    private static String validateNodeInterpreter(@NotNull String nodeInterpreter) {
        if (nodeInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreter", "com/intellij/lang/javascript/buildTools/gulp/GulpTasksFetchSettingsDialog", "validateNodeInterpreter"));
        }
        if (StringUtil.isEmptyOrSpaces((String)nodeInterpreter)) {
            return "Please specify node interpreter";
        }
        File file = new File(nodeInterpreter);
        if (!file.isAbsolute() || !file.isFile()) {
            return "Please specify node interpreter correctly";
        }
        return null;
    }

    @Nullable
    private static String validateGulpPackage(@NotNull String gulpPackageDir) {
        if (gulpPackageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpPackageDir", "com/intellij/lang/javascript/buildTools/gulp/GulpTasksFetchSettingsDialog", "validateGulpPackage"));
        }
        if (StringUtil.isEmptyOrSpaces((String)gulpPackageDir)) {
            return "Please specify gulp package";
        }
        File file = new File(gulpPackageDir);
        if (!file.isAbsolute() || !file.isDirectory()) {
            return "Please specify gulp package correctly";
        }
        return null;
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    private void apply() {
        GulpNonSharedSettingsManager.getInstance(this.myProject).set(this.myNodeInterpreterField.get(), this.myGulpPackageTextFieldWithBrowseButton.getText());
        GulpRunSettings runSettings = GulpRunConfiguration.getTemplateRunSettings(this.myProject);
        GulpRunSettings.Builder builder = new GulpRunSettings.Builder(runSettings);
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        GulpRunConfiguration.setTemplateRunSettings(this.myProject, builder.build());
    }
}

