/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpTask;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsGulpfileManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GulpfileManager
extends JsbtFileManager
implements PersistentStateComponent<ManagerState> {
    @NotNull
    public static GulpfileManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "getInstance"));
        }
        GulpfileManager gulpfileManager = (GulpfileManager)ServiceManager.getService((Project)project, GulpfileManager.class);
        if (gulpfileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "getInstance"));
        }
        return gulpfileManager;
    }

    public GulpfileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "<init>"));
        }
        super(project, GulpService.getInstance());
    }

    @Override
    @Nullable
    public GulpfileStructure getCachedStructure(@NotNull VirtualFile gulpfile) {
        if (gulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfile", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "getCachedStructure"));
        }
        return (GulpfileStructure)super.getCachedStructure(gulpfile);
    }

    @Nullable
    public ManagerState getState() {
        ArrayList gulpfileStates = ContainerUtil.newArrayList();
        for (VirtualFile gulpfile : this.getBuildfiles()) {
            if (!gulpfile.isValid() || gulpfile.isDirectory()) continue;
            GulpfileState gulpfileState = GulpfileManager.toGulpfileState(gulpfile, this.getCachedStructure(gulpfile));
            gulpfileStates.add(gulpfileState);
        }
        ManagerState state = new ManagerState();
        state.setGulpfileStates(gulpfileStates);
        state.setDetectionDone(this.isDetectionDone());
        return state;
    }

    @NotNull
    private static GulpfileState toGulpfileState(@NotNull VirtualFile gulpfile, @Nullable GulpfileStructure structure) {
        if (gulpfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gulpfile", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "toGulpfileState"));
        }
        GulpfileState state = new GulpfileState();
        state.setPath(gulpfile.getPath());
        if (structure != null) {
            List taskStates = ContainerUtil.map(structure.getTasks(), (Function)new Function<GulpTask, GulpTaskState>(){

                public GulpTaskState fun(GulpTask task) {
                    GulpTaskState taskState = new GulpTaskState();
                    taskState.setName(task.getName());
                    taskState.setDependencies(task.getDependencies());
                    return taskState;
                }
            });
            state.setTasks(taskStates);
        }
        GulpfileState gulpfileState = state;
        if (gulpfileState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "toGulpfileState"));
        }
        return gulpfileState;
    }

    public void loadState(ManagerState state) {
        this.clearAllBuildfiles();
        for (GulpfileState gulpfileState : state.getGulpfileStates()) {
            VirtualFile gulpfile = LocalFileSystem.getInstance().findFileByPath(gulpfileState.getPath());
            if (gulpfile == null || !gulpfile.isValid() || gulpfile.isDirectory()) continue;
            final GulpfileStructure structure = new GulpfileStructure(gulpfile);
            List tasks = ContainerUtil.map(gulpfileState.getTasks(), (Function)new Function<GulpTaskState, GulpTask>(){

                public GulpTask fun(GulpTaskState state) {
                    return new GulpTask(structure, state.getName(), state.getDependencies());
                }
            });
            structure.setTasks(tasks);
            this.addBuildfileStructure(structure);
        }
        if (state.isDetectionDone()) {
            this.setDetectionDone();
        }
    }

    @NotNull
    private static <E> List<E> notNullList(@Nullable List<E> list) {
        if (list != null) {
            List<E> list2 = list;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "notNullList"));
            }
            return list2;
        }
        ArrayList arrayList = ContainerUtil.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager", "notNullList"));
        }
        return arrayList;
    }

    public static class GulpTaskState {
        private String myName;
        private List<String> myDependencies = ContainerUtil.newArrayList();

        @Tag(value="task-name")
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @Tag(value="dependencies")
        @AbstractCollection(surroundWithTag=false, elementTag="dependency")
        public List<String> getDependencies() {
            return this.myDependencies;
        }

        public void setDependencies(List<String> dependencies) {
            this.myDependencies = GulpfileManager.notNullList(dependencies);
        }
    }

    public static class GulpfileState {
        private String myPath;
        private List<GulpTaskState> myTasks = ContainerUtil.newArrayList();

        @Tag(value="gulpfile-path")
        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path) {
            this.myPath = path;
        }

        @Tag(value="tasks")
        @AbstractCollection(surroundWithTag=false, elementTag="task")
        public List<GulpTaskState> getTasks() {
            return this.myTasks;
        }

        public void setTasks(List<GulpTaskState> tasks) {
            this.myTasks = GulpfileManager.notNullList(tasks);
        }
    }

    public static class ManagerState {
        private List<GulpfileState> myGulpfileStates = ContainerUtil.newArrayList();
        private boolean myDetectionDone = false;

        @Tag(value="gulpfiles")
        @AbstractCollection(surroundWithTag=false, elementTag="gulpfile")
        public List<GulpfileState> getGulpfileStates() {
            return this.myGulpfileStates;
        }

        public void setGulpfileStates(List<GulpfileState> gulpfileStates) {
            this.myGulpfileStates = GulpfileManager.notNullList(gulpfileStates);
        }

        @Tag(value="detection-done")
        public boolean isDetectionDone() {
            return this.myDetectionDone;
        }

        public void setDetectionDone(boolean detectionDone) {
            this.myDetectionDone = detectionDone;
        }
    }
}

