/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.NodeSettingsUtil;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ReadonlyFieldWithHistoryWithBrowseButton;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmGlobalSettingsDialog
extends DialogWrapper {
    private final ReadonlyFieldWithHistoryWithBrowseButton myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;
    private final Project myProject;

    protected NpmGlobalSettingsDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmGlobalSettingsDialog", "<init>"));
        }
        super(project, false);
        this.myProject = project;
        this.setTitle("Npm Settings");
        this.myNodeInterpreterField = NodeUIUtil.createNodeInterpreterTextField(project);
        this.myNodeOptionsEditor = NpmRunConfigurationEditor.createNodeOptionsEditor();
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JSBundle.message((String)"npm.rc.nodeInterpreter.label", (Object[])new Object[0]), this.myNodeInterpreterField.getComponent()).addLabeledComponent(JSBundle.message((String)"npm.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JSBundle.message((String)"npm.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
        NodeSettings settings = NodeSettingsUtil.getSettings(project);
        this.myNodeInterpreterField.set(settings.getInterpreterPath());
        NpmRunSettings templateRunSettings = NpmRunConfiguration.getTemplateRunSettings(project);
        this.myNodeOptionsEditor.setText(templateRunSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(templateRunSettings.getEnvData());
        this.configurePreferredWidth();
        this.init();
    }

    private void configurePreferredWidth() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        int width = Math.max(this.myNodeInterpreterField.getComponent().getPreferredSize().width, 300);
        SwingHelper.setPreferredWidth((Component)this.myNodeInterpreterField.getComponent(), (int)width);
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNodeInterpreterField.getComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String nodeInterpreterError = NpmGlobalSettingsDialog.validateNodeInterpreter(this.myNodeInterpreterField.get());
        if (nodeInterpreterError != null) {
            return new ValidationInfo(nodeInterpreterError, this.myNodeInterpreterField.getComponent());
        }
        return null;
    }

    @Nullable
    private static String validateNodeInterpreter(@NotNull String nodeInterpreter) {
        if (nodeInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeInterpreter", "com/intellij/lang/javascript/buildTools/npm/NpmGlobalSettingsDialog", "validateNodeInterpreter"));
        }
        if (StringUtil.isEmptyOrSpaces((String)nodeInterpreter)) {
            return "Please specify node interpreter";
        }
        File file = new File(nodeInterpreter);
        if (!file.isAbsolute() || !file.isFile()) {
            return "Please specify node interpreter correctly";
        }
        return null;
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    private void apply() {
        NodeSettingsUtil.setInterpreterPath(this.myProject, this.myNodeInterpreterField.get());
        NpmRunSettings templateRunSettings = NpmRunConfiguration.getTemplateRunSettings(this.myProject);
        NpmRunSettings.Builder builder = NpmRunSettings.builder(templateRunSettings);
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        NpmRunConfiguration.setTemplateRunSettings(this.myProject, builder.build());
    }
}

