/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmGlobalSettingsDialog;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmTaskTreeView;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmScriptsService
extends JsbtService {
    private static final Logger LOG = Logger.getInstance(PackageJsonFileManager.class);
    private static final Key<TimestampedStructure> TIMESTAMPED_STRUCTURE = Key.create((String)"timestamped structure");
    private static NpmScriptsService INSTANCE;

    @NotNull
    public static NpmScriptsService getInstance() {
        NpmScriptsService instance = INSTANCE;
        if (instance == null) {
            instance = (NpmScriptsService)JsbtService.EP_NAME.findExtension(NpmScriptsService.class);
            if (instance == null) {
                LOG.error("Cannot find extension " + JsbtService.EP_NAME.getName() + " of class " + NpmScriptsService.class.getName());
                instance = new NpmScriptsService();
            }
            INSTANCE = instance;
        }
        NpmScriptsService npmScriptsService = instance;
        if (npmScriptsService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getInstance"));
        }
        return npmScriptsService;
    }

    @Override
    @NotNull
    public String getName() {
        if ("npm" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getName"));
        }
        return "npm";
    }

    @Override
    @NotNull
    public String getMenuItemDisplayName() {
        if ("npm Scripts" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getMenuItemDisplayName"));
        }
        return "npm Scripts";
    }

    @Override
    @NotNull
    public String getSearchEverywhereDescription() {
        if ("npm script" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getSearchEverywhereDescription"));
        }
        return "npm script";
    }

    @Override
    @NotNull
    public String getReloadTasksActionName() {
        if ("Reload scripts" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getReloadTasksActionName"));
        }
        return "Reload scripts";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getFileManager"));
        }
        PackageJsonFileManager packageJsonFileManager = PackageJsonFileManager.getInstance(project);
        if (packageJsonFileManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getFileManager"));
        }
        return packageJsonFileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "createToolWindowManager"));
        }
        JsbtToolWindowManager jsbtToolWindowManager = new JsbtToolWindowManager(project, "npm", JavaScriptLanguageIcons.BuildTools.Npm.Npm_13, "reference.tool.window.npm", this);
        if (jsbtToolWindowManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "createToolWindowManager"));
        }
        return jsbtToolWindowManager;
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@NotNull Project project, @Nullable String layoutPlace) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "createTaskTreeView"));
        }
        NpmTaskTreeView npmTaskTreeView = new NpmTaskTreeView(this, project, layoutPlace);
        if (npmTaskTreeView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "createTaskTreeView"));
        }
        return npmTaskTreeView;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfiles"));
        }
        if (DumbService.isDumb((Project)project)) {
            List<VirtualFile> list = this.detectAllBuildfilesInContentRoots(project, false);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfiles"));
            }
            return list;
        }
        List list = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<VirtualFile>>(){

            public List<VirtualFile> compute() {
                GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
                Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)scope);
                final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                return ContainerUtil.filter((Collection)files, (Condition)new Condition<VirtualFile>(){

                    public boolean value(VirtualFile virtualFile) {
                        if (virtualFile == null || !virtualFile.isValid() || virtualFile.isDirectory()) {
                            return false;
                        }
                        if (JSLibraryUtil.isProbableLibraryFile(virtualFile)) {
                            return false;
                        }
                        return !fileIndex.isInLibraryClasses(virtualFile) && !fileIndex.isInLibrarySource(virtualFile);
                    }
                });
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfiles"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfilesInContentRoots"));
        }
        ArrayList buildfiles = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (webModulesOnly && !WebModuleTypeBase.isWebModule((Module)module)) continue;
            for (VirtualFile parent : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                VirtualFile buildfile = parent.findChild("package.json");
                if (buildfile == null) continue;
                if (buildfiles == null) {
                    buildfiles = ContainerUtil.newArrayList();
                }
                buildfiles.add(buildfile);
            }
        }
        List list = ContainerUtil.notNullize(buildfiles);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfilesInContentRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfilesInContentRoots"));
        }
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(project, webModulesOnly);
        if (!filterOutEmptyBuildfiles) {
            List<VirtualFile> list = buildfiles;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfilesInContentRoots"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile buildfile : buildfiles) {
            try {
                NpmScriptsStructure structure = NpmScriptsUtil.listTasks(project, buildfile);
                if (structure.getTaskNames().isEmpty()) continue;
                result.add(buildfile);
            }
            catch (JsbtTaskFetchException jsbtTaskFetchException) {}
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "detectAllBuildfilesInContentRoots"));
        }
        return arrayList;
    }

    @Override
    public String getBuildfileCommonName() {
        return "package.json";
    }

    @Override
    public boolean isBuildfileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "isBuildfileName"));
        }
        return "package.json".equals(fileName);
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildfile", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "createEmptyFileStructure"));
        }
        NpmScriptsStructure npmScriptsStructure = new NpmScriptsStructure(buildfile);
        if (npmScriptsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "createEmptyFileStructure"));
        }
        return npmScriptsStructure;
    }

    @Override
    @NotNull
    public NpmScriptsStructure fetchBuildfileStructure(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        long documentTimeStamp;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "fetchBuildfileStructure"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "fetchBuildfileStructure"));
        }
        if (!packageJson.isValid()) {
            throw JsbtTaskFetchException.newBuildfileSyntaxError(packageJson);
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(packageJson);
        TimestampedStructure data = (TimestampedStructure)TIMESTAMPED_STRUCTURE.get((UserDataHolder)packageJson);
        long l = documentTimeStamp = document != null ? document.getModificationStamp() : -1L;
        if (data == null || data.myFileTimeStamp != packageJson.getTimeStamp() || data.myDocumentTimeStamp != documentTimeStamp) {
            NpmScriptsStructure structure = NpmScriptsUtil.listTasks(project, packageJson);
            data = new TimestampedStructure(structure, packageJson.getTimeStamp(), documentTimeStamp);
            TIMESTAMPED_STRUCTURE.set((UserDataHolder)packageJson, (Object)data);
        }
        NpmScriptsStructure npmScriptsStructure = data.myStructure;
        if (npmScriptsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "fetchBuildfileStructure"));
        }
        return npmScriptsStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = NpmConfigurationType.getFactory();
        if (configurationFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "getConfigurationFactory"));
        }
        return configurationFactory;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "isConfigurationMatched"));
        }
        if (patternObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternObject", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "isConfigurationMatched"));
        }
        if (runConfiguration instanceof NpmRunConfiguration) {
            NpmRunSettings runSettings = ((NpmRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof NpmRunSettings) {
                NpmRunSettings patternRunSettings = (NpmRunSettings)patternObject;
                return patternRunSettings.getCommand() == runSettings.getCommand() && JsbtUtil.equalsOrderless(patternRunSettings.getScriptNames(), runSettings.getScriptNames()) && patternRunSettings.getPackageJsonPath().equals(runSettings.getPackageJsonPath());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return runSettings.getCommand() == NpmCommand.RUN_SCRIPT && JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getScriptNames()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getPackageJsonPath());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "setupRunConfiguration"));
        }
        if (taskSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskSet", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "setupRunConfiguration"));
        }
        NpmScriptsStructure structure = (NpmScriptsStructure)taskSet.getStructure();
        NpmRunConfiguration npmRunConfiguration = (NpmRunConfiguration)runConfiguration;
        NpmRunSettings merged = NpmRunSettings.builder(npmRunConfiguration.getRunSettings()).setPackageJsonPath(structure.getBuildfile().getPath()).setCommand(NpmCommand.RUN_SCRIPT).setScriptNames(taskSet.getTaskNames()).build();
        NpmRunConfigurationProducer.setupConfigurationFromSettings(npmRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextBuildfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService", "showTaskListingSettingsDialog"));
        }
        return new NpmGlobalSettingsDialog(project).showAndGet();
    }

    private static class TimestampedStructure {
        private final NpmScriptsStructure myStructure;
        private final long myFileTimeStamp;
        private final long myDocumentTimeStamp;

        /*
         * WARNING - void declaration
         */
        public TimestampedStructure(@NotNull NpmScriptsStructure structure, long fileTimeStamp, long l) {
            void documentTimeStamp;
            if (structure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService$TimestampedStructure", "<init>"));
            }
            this.myStructure = structure;
            this.myFileTimeStamp = fileTimeStamp;
            this.myDocumentTimeStamp = documentTimeStamp;
        }
    }
}

