/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.validation.ImplementedMethodProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JSQualifiedElementNameCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement possibleClazz;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/completion/JSQualifiedElementNameCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        PsiElement prev = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(position);
        PsiElement parent = position.getParent();
        assert (parent instanceof JSQualifiedNamedElement) : "must be filtered in JSPatternBasedCompletionContributor";
        if (parent instanceof JSPackageStatement) {
            return;
        }
        if (parent instanceof JSFunction && (possibleClazz = parent.getParent()) instanceof JSClass && prev != null && prev.getNode().getElementType() == JSTokenTypes.FUNCTION_KEYWORD) {
            String name;
            JSAttributeList attributeList = ((JSFunction)parent).getAttributeList();
            if (attributeList != null && attributeList.hasExplicitModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                for (JSFunction fun : JSInheritanceUtil.collectFunctionsToOverride((JSClass)possibleClazz)) {
                    String name2 = fun.getName();
                    if (name2 == null) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name2));
                }
            } else {
                for (JSFunction fun : ImplementedMethodProcessor.collectFunctionsToImplement((JSClass)possibleClazz)) {
                    String name3 = fun.getName();
                    if (name3 == null) continue;
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name3));
                }
            }
            if ((name = ((JSClass)possibleClazz).getName()) != null) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)name));
            }
        }
    }
}

