/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSConditionalCompilationDefinitionsProvider;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JSReferenceCompletionUtil {
    JSReferenceCompletionUtil() {
    }

    @NotNull
    public static Collection calcDefaultVariants(@NotNull JSReferenceExpression expression, PsiFile containingFile, boolean ecma) {
        Object processor;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
        }
        JSExpression qualifier = expression instanceof JSReferenceExpressionImpl ? ((JSReferenceExpressionImpl)expression).getResolveQualifier() : expression.getQualifier();
        CompletionResultSink sink = new CompletionResultSink((PsiElement)expression);
        PsiElement parent = expression.getParent();
        if (JSReferenceExpressionImpl.isLocalResolveQualifier(qualifier)) {
            if (JSResolveUtil.isSelfReference(parent, (PsiElement)expression)) {
                if (parent instanceof TypeScriptModule) {
                    PsiElement grandParent = parent.getParent();
                    String ns = grandParent instanceof TypeScriptModule ? ((TypeScriptModule)grandParent).getQualifiedName() : "";
                    Collection<JSPsiElementBase> children = TypeScriptClassResolver.getInstance().findChildren(ns, (PsiElement)containingFile);
                    ArrayList<TypeScriptModule> childModules = new ArrayList<TypeScriptModule>();
                    for (JSPsiElementBase child : children) {
                        if (!(child instanceof TypeScriptModule)) continue;
                        childModules.add((TypeScriptModule)child);
                    }
                    ArrayList<TypeScriptModule> arrayList = childModules;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                    }
                    return arrayList;
                }
                if (parent instanceof JSQualifiedNamedElement && !(parent instanceof JSPackageStatement)) {
                    SmartList results = new SmartList();
                    if (!(parent instanceof JSVariable) || !(JSResolveUtil.findParent(parent) instanceof JSClass)) {
                        results.add(containingFile.getOriginalFile().getVirtualFile().getNameWithoutExtension());
                    }
                    SmartList smartList = results;
                    if (smartList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                    }
                    return smartList;
                }
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return list;
            }
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)expression, qualifier, localProcessor, ecma, true, null);
            if (ecma && !localProcessor.processingEncounteredAnyTypeAccess() && !localProcessor.isEncounteredDynamicClasses()) {
                List results = sink.getResultsAsObjects();
                Collection collection = JSReferenceCompletionUtil.appendConditionalCompilationVars(expression, results);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return collection;
            }
            if (DialectDetector.isTypeScript((PsiElement)containingFile) && (!(qualifier instanceof JSThisExpression) || JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass)) {
                List list = sink.getResultsAsObjects();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return list;
            }
        } else {
            boolean useProcessorResults;
            processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)expression).createCompletionItemProcessor(sink, containingFile);
            JSTypeEvaluator.evaluateTypes(BaseJSSymbolProcessor.getOriginalQualifier(qualifier), containingFile.getOriginalFile(), processor);
            boolean bl = useProcessorResults = ((QualifiedItemProcessor)processor).resolved == QualifiedItemProcessor.TypeResolveState.Resolved || ((QualifiedItemProcessor)processor).resolved == QualifiedItemProcessor.TypeResolveState.Undefined && (DialectDetector.isTypeScript((PsiElement)containingFile) || ecma) || ((QualifiedItemProcessor)processor).resolved == QualifiedItemProcessor.TypeResolveState.PrefixUnknown && ecma;
            if (useProcessorResults) {
                List list = sink.getResultsAsObjects();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
                }
                return list;
            }
        }
        processor = new VariantsProcessor(null, containingFile, (PsiElement)expression, BaseJSSymbolProcessor.MatchMode.Strict, JSRootConfiguration.getInstance(containingFile.getProject()).isOnlyTypeBasedCompletion());
        List<PsiElement> processorResults = sink.getResults();
        if (processorResults != null) {
            ((VariantsProcessor)processor).populateCompletionList(sink.resultsToLookupElements(processorResults), true);
        }
        JSReferenceCompletionContributor.processCompeteMatchedElements((PsiElement)expression, processor);
        Collection<? extends LookupElement> completeMatchResults = ((VariantsProcessor)processor).getCurrentResultsAsIs();
        ((VariantsProcessor)processor).populateCompletionList(completeMatchResults, false);
        if (!ecma) {
            ((VariantsProcessor)processor).collectReferencesUsedInCurrentScope((PsiElement)expression, qualifier != null);
        }
        JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)expression, (JSCompletionProcessor)processor, ((BaseJSSymbolProcessor)processor).addOnlyCompleteMatches());
        if (qualifier == null && ecma) {
            Collection collection = JSReferenceCompletionUtil.appendConditionalCompilationVars(expression, ((VariantsProcessor)processor).getResultsAsElements());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
            }
            return collection;
        }
        Collection<? extends LookupElement> collection = ((VariantsProcessor)processor).getResultsAsElements();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSReferenceCompletionUtil", "calcDefaultVariants"));
        }
        return collection;
    }

    private static Collection appendConditionalCompilationVars(JSReferenceExpression expression, Collection results) {
        JSReferenceExpression namespaceReference = JSReferenceExpressionImpl.getNamespaceReference(expression);
        if (namespaceReference != null && namespaceReference.resolve() == namespaceReference) {
            results.addAll(JSReferenceCompletionUtil.getConditionalCompilationConstantNamesForNamespace((PsiElement)expression, namespaceReference.getReferencedName()));
        } else {
            results.addAll(JSReferenceCompletionUtil.getAllConditionalCompilationConstants((PsiElement)expression));
        }
        return results;
    }

    private static List getAllConditionalCompilationConstants(PsiElement context) {
        ArrayList<Object> names = new ArrayList<Object>();
        for (JSConditionalCompilationDefinitionsProvider provider : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            for (String conditional : provider.getAllConstants(ModuleUtilCore.findModuleForPsiElement((PsiElement)context))) {
                LookupItem lookupElement = new LookupItem((Object)conditional, conditional);
                lookupElement.setPriority(6.0);
                names.add(lookupElement);
            }
            names.addAll(provider.getAllConstants(ModuleUtilCore.findModuleForPsiElement((PsiElement)context)));
        }
        return names;
    }

    private static List<String> getConditionalCompilationConstantNamesForNamespace(PsiElement context, String namespace) {
        ArrayList<String> names = new ArrayList<String>();
        for (JSConditionalCompilationDefinitionsProvider provider : (JSConditionalCompilationDefinitionsProvider[])JSConditionalCompilationDefinitionsProvider.EP_NAME.getExtensions()) {
            names.addAll(provider.getConstantNamesForNamespace(ModuleUtilCore.findModuleForPsiElement((PsiElement)context), namespace));
        }
        return names;
    }
}

