/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.library.JSLibraryExtDocProviderFactory;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.css.impl.util.CssDocumentationProvider;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.Processor;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationProvider
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    @NonNls
    private static final String OBJECT_NAME = "Object";
    private static final String RETURN_TAG_PROPERTY = "javascript.return.tag";
    protected static final String SEE_PLAIN_TEXT_CHARS = "\t \"-\\/<>*";
    private final boolean myShowNamedItem;
    private final JSLibraryExtDocProviderFactory myLibraryDocProviderFactory = new JSLibraryExtDocProviderFactory();

    public JSDocumentationProvider() {
        this(true);
    }

    public JSDocumentationProvider(boolean showNamedItem) {
        this.myShowNamedItem = showNamedItem;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        if (element instanceof JSOffsetBasedImplicitElement) {
            element = ((JSOffsetBasedImplicitElement)element).getElementAtOffset();
        }
        if ((element = element.getNavigationElement()) instanceof JSFunction) {
            JSFunction function = (JSFunction)element;
            PsiElement parent = element.getParent();
            if (function.isConstructor() && parent instanceof JSClass) {
                return JSDocumentationProvider.createQuickNavigateForClazz((JSClass)parent);
            }
            return this.createQuickNavigateForFunction(function);
        }
        if (element instanceof JSClass) {
            return JSDocumentationProvider.createQuickNavigateForClazz((JSClass)element);
        }
        if (element instanceof JSVariable) {
            return this.createQuickNavigateForVariable((JSVariable)element);
        }
        if (element instanceof JSAttributeNameValuePair) {
            return this.createQuickNavigateForAnnotationDerived(element);
        }
        if (element instanceof XmlToken) {
            BaseJSSymbolProcessor.TagContextBuilder builder = new BaseJSSymbolProcessor.TagContextBuilder(element, "XmlTag");
            return StringUtil.stripQuotesAroundValue((String)element.getText()) + ":" + builder.typeName;
        }
        if (element instanceof JSNamespaceDeclaration) {
            return JSDocumentationProvider.createQuickNavigateForNamespace((JSNamespaceDeclaration)element);
        }
        return null;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        for (String docUrl : docUrls) {
            ExternalDocumentationProvider provider;
            if (docUrl == null || (provider = this.myLibraryDocProviderFactory.getProvider(docUrl)) == null) continue;
            ArrayList<String> urlsToHandle = new ArrayList<String>();
            urlsToHandle.add(docUrl);
            String result = provider.fetchExternalDocumentation(project, element, urlsToHandle);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    private String createQuickNavigateForAnnotationDerived(PsiElement element) {
        JSAttributeNameValuePair valuePair = (JSAttributeNameValuePair)element;
        JSAttribute parent = (JSAttribute)valuePair.getParent();
        StringBuilder builder = new StringBuilder();
        JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)valuePair, JSClass.class);
        this.appendParentInfo((PsiElement)(clazz != null ? clazz : parent.getContainingFile()), builder, (PsiNamedElement)parent);
        builder.append(parent.getName()).append(" ").append(valuePair.getSimpleValue());
        return builder.toString();
    }

    @Nullable
    private String createQuickNavigateForFunction(JSFunction function) {
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        StringBuilder result = new StringBuilder();
        this.appendParentInfo(parent, result, (PsiNamedElement)function);
        JSDocumentationProvider.appendAttrList((JSAttributeListOwner)function, result);
        boolean get = function.isGetProperty();
        boolean set = function.isSetProperty();
        result.append(get || set ? "property " : "function ");
        result.append(function.getName());
        if (!get && !set) {
            result.append('(');
            JSParameterList jsParameterList = function.getParameterList();
            if (jsParameterList != null) {
                int start = result.length();
                for (JSParameter p : jsParameterList.getParameters()) {
                    if (start != result.length()) {
                        result.append(", ");
                    }
                    result.append(p.getName());
                    JSDocumentationProvider.appendVarType((JSVariable)p, result);
                }
            }
            result.append(')');
        }
        String varType = null;
        if (get || !set) {
            JSType type = function.getReturnType();
            varType = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
        } else {
            JSParameter[] jsParameters;
            JSParameterList jsParameterList = function.getParameterList();
            if (jsParameterList != null && (jsParameters = jsParameterList.getParameters()).length > 0) {
                JSType type = jsParameters[0].getType();
                varType = type != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
            }
        }
        JSDocumentationProvider.appendType(result, varType);
        return result.toString();
    }

    protected void appendParentInfo(PsiElement parent, StringBuilder builder, PsiNamedElement element) {
        if (parent instanceof JSClass) {
            builder.append(((JSClass)parent).getQualifiedName()).append("\n");
        } else if (parent instanceof JSFile && parent.getContext() == null) {
            builder.append(parent.getContainingFile().getName()).append("\n");
        }
    }

    @Nullable
    private String createQuickNavigateForVariable(JSVariable variable) {
        JSExpression initializer;
        PsiElement parent = JSResolveUtil.findParent((PsiElement)variable);
        StringBuilder result = new StringBuilder();
        this.appendParentInfo(parent, result, (PsiNamedElement)variable);
        JSDocumentationProvider.appendAttrList((JSAttributeListOwner)variable, result);
        result.append(variable.isConst() ? "const " : "var ");
        result.append(variable.getName());
        JSDocumentationProvider.appendVarType(variable, result);
        String initializerText = variable.getLiteralOrReferenceInitializerText();
        if (initializerText == null && variable.hasInitializer() && (initializer = variable.getInitializer()) != null) {
            initializerText = initializer.getText();
        }
        if (initializerText != null) {
            int maxInitStringLengthToShow = 50;
            if (initializerText.length() > maxInitStringLengthToShow) {
                initializerText = initializerText.substring(0, maxInitStringLengthToShow) + "...";
            }
            result.append(" = ").append(StringUtil.escapeXml((String)initializerText));
        }
        return result.toString();
    }

    private static void appendVarType(JSVariable variable, StringBuilder builder) {
        JSType type = variable.getType();
        if (type != null) {
            JSDocumentationProvider.appendType(builder, type.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
        }
    }

    private static void appendType(StringBuilder builder, String varType) {
        if (!StringUtil.isEmpty((String)varType)) {
            builder.append(':').append(StringUtil.escapeXml((String)varType));
        }
    }

    @Nullable
    private static String createQuickNavigateForClazz(JSClass jsClass) {
        String qName = jsClass.getQualifiedName();
        if (qName == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        if (packageName.length() > 0) {
            result.append(packageName).append("\n");
        }
        JSDocumentationProvider.appendAttrList((JSAttributeListOwner)jsClass, result);
        if (jsClass.isInterface()) {
            result.append("interface");
        } else {
            result.append("class");
        }
        String name = jsClass.getName();
        result.append(" ").append(name);
        String s = JSDocumentationProvider.generateReferenceTargetList(jsClass.getExtendsList(), packageName);
        if (s == null && !OBJECT_NAME.equals(name)) {
            s = OBJECT_NAME;
        }
        if (s != null) {
            result.append(" extends ").append(s);
        }
        if ((s = JSDocumentationProvider.generateReferenceTargetList(jsClass.getImplementsList(), packageName)) != null) {
            result.append("\nimplements ").append(s);
        }
        return result.toString();
    }

    @Nullable
    private static String createQuickNavigateForNamespace(JSNamespaceDeclaration ns) {
        String qName = ns.getQualifiedName();
        if (qName == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        if (packageName.length() > 0) {
            result.append(packageName).append("\n");
        }
        result.append("namespace");
        String name = ns.getName();
        result.append(" ").append(name);
        String s = ns.getInitialValueString();
        if (s != null) {
            result.append(" = ").append(s);
        }
        return result.toString();
    }

    private static void appendAttrList(JSAttributeListOwner owner, StringBuilder result) {
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList != null) {
            PsiElement parent;
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.OVERRIDE);
            JSAttributeList.AccessType type = attributeList.getAccessType();
            String ns = JSResolveUtil.getNamespaceValue(attributeList);
            if (ns == null && ((parent = JSResolveUtil.findParent((PsiElement)owner)) instanceof JSPackageStatement || parent instanceof JSClass || parent instanceof JSFile)) {
                ns = JSFormatUtil.formatVisibility(type, (PsiElement)owner);
            }
            if (ns != null) {
                result.append(ns);
                result.append(" ");
            }
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.STATIC);
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.FINAL);
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.DYNAMIC);
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.NATIVE);
        }
    }

    private static void appendModifier(StringBuilder result, JSAttributeList attributeList, JSAttributeList.ModifierType modifier) {
        if (attributeList.hasModifier(modifier)) {
            result.append(modifier.keyword).append(" ");
        }
    }

    @Nullable
    private static String generateReferenceTargetList(@Nullable JSReferenceList implementsList, @NotNull String packageName) {
        String[] referenceExpressionTexts;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "generateReferenceTargetList"));
        }
        if (implementsList == null) {
            return null;
        }
        StringBuilder result = null;
        for (String refExprText : referenceExpressionTexts = implementsList.getReferenceTexts()) {
            refExprText = JSImportHandlingUtil.resolveTypeName(refExprText, (PsiElement)implementsList);
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(",");
            }
            String referencedPackageName = StringUtil.getPackageName((String)refExprText);
            result.append(referencedPackageName.equals(packageName) ? refExprText.substring(refExprText.lastIndexOf(46) + 1) : refExprText);
        }
        return result == null ? null : result.toString();
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String possibleCssName = JSDocumentationProvider.findPossibleCssName(element);
        List cssUrls = possibleCssName != null ? Arrays.asList(CssDocumentationProvider.getUrlsFor((String)possibleCssName, (PsiElement)element)) : Collections.emptyList();
        return cssUrls.isEmpty() ? JSDocumentationProvider.collectExternalUrls(element) : cssUrls;
    }

    @Nullable
    private static List<String> collectExternalUrls(PsiElement element) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (dialect == null || !dialect.isJavaScript()) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        Project project = element.getProject();
        List<PsiElement> candidateElements = JSDocumentationUtils.getElementsForExternalDocumentation(element);
        ScriptingLibraryManager libManager = (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
        for (PsiElement docElement : candidateElements) {
            VirtualFile libFile = docElement.getContainingFile().getVirtualFile();
            if (libFile == null) continue;
            for (String baseUrl : libManager.getDocUrlsFor(libFile)) {
                String elementFQN = docElement instanceof JSPsiElementBase ? ((JSPsiElementBase)docElement).getQualifiedName() : null;
                if (elementFQN == null) continue;
                if (libFile.getPath().contains("nodejs")) {
                    elementFQN = JSDocumentationProvider.patchNodejsFQN(elementFQN, libFile);
                    String parameterSignature = JSDocumentationProvider.getParameterSignature(docElement);
                    elementFQN = elementFQN + parameterSignature;
                }
                String relativeUrl = JSDocumentationUtils.getLibDocRelativeUrl(baseUrl, elementFQN);
                urls.add(baseUrl + (baseUrl.endsWith("/") || StringUtil.isEmpty((String)relativeUrl) ? "" : "/") + relativeUrl);
            }
        }
        return urls.isEmpty() ? null : urls;
    }

    private static String patchNodejsFQN(@NotNull String fqn, @NotNull VirtualFile libFile) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "patchNodejsFQN"));
        }
        if (libFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libFile", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "patchNodejsFQN"));
        }
        String fileName = libFile.getName();
        fileName = StringUtil.trimEnd((String)fileName, (String)".js");
        if (fqn.startsWith("exports.")) {
            return fqn.replaceAll("^exports", fileName);
        }
        if (fqn.startsWith(fileName)) {
            return fqn;
        }
        return fileName + "." + fqn;
    }

    private static String getParameterSignature(PsiElement element) {
        StringBuilder parameterBuf = new StringBuilder();
        if (element instanceof JSFunction) {
            JSFunction function = (JSFunction)element;
            for (JSParameter parameter : function.getParameterVariables()) {
                parameterBuf.append('%').append(parameter.getName());
            }
        }
        return parameterBuf.toString();
    }

    public String generateDoc(PsiElement _element, PsiElement originalElement) {
        String cssDoc;
        String possibleCssName;
        if (_element instanceof JSImplicitElement) {
            return this.getDocumentationForImplicitElement((JSImplicitElement)_element);
        }
        if (_element.getParent() instanceof PsiComment) {
            _element = _element.getParent();
        }
        if (_element instanceof PsiComment) {
            return this.doGetCommentTextFromComment((PsiComment)_element, originalElement);
        }
        if (_element instanceof JSReferenceExpression) {
            StringBuilder buffer = null;
            JSReferenceExpression expression = (JSReferenceExpression)_element;
            ResolveResult[] results = expression.multiResolve(false);
            results = JSResolveUtil.filterResolveResultsByLibraryScope(originalElement, results);
            JSResolveUtil.stableResolveOrder(results);
            int linkCount = 0;
            String linkedDoc = null;
            for (ResolveResult r : results) {
                PsiElement element = r.getElement();
                String _linkedDoc = this.generateDoc(element, originalElement);
                if (_linkedDoc == null || _linkedDoc.trim().isEmpty()) continue;
                linkedDoc = _linkedDoc;
                ItemPresentation presentation = ((NavigationItem)element).getPresentation();
                if (presentation == null) continue;
                if (buffer == null) {
                    buffer = new StringBuilder();
                }
                JSDocumentationUtils.appendHyperLinkToElement(element, expression.getReferencedName(), buffer, presentation.getPresentableText(), presentation.getLocationString());
                buffer.append("<br/>\n");
                ++linkCount;
            }
            if (linkedDoc != null && linkCount == 1) {
                return linkedDoc;
            }
            if (buffer == null) {
                return results.length == 0 ? "Can not find source for " + expression.getText() : "No documentation found in source code.";
            }
            return buffer.toString();
        }
        _element = _element.getNavigationElement();
        PsiElement element = JSDocumentationProvider.findElementForWhichPreviousCommentWillBeSearched(_element);
        boolean parameterDoc = element instanceof JSParameter;
        if (element != null) {
            ASTNode initialComment;
            PsiElement meaningfulElement;
            PsiComment docComment = JSDocumentationUtils.findDocComment(element, (PsiElement)(_element instanceof JSAttributeNameValuePair ? originalElement : null), (Ref<PsiElement>)Ref.create(null));
            if (docComment == null && (docComment = JSDocumentationUtils.findDocComment(meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element))) != null) {
                element = meaningfulElement;
            }
            if (docComment != null) {
                docComment = JSDocumentationProvider.findFirstDocComment((PsiElement)docComment);
                element = JSDocumentationProvider.findTargetElement(_element, element);
                JSType elementType = JSTypeUtils.getTypeOfElement(element);
                boolean isTypeOnlyComment = docComment instanceof PsiComment && elementType != null && elementType.isEquivalentTo(JSDocumentationUtils.tryCreateTypeFromComment(docComment, true, true, false), null);
                JSDocumentationBuilder builder = new JSDocumentationBuilder(element, originalElement, this.myShowNamedItem, this);
                if (!isTypeOnlyComment) {
                    JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), builder);
                }
                builder.addEvaluatedType();
                return parameterDoc ? builder.getParameterDoc(((JSParameter)_element).getName()) : builder.getDoc();
            }
            if ((element = JSDocumentationProvider.findTargetElement(_element, element)) instanceof JSFunction && (initialComment = JSDocumentationUtils.findLeadingCommentInFunctionBody(element)) != null) {
                JSDocumentationBuilder builder = new JSDocumentationBuilder(element, originalElement, true, this);
                JSDocumentationUtils.processDocumentationTextFromComment(initialComment, builder);
                builder.addEvaluatedType();
                return builder.getDoc();
            }
        }
        if ((possibleCssName = JSDocumentationProvider.findPossibleCssName(_element)) != null && (cssDoc = CssDocumentationProvider.generateDoc((String)possibleCssName, (PsiElement)_element, null)) != null) {
            return cssDoc;
        }
        JSDocumentationBuilder builder = this.createDocumentationBuilder(element, null, false);
        return builder.addEvaluatedType() ? builder.getDoc() : null;
    }

    @NotNull
    protected JSDocumentationBuilder createDocumentationBuilder(PsiElement element, PsiElement _contextElement, boolean showNamedItem) {
        JSDocumentationBuilder jSDocumentationBuilder = new JSDocumentationBuilder(element, _contextElement, showNamedItem, this);
        if (jSDocumentationBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "createDocumentationBuilder"));
        }
        return jSDocumentationBuilder;
    }

    protected PsiElement findCommentForImplicitElement(PsiElement _element) {
        PsiElement parent = _element.getParent();
        boolean hasStub = parent instanceof StubBasedPsiElement && ((StubBasedPsiElement)parent).getStub() != null;
        PsiElement expression = PsiTreeUtil.getNonStrictParentOfType((PsiElement)parent, (Class[])new Class[]{hasStub ? JSExpression.class : JSStatement.class, JSFunction.class, JSDocComment.class});
        return expression != null ? JSDocumentationUtils.findDocComment(expression) : null;
    }

    @Nullable
    protected String doGetCommentTextFromComment(@NotNull PsiComment _element, PsiElement originalElement) {
        if (_element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_element", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "doGetCommentTextFromComment"));
        }
        LookupEx activeLookup = LookupManager.getInstance((Project)_element.getProject()).getActiveLookup();
        LookupElement currentItem = activeLookup != null ? activeLookup.getCurrentItem() : null;
        JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)_element, originalElement, true, this);
        JSDocumentationUtils.processDocumentationTextFromComment(_element.getNode(), builder);
        return builder.getDoc();
    }

    @Nullable
    private String getDocumentationForImplicitElement(@NotNull JSImplicitElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "getDocumentationForImplicitElement"));
        }
        PsiElement comment = this.findCommentForImplicitElement((PsiElement)element);
        if (comment instanceof PsiComment) {
            JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)element, (PsiElement)element, true, this);
            JSDocumentationUtils.processDocumentationTextFromComment(comment.getNode(), builder);
            return builder.getDoc();
        }
        return null;
    }

    private static PsiElement findTargetElement(PsiElement _element, PsiElement element) {
        if (_element instanceof JSDefinitionExpression) {
            PsiElement parentElement = _element.getParent();
            if (parentElement instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)parentElement).getROperand();
                element = rOperand instanceof JSFunctionExpression ? rOperand : _element;
            }
        } else if (_element instanceof JSFunctionExpression) {
            element = _element;
        } else if (_element instanceof JSProperty) {
            JSExpression expression = ((JSProperty)_element).getValue();
            if (expression instanceof JSFunction) {
                element = expression;
            }
        } else if (_element instanceof JSVariable) {
            if (_element instanceof JSParameter) {
                return PsiTreeUtil.getParentOfType((PsiElement)_element, JSFunction.class);
            }
            element = _element;
        } else if (_element instanceof JSAttributeNameValuePair) {
            return _element;
        }
        return element;
    }

    @NotNull
    private static PsiElement findFirstDocComment(@NotNull PsiElement docComment) {
        if (docComment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "findFirstDocComment"));
        }
        if (docComment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            while (true) {
                PsiElement prev;
                if ((prev = docComment.getPrevSibling()) instanceof PsiWhiteSpace) {
                    prev = prev.getPrevSibling();
                }
                if (prev == null || prev.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) break;
                docComment = prev;
            }
        }
        PsiElement psiElement = docComment;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "findFirstDocComment"));
        }
        return psiElement;
    }

    @Nullable
    private static String findPossibleCssName(PsiElement _element) {
        JSExpression expression;
        if (_element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)_element).getExpression()) instanceof JSReferenceExpression) {
            String text = ((JSReferenceExpression)expression).getReferencedName();
            if (text == null) {
                return null;
            }
            if (text.length() > 0 && Character.isUpperCase(text.charAt(0))) {
                return null;
            }
            StringBuilder buf = new StringBuilder(text.length());
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isUpperCase(ch)) {
                    buf.append('-').append(Character.toLowerCase(ch));
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof LookupItem) {
            object = ((LookupItem)object).getObject();
        }
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        PsiElement resolve;
        PsiReference[] references;
        int delimiterIndex = link.lastIndexOf("%");
        if (delimiterIndex != -1) {
            return JSDocumentationProvider.resolveDocumentLink(psiManager, link, delimiterIndex);
        }
        if (context != null && (references = new JSDocReferenceSet(context, link, 0, false).getReferences()).length > 0 && (resolve = references[references.length - 1].resolve()) != null) {
            return resolve;
        }
        return null;
    }

    protected static PsiElement resolveDocumentLink(PsiManager psiManager, String link, int delimiterIndex) {
        Project project = psiManager.getProject();
        int delimiterIndex2 = link.lastIndexOf("%", delimiterIndex - 1);
        if (delimiterIndex2 == -1) {
            return null;
        }
        String fileName = link.substring(0, delimiterIndex2).replace(File.separatorChar, '/');
        String name = link.substring(delimiterIndex2 + 1, delimiterIndex);
        String qualifier = link.substring(delimiterIndex + 1);
        boolean isGlobal = "null".equals(qualifier);
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)fileName, null);
        if (relativeFile == null) {
            relativeFile = JSResolveUtil.findPredefinedOrLibraryFile(project, fileName);
        }
        final Ref result = new Ref();
        if (relativeFile != null) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)relativeFile);
            String qName = isGlobal ? name : qualifier + "." + name;
            JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, fileScope, new Processor<JSPsiElementBase>(){

                public boolean process(JSPsiElementBase base) {
                    result.set((Object)base);
                    return false;
                }
            });
        }
        return (PsiElement)result.get();
    }

    public static PsiElement findElementForWhichPreviousCommentWillBeSearched(Object object) {
        if (object instanceof JSFunction) {
            PsiElement psiElement = (PsiElement)object;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof JSNewExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof JSProperty) {
                psiElement = parent;
            } else if (parent instanceof JSAssignmentExpression) {
                psiElement = parent.getParent();
            }
            JSFunction function = (JSFunction)object;
            if (function.isSetProperty() || function.isGetProperty()) {
                for (PsiElement el = function.getPrevSibling(); el != null; el = el.getPrevSibling()) {
                    PsiComment doc;
                    JSFunction prevFunction;
                    String name;
                    if (el instanceof PsiWhiteSpace || el instanceof PsiComment) continue;
                    if (!(el instanceof JSFunction) || (name = (prevFunction = (JSFunction)el).getName()) == null || !name.equals(function.getName()) || (!prevFunction.isGetProperty() || !function.isSetProperty()) && (!prevFunction.isSetProperty() || !function.isGetProperty()) || (doc = JSDocumentationUtils.findDocComment((PsiElement)prevFunction)) == null) break;
                    return prevFunction;
                }
            }
            return psiElement;
        }
        if (object instanceof JSProperty || object instanceof JSStatement || object instanceof JSClass) {
            return (PsiElement)object;
        }
        if (object instanceof PsiElement) {
            PsiElement parent = ((PsiElement)object).getParent();
            if (parent instanceof JSAssignmentExpression) {
                return SharedImplUtil.getParent((ASTNode)parent.getNode());
            }
            if (parent instanceof JSAttribute) {
                PsiElement grandParent = parent.getParent();
                if (grandParent.getFirstChild() == parent) {
                    PsiElement element = grandParent.getParent();
                    if (element instanceof JSFile) {
                        return grandParent;
                    }
                    return element;
                }
                return parent;
            }
            return (PsiElement)object;
        }
        return null;
    }

    @Nullable
    public PsiComment findExistingDocComment(PsiComment contextElement) {
        return contextElement;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        if (startPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startPoint", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "parseContext"));
        }
        JSElement context = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startPoint, (Class[])new Class[]{JSProperty.class, JSFunction.class, JSExpressionStatement.class, JSVarStatement.class});
        if (context != null) {
            return Pair.create((Object)context, (Object)JSDocumentationUtils.findDocComment((PsiElement)context));
        }
        return null;
    }

    @Nullable
    public String generateDocumentationContentStub(PsiComment contextComment) {
        PsiElement el = JSDocumentationUtils.findAttachedElementFromComment(contextComment);
        if (el instanceof JSFunction) {
            return JSDocumentationProvider.doGenerateDoc((JSFunction)el);
        }
        if (el instanceof JSProperty) {
            JSExpression propertyValue = ((JSProperty)el).getValue();
            if (propertyValue instanceof JSFunction) {
                return JSDocumentationProvider.doGenerateDoc((JSFunction)propertyValue);
            }
        } else if (el instanceof JSDefinitionExpression) {
            PsiElement expression = el.getParent();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                if (rOperand instanceof JSFunctionExpression) {
                    return JSDocumentationProvider.doGenerateDoc((JSFunction)rOperand);
                }
                return JSDocumentationProvider.doGenerateDoc(rOperand);
            }
        } else if (el instanceof JSVariable) {
            JSExpression expression = ((JSVariable)el).getInitializer();
            if (expression instanceof JSFunctionExpression) {
                return JSDocumentationProvider.doGenerateDoc((JSFunction)expression);
            }
            return JSDocumentationProvider.doGenerateDoc(expression);
        }
        return null;
    }

    @Nullable
    private static String doGenerateDoc(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)expression.getProject());
        if (dumbService.isDumb()) {
            return null;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(expression);
        if (jsType == null || jsType instanceof JSVoidType || jsType instanceof JSAnyType && !jsType.getSource().isExplicitlyDeclared()) {
            return null;
        }
        String type = jsType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        type = JSTypeUtils.transformActionScriptSpecificTypesIntoEcma(type);
        StringBuilder builder = new StringBuilder();
        builder.append("* @type {").append(type).append("}\n");
        String name = null;
        PsiElement parent = expression.getParent();
        if (parent instanceof JSNamedElement) {
            name = ((JSNamedElement)parent).getName();
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression operand = ((JSAssignmentExpression)parent).getLOperand();
            if (operand instanceof JSDefinitionExpression) {
                operand = ((JSDefinitionExpression)operand).getExpression();
            }
            if (operand instanceof JSReferenceExpression) {
                name = ((JSReferenceExpression)operand).getReferencedName();
            }
        }
        if (!StringUtil.isEmpty((String)name)) {
            JSDocumentationProvider.appendPrivate(builder, name);
        }
        return builder.toString();
    }

    private static String doGenerateDoc(@NotNull JSFunction function) {
        DumbService dumbService;
        boolean ecma;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/documentation/JSDocumentationProvider", "doGenerateDoc"));
        }
        StringBuilder builder = new StringBuilder();
        JSParameterList parameterList = function.getParameterList();
        PsiFile containingFile = function.getContainingFile();
        boolean bl = ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (parameterList != null) {
            for (JSParameter parameter : parameterList.getParameters()) {
                builder.append("* @param ").append(parameter.getName());
                builder.append("\n");
            }
        }
        if ((dumbService = DumbService.getInstance((Project)function.getProject())).isDumb()) {
            return builder.toString();
        }
        if (ecma) {
            JSType type = JSPsiImplUtils.getTypeFromDeclaration((JSNamedElement)function);
            if (type != null && !"void".equals(type.getTypeText()) && !function.isGetProperty()) {
                builder.append("* @return ");
                builder.append("\n");
            }
        } else {
            JSQualifiedNamedElement initializedElement;
            JSType type = TypeFromUsageDetector.detectTypeFromUsage((PsiElement)function, containingFile);
            if (type != null && !(type instanceof JSVoidType)) {
                String typeString = JSTypeUtils.transformActionScriptSpecificTypesIntoEcma(type.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
                builder.append("* @").append(JSDocumentationProvider.getReturnTag()).append(" {").append(typeString).append("}\n");
            }
            String name = function.getName();
            if (function instanceof JSExpression && (initializedElement = JSStubBasedPsiTreeUtil.getInitializedElement((JSExpression)function)) != null) {
                name = initializedElement.getName();
            }
            if (!StringUtil.isEmpty((String)name)) {
                if (Character.isUpperCase(name.charAt(0))) {
                    builder.append("* @constructor\n");
                }
                JSDocumentationProvider.appendPrivate(builder, name);
            }
        }
        return builder.toString();
    }

    public static String getReturnTag() {
        return PropertiesComponent.getInstance().getValue(RETURN_TAG_PROPERTY, "returns");
    }

    public static void setReturnTag(String returnTag) {
        PropertiesComponent.getInstance().setValue(RETURN_TAG_PROPERTY, returnTag);
    }

    private static void appendPrivate(StringBuilder builder, String name) {
        if (name.endsWith("_") || name.startsWith("_")) {
            builder.append("* @private\n");
        }
    }

    @Nullable
    public String tryGetSeeAlsoLink(String remainingLineContent, PsiElement element) {
        PsiElement resolvedElement = this.getDocumentationElementForLink(element.getManager(), remainingLineContent, element);
        if (resolvedElement != null) {
            return remainingLineContent;
        }
        return null;
    }
}

