/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.HashSet;
import java.lang.ref.Reference;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExternalLibraryDocBundle {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String BUNDLE = "com.intellij.lang.javascript.documentation.JSExternalLibraryDoc";
    @NonNls
    private static final String BASE_URL = "baseUrl";
    @NonNls
    private static final String RULES = "rules";
    @NonNls
    private static final String PREFIX = "prefix";
    @NonNls
    private static final String ELEMENT = "element";
    @NonNls
    private static final String PATTERNS = "patterns";
    @NonNls
    private static final String LOWER_CASE = "lowerCase";
    @NonNls
    private static final String OFFLINE_DOC_URL = "offlineDocUrl";
    @NonNls
    private static final String OFFLINE_DOC_EXT = "offlineDocExt";
    @NonNls
    private static final String OFFLINE_DOC_PROVIDER = "offlineDocProvider";
    @NonNls
    private static final String LIBRARY_NAME = "name";
    @NonNls
    private static final String VERSION_MATCHER = "versionMatcher";

    private JSExternalLibraryDocBundle() {
    }

    @Nullable
    public static String getBaseURLKey(String baseUrl) {
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleUrl;
            if (!key.endsWith(BASE_URL) || !baseUrl.startsWith(bundleUrl = JSExternalLibraryDocBundle.getBundle().getString(key))) continue;
            return key.replace(".baseUrl", "");
        }
        return null;
    }

    @Nullable
    public static String getBaseKey(String name, String version) {
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleName;
            if (!key.endsWith(LIBRARY_NAME) || (bundleName = JSExternalLibraryDocBundle.getBundle().getString(key)) == null || !bundleName.equals(name)) continue;
            String baseKey = key.replace(".name", "");
            if (version == null) {
                return baseKey;
            }
            String versionMatcher = JSExternalLibraryDocBundle.getBundle().getString(baseKey + "." + VERSION_MATCHER);
            if (versionMatcher == null || !version.matches(versionMatcher)) continue;
            return baseKey;
        }
        return null;
    }

    @NotNull
    public static String getRules(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getRules"));
        }
        String rules = JSExternalLibraryDocBundle.getProperty(baseKey, RULES, true);
        assert (rules != null);
        String string = rules;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getRules"));
        }
        return string;
    }

    @NotNull
    public static String getPrefix(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getPrefix"));
        }
        String prefix = JSExternalLibraryDocBundle.getProperty(baseKey, PREFIX, true);
        assert (prefix != null);
        String string = prefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getPrefix"));
        }
        return string;
    }

    @Nullable
    public static String getBaseUrl(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getBaseUrl"));
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, BASE_URL, false);
    }

    @Nullable
    public static String getPatterns(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getPatterns"));
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, PATTERNS, false);
    }

    @Nullable
    public static String getOfflineDocProvider(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getOfflineDocProvider"));
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, OFFLINE_DOC_PROVIDER, false);
    }

    @Nullable
    public static String getLibraryName(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getLibraryName"));
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, LIBRARY_NAME, false);
    }

    @Nullable
    public static String getVersionMatcher(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getVersionMatcher"));
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, VERSION_MATCHER, false);
    }

    public static boolean isLowerCase(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "isLowerCase"));
        }
        String lowerCase = JSExternalLibraryDocBundle.getProperty(baseKey, LOWER_CASE, false);
        if (lowerCase == null) {
            return false;
        }
        return Boolean.parseBoolean(lowerCase);
    }

    @Nullable
    private static String getProperty(@NotNull String baseKey, String propertyName, boolean notNull) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getProperty"));
        }
        String prefixKey = baseKey + "." + propertyName;
        ResourceBundle bundle = JSExternalLibraryDocBundle.getBundle();
        return bundle.containsKey(prefixKey) ? bundle.getString(prefixKey) : (notNull ? "" : null);
    }

    @Nullable
    public static String getElementUrl(@NotNull String baseKey, @NotNull String elementFQN) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getElementUrl"));
        }
        if (elementFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFQN", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getElementUrl"));
        }
        String elementKey = baseKey + "." + ELEMENT + "." + elementFQN;
        if (!JSExternalLibraryDocBundle.getBundle().containsKey(elementKey)) {
            return null;
        }
        return JSExternalLibraryDocBundle.getBundle().getString(elementKey);
    }

    @Nullable
    public static String getOfflineDocUrl(@NotNull String baseKey) {
        if (baseKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseKey", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getOfflineDocUrl"));
        }
        return JSExternalLibraryDocBundle.getProperty(baseKey, OFFLINE_DOC_URL, false);
    }

    @NotNull
    public static String getOfflineDocExt(@NotNull String offlineDocUrl) {
        if (offlineDocUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", OFFLINE_DOC_URL, "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getOfflineDocExt"));
        }
        String baseKey = null;
        String ext = null;
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleUrl;
            if (!key.endsWith(OFFLINE_DOC_URL) || !offlineDocUrl.equals(bundleUrl = JSExternalLibraryDocBundle.getBundle().getString(key))) continue;
            baseKey = key.replace(".offlineDocUrl", "");
            break;
        }
        if (baseKey != null) {
            ext = JSExternalLibraryDocBundle.getProperty(baseKey, OFFLINE_DOC_EXT, true);
        }
        String string = ext == null ? "" : ext;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "getOfflineDocExt"));
        }
        return string;
    }

    @Nullable
    public static String findMatchingDocKey(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/lang/javascript/documentation/JSExternalLibraryDocBundle", "findMatchingDocKey"));
        }
        for (String key : JSExternalLibraryDocBundle.getBundle().keySet()) {
            String bundleUrl;
            String targetName;
            if (!key.endsWith(OFFLINE_DOC_URL) || !filePath.contains(targetName = JSLibraryUtil.makeUniqueFileName(bundleUrl = JSExternalLibraryDocBundle.getBundle().getString(key), false))) continue;
            return key.replace(".offlineDocUrl", "");
        }
        return null;
    }

    public static Set<String> getBasePatternKeys() {
        ResourceBundle bundle = JSExternalLibraryDocBundle.getBundle();
        HashSet patternKeys = new HashSet();
        for (String key : bundle.keySet()) {
            if (!key.endsWith(PATTERNS)) continue;
            patternKeys.add(key.replace(".patterns", ""));
        }
        return patternKeys;
    }

    private static ResourceBundle getBundle() {
        ResourceBundle bundle = (ResourceBundle)SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }
}

