/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TypeScriptQualifiedItemProcessor<T extends ResultSink>
extends QualifiedItemProcessor<T> {
    protected Map<String, JSType> myGenericArguments;

    public TypeScriptQualifiedItemProcessor(T sink, PsiFile containingFile) {
        super(sink, containingFile);
    }

    public static boolean processNamespaceChildren(ResolveProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, JSQualifiedNamedElement element) {
        if (element instanceof JSVariable) {
            if (processor.getAccessibilityProcessingHandler().isProcessStatics() && !JSResolveUtil.processDeclarationsInScope((JSElement)element, processor, state, lastParent, place)) {
                return false;
            }
        } else {
            if (element instanceof TypeScriptImportStatement) {
                return true;
            }
            if (!element.processDeclarations((PsiScopeProcessor)processor, state, lastParent, place)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull JSType _type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "process"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "process"));
        }
        JSType type = JSTypeUtils.unwrapDecorations(_type);
        if (type instanceof JSNamedType) {
            this.setProcessStatics(((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC);
        }
        String name = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (name != null && sourceElement != null) {
            SmartList elements;
            if (source instanceof JSQualifiedNamedElement && name.equals(((JSQualifiedNamedElement)source).getQualifiedName()) && TypeScriptPsiUtil.isNamedTypeDefinition(source)) {
                elements = Collections.singleton((JSQualifiedNamedElement)source);
            } else {
                PsiElement sourceToResolve = sourceElement;
                if (JavaScriptIndex.LIBS_D_TS.contains(sourceElement.getContainingFile().getName()) && this.place != null) {
                    sourceToResolve = this.place;
                }
                JSTypeResolveResult resolveResult = TypeScriptImportHandler.getInstance().resolveTypeName(name, sourceToResolve);
                elements = new SmartList();
                for (PsiElement psiElement : resolveResult.getElements()) {
                    if (!(psiElement instanceof JSQualifiedNamedElement)) continue;
                    elements.add((JSQualifiedNamedElement)psiElement);
                }
            }
            if (!elements.isEmpty()) {
                List<JSType> arguments;
                List<Object> list = type instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)type).getArguments() : (arguments = type instanceof JSArrayTypeImpl ? Collections.singletonList(((JSArrayTypeImpl)type).getType()) : null);
                if (arguments != null) {
                    TypeScriptTypeParameterList typeParameterList;
                    JSClass aClass = null;
                    for (JSQualifiedNamedElement jSQualifiedNamedElement : elements) {
                        if (!(jSQualifiedNamedElement instanceof JSClass)) continue;
                        aClass = (JSClass)jSQualifiedNamedElement;
                        break;
                    }
                    if (aClass instanceof TypeScriptTypeParameterListOwner && (typeParameterList = ((TypeScriptTypeParameterListOwner)aClass).getTypeParameterList()) != null) {
                        this.myGenericArguments = new THashMap();
                        TypeScriptTypeParameter[] typeScriptTypeParameterArray = typeParameterList.getTypeParameters();
                        for (int i = 0; i < Math.min(typeScriptTypeParameterArray.length, arguments.size()); ++i) {
                            this.myGenericArguments.put(typeScriptTypeParameterArray[i].getName(), arguments.get(i));
                        }
                    }
                }
                for (JSQualifiedNamedElement element : elements) {
                    if (element instanceof TypeScriptTypeAlias) {
                        JSType jSType = ((TypeScriptTypeAlias)element).getParsedTypeDeclaration();
                        if (jSType == null || evaluateContext.isAlreadyProcessingItem((PsiElement)element)) continue;
                        try {
                            evaluateContext.addProcessingItem((PsiElement)element);
                            this.process(JSTypeUtils.applyGenericArguments(jSType, this.myGenericArguments), evaluateContext, source);
                            continue;
                        }
                        finally {
                            evaluateContext.removeProcessingItem((PsiElement)element);
                            continue;
                        }
                    }
                    boolean bl = this.isLocalResolve();
                    boolean isModule = element instanceof TypeScriptModule;
                    if (isModule) {
                        this.setLocalResolve(true);
                    }
                    TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), (PsiElement)element, this.place, element);
                    if (!isModule) continue;
                    this.setLocalResolve(bl);
                }
                if (type.getSource().isExplicitlyDeclared() && this.place != null && DialectDetector.isTypeScript(this.place)) {
                    this.resolved = QualifiedItemProcessor.TypeResolveState.Resolved;
                }
            }
        }
        super.process(_type, evaluateContext, source);
        this.myGenericArguments = null;
    }
}

