/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.nashorn.NashornHeredoc;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesLineFilter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class JSStripTrailingSpacesFilter
extends PsiBasedStripTrailingSpacesLineFilter {
    protected boolean isApplicableTo(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilter", "isApplicableTo"));
        }
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    protected boolean apply(final @NotNull Document document, @NotNull PsiFile psiFile, final @NotNull BitSet disabledLinesBitSet) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilter", "apply"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilter", "apply"));
        }
        if (disabledLinesBitSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledLinesBitSet", "com/intellij/lang/javascript/editing/JSStripTrailingSpacesFilter", "apply"));
        }
        JSRecursiveElementVisitor visitor = new JSRecursiveElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (node.getNode().getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION) {
                    this.disableAllLinesContainingElement((PsiElement)node);
                }
            }

            public void visitNashornHeredoc(NashornHeredoc nashornHeredoc) {
                this.disableAllLinesContainingElement((PsiElement)nashornHeredoc);
            }

            private void disableAllLinesContainingElement(PsiElement node) {
                TextRange range = node.getTextRange();
                int startLine = document.getLineNumber(range.getStartOffset());
                int endLine = document.getLineNumber(range.getEndOffset());
                disabledLinesBitSet.set(startLine, endLine);
            }
        };
        psiFile.accept((PsiElementVisitor)visitor);
        return true;
    }
}

