/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;

public class JSReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public static JSReadWriteAccessDetector ourInstance = new JSReadWriteAccessDetector();

    public boolean isReadWriteAccessible(PsiElement element) {
        return element instanceof JSVariable || element instanceof JSFunction && (((JSFunction)element).isGetProperty() || ((JSFunction)element).isSetProperty()) || element instanceof JSDefinitionExpression;
    }

    public boolean isDeclarationWriteAccess(PsiElement element) {
        if (element instanceof JSVariable) {
            JSVariable var = (JSVariable)element;
            if (var.getInitializer() != null) {
                return true;
            }
            PsiElement parent = var.getParent();
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).getDeclarationStatement() == parent) {
                return true;
            }
        } else if (element instanceof JSDefinitionExpression) {
            return true;
        }
        return false;
    }

    public ReadWriteAccessDetector.Access getReferenceAccess(PsiElement referencedElement, PsiReference reference) {
        return this.getExpressionAccess(reference.getElement());
    }

    public ReadWriteAccessDetector.Access getExpressionAccess(PsiElement _expression) {
        PsiElement expression = _expression.getParent();
        if (this.isDeclarationWriteAccess(expression) && JSResolveUtil.isSelfReference(_expression)) {
            return ReadWriteAccessDetector.Access.Write;
        }
        if (_expression instanceof JSDefinitionExpression) {
            expression = _expression;
        }
        if (expression instanceof JSDefinitionExpression) {
            PsiElement grandParent = expression.getParent();
            if (grandParent instanceof JSAssignmentExpression && ((JSAssignmentExpression)grandParent).getOperationSign() == JSTokenTypes.EQ) {
                return ReadWriteAccessDetector.Access.Write;
            }
            return ReadWriteAccessDetector.Access.ReadWrite;
        }
        if (expression instanceof JSPrefixExpression ? JSReadWriteAccessDetector.isIncrementOrDecrement(((JSPrefixExpression)expression).getOperationSign()) : expression instanceof JSPostfixExpression && JSReadWriteAccessDetector.isIncrementOrDecrement(((JSPostfixExpression)expression).getOperationSign())) {
            return ReadWriteAccessDetector.Access.ReadWrite;
        }
        return ReadWriteAccessDetector.Access.Read;
    }

    private static boolean isIncrementOrDecrement(IElementType sign) {
        return sign == JSTokenTypes.PLUSPLUS || sign == JSTokenTypes.MINUSMINUS;
    }
}

