/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.template.HtmlTextContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXHtmlContextType
extends TemplateContextType {
    public JSXHtmlContextType() {
        super("JSX_HTML", JSBundle.message((String)"jsx.html.context.type", (Object[])new Object[0]), JavaScriptCodeContextType.class);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/react/JSXHtmlContextType", "isInContext"));
        }
        return JSXHtmlContextType.isInContext(file.findElementAt(offset), true);
    }

    public static boolean isInContext(@Nullable PsiElement context, boolean regularTemplate) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder == null || !holder.isJSX) {
            return false;
        }
        if (HtmlTextContextType.isInContext((PsiElement)context)) {
            return true;
        }
        PsiElement parent = context.getParent();
        if (!regularTemplate) {
            IElementType elementType = context.getNode().getElementType();
            return parent instanceof JSReferenceExpression || parent instanceof JSIndexedPropertyAccessExpression && elementType == JSTokenTypes.RBRACKET || parent instanceof JSLiteralExpression && !JSTokenTypes.STRING_LITERALS.contains(elementType);
        }
        return parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null;
    }
}

