/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.ChooseOneOrAllRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSExtendsImplementsHighlightingFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        PsiElement parent;
        IElementType elementType;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/highlighting/JSExtendsImplementsHighlightingFactory", "createHighlightUsagesHandler"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/highlighting/JSExtendsImplementsHighlightingFactory", "createHighlightUsagesHandler"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/javascript/highlighting/JSExtendsImplementsHighlightingFactory", "createHighlightUsagesHandler"));
        }
        ASTNode node = target.getNode();
        if (node != null && ((elementType = node.getElementType()) == JSTokenTypes.EXTENDS_KEYWORD || elementType == JSTokenTypes.IMPLEMENTS_KEYWORD) && (parent = target.getParent()) instanceof JSReferenceList) {
            return new JSExtendsImplementsHighlightUsagesHandler(editor, file, (JSReferenceList)parent);
        }
        return null;
    }

    private static class JSExtendsImplementsHighlightUsagesHandler
    extends HighlightUsagesHandlerBase<JSClass> {
        private final JSReferenceList myReferenceList;

        public JSExtendsImplementsHighlightUsagesHandler(Editor editor, PsiFile file, JSReferenceList referenceList) {
            super(editor, file);
            this.myReferenceList = referenceList;
        }

        public List<JSClass> getTargets() {
            return Arrays.asList(this.myReferenceList.getReferencedClasses());
        }

        protected void selectTargets(List<JSClass> targets, final Consumer<List<JSClass>> selectionConsumer) {
            new ChooseOneOrAllRunnable<JSClass>(targets, this.myEditor, "Choose Class", JSClass.class){

                protected void selected(JSClass ... classes) {
                    selectionConsumer.consume(Arrays.asList(classes));
                }

                protected PsiElementListCellRenderer<JSClass> createRenderer() {
                    return new JSQualifiedNamedElementRenderer<JSClass>();
                }
            }.run();
        }

        public void computeUsages(List<JSClass> targets) {
            JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this.myReferenceList, JSClass.class);
            if (clazz != null) {
                boolean extendsList = JSElementTypes.EXTENDS_LISTS.contains(this.myReferenceList.getNode().getElementType());
                for (JSFunction fun : clazz.getFunctions()) {
                    if (extendsList && !JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)fun, false, new PairFunction<List<JSFunction>, String, Boolean>(){

                        public Boolean fun(List<JSFunction> jsNamedElements, String s) {
                            return Boolean.FALSE;
                        }
                    }, true)) {
                        this.myReadUsages.add(fun.findNameIdentifier().getTextRange());
                        continue;
                    }
                    if (extendsList) continue;
                    boolean isImplemented = false;
                    for (JSFunction ifun : JSInheritanceUtil.findImplementedMethods(fun)) {
                        PsiElement parent = JSResolveUtil.findParent((PsiElement)ifun);
                        if (!(parent instanceof JSClass) || targets.indexOf(parent) == -1) continue;
                        isImplemented = true;
                        break;
                    }
                    if (!isImplemented) continue;
                    this.myReadUsages.add(fun.findNameIdentifier().getTextRange());
                }
            }
        }
    }
}

