/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.highlighting.TypeScriptHighlighter;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptColorSettingsPage
implements ColorSettingsPage {
    private static final String DEMO_TEXT = "module ModuleValidator {\n    import checkChars = CharUtils.notWhiteSpace;\n    export interface HasValidator<T> {\n        validateValue():Boolean;\n    }\n\n    class NotWhiteSpaceValidator implements HasValidator<String> {\n        /* Processed values */\n        static validatedValue:Array<String> = [\"\", \"aa\"];\n        private myValue:String;\n\n        /**\n         * Constructor for <code>NotWhiteSpaceValidator</code> class\n         * @param value for <i>validation</i>\n         */\n        constructor(valueParameter:String) {\n            this.myValue = valueParameter;\n            NotWhiteSpaceValidator.validatedValue.push(value);\n        }\n\n        public validateValue():Boolean {\n            var resultValue:Boolean = checkChars(this.myValue);\n            return resultValue;\n        }\n\n        static createInstance(valueParameter:String):NotWhiteSpaceValidator {\n            return new NotWhiteSpaceValidator(valueParameter);\n        }\n    }\n\n    function globalFunction<TypeParameter>(value:TypeParameter) { //global function\n        return 42;\n    }\n    declare var declareUrl;\n    var varUrl = declareUrl.replace(/^\\s*(.*)/, \"$1\").concat(\"\\u1111\\z\\n\\u22\");\n    NotWhiteSpaceValidator.createInstance(varUrl).validateValue();\n}\n#";
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{new AttributesDescriptor(JSBundle.message((String)"javascript.keyword", (Object[])new Object[0]), TypeScriptHighlighter.TS_KEYWORD), new AttributesDescriptor(JSBundle.message((String)"javascript.string", (Object[])new Object[0]), TypeScriptHighlighter.TS_STRING), new AttributesDescriptor(JSBundle.message((String)"javascript.valid.string.escape", (Object[])new Object[0]), TypeScriptHighlighter.TS_VALID_STRING_ESCAPE), new AttributesDescriptor(JSBundle.message((String)"javascript.invalid.string.escape", (Object[])new Object[0]), TypeScriptHighlighter.TS_INVALID_STRING_ESCAPE), new AttributesDescriptor(JSBundle.message((String)"javascript.number", (Object[])new Object[0]), TypeScriptHighlighter.TS_NUMBER), new AttributesDescriptor(JSBundle.message((String)"javascript.regexp", (Object[])new Object[0]), TypeScriptHighlighter.TS_REGEXP), new AttributesDescriptor(JSBundle.message((String)"javascript.linecomment", (Object[])new Object[0]), TypeScriptHighlighter.TS_LINE_COMMENT), new AttributesDescriptor(JSBundle.message((String)"javascript.blockcomment", (Object[])new Object[0]), TypeScriptHighlighter.TS_BLOCK_COMMENT), new AttributesDescriptor(JSBundle.message((String)"javascript.doccomment", (Object[])new Object[0]), TypeScriptHighlighter.TS_DOC_COMMENT), new AttributesDescriptor(JSBundle.message((String)"javascript.operation", (Object[])new Object[0]), TypeScriptHighlighter.TS_OPERATION_SIGN), new AttributesDescriptor(JSBundle.message((String)"javascript.parens", (Object[])new Object[0]), TypeScriptHighlighter.TS_PARENTHS), new AttributesDescriptor(JSBundle.message((String)"javascript.brackets", (Object[])new Object[0]), TypeScriptHighlighter.TS_BRACKETS), new AttributesDescriptor(JSBundle.message((String)"javascript.braces", (Object[])new Object[0]), TypeScriptHighlighter.TS_BRACES), new AttributesDescriptor(JSBundle.message((String)"javascript.comma", (Object[])new Object[0]), TypeScriptHighlighter.TS_COMMA), new AttributesDescriptor(JSBundle.message((String)"javascript.dot", (Object[])new Object[0]), TypeScriptHighlighter.TS_DOT), new AttributesDescriptor(JSBundle.message((String)"javascript.semicolon", (Object[])new Object[0]), TypeScriptHighlighter.TS_SEMICOLON), new AttributesDescriptor(JSBundle.message((String)"javascript.badcharacter", (Object[])new Object[0]), TypeScriptHighlighter.TS_BAD_CHARACTER), new AttributesDescriptor(JSBundle.message((String)"javascript.docmarkup", (Object[])new Object[0]), TypeScriptHighlighter.TS_DOC_MARKUP), new AttributesDescriptor(JSBundle.message((String)"javascript.doctag", (Object[])new Object[0]), TypeScriptHighlighter.TS_DOC_TAG), new AttributesDescriptor(JSBundle.message((String)"javascript.parameter", (Object[])new Object[0]), TypeScriptHighlighter.TS_PARAMETER), new AttributesDescriptor(JSBundle.message((String)"javascript.local.variable", (Object[])new Object[0]), TypeScriptHighlighter.TS_LOCAL_VARIABLE), new AttributesDescriptor(JSBundle.message((String)"javascript.global.variable", (Object[])new Object[0]), TypeScriptHighlighter.TS_GLOBAL_VARIABLE), new AttributesDescriptor(JSBundle.message((String)"javascript.global.function", (Object[])new Object[0]), TypeScriptHighlighter.TS_GLOBAL_FUNCTION), new AttributesDescriptor(JSBundle.message((String)"javascript.class", (Object[])new Object[0]), TypeScriptHighlighter.TS_CLASS), new AttributesDescriptor(JSBundle.message((String)"javascript.interface", (Object[])new Object[0]), TypeScriptHighlighter.TS_INTERFACE), new AttributesDescriptor(JSBundle.message((String)"javascript.instance.member.function", (Object[])new Object[0]), TypeScriptHighlighter.TS_INSTANCE_MEMBER_FUNCTION), new AttributesDescriptor(JSBundle.message((String)"javascript.instance.member.variable", (Object[])new Object[0]), TypeScriptHighlighter.TS_INSTANCE_MEMBER_VARIABLE), new AttributesDescriptor(JSBundle.message((String)"javascript.static.member.function", (Object[])new Object[0]), TypeScriptHighlighter.TS_STATIC_MEMBER_FUNCTION), new AttributesDescriptor(JSBundle.message((String)"javascript.static.member.variable", (Object[])new Object[0]), TypeScriptHighlighter.TS_STATIC_MEMBER_VARIABLE), new AttributesDescriptor(JSBundle.message((String)"typescript.module.name", (Object[])new Object[0]), TypeScriptHighlighter.TS_MODULE_NAME), new AttributesDescriptor(JSBundle.message((String)"typescript.type.parameter", (Object[])new Object[0]), TypeScriptHighlighter.TS_TYPE_PARAMETER)};
    @NonNls
    private static final Map<String, TextAttributesKey> ADDITIONAL_HIGHLIGHT_DESCRIPTORS = new HashMap<String, TextAttributesKey>();

    @Nullable
    public Icon getIcon() {
        return JavaScriptSupportLoader.JAVASCRIPT.getIcon();
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        TypeScriptHighlighter typeScriptHighlighter = new TypeScriptHighlighter();
        if (typeScriptHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/TypeScriptColorSettingsPage", "getHighlighter"));
        }
        return typeScriptHighlighter;
    }

    @NotNull
    public String getDemoText() {
        String string = DEMO_TEXT.replace("HasValidator", "<interface>HasValidator</interface>").replace("NotWhiteSpaceValidator", "<class>HasValidator</class>").replaceAll("(String|Boolean|Array)", "<interface>$1</interface>").replace("validatedValue", "<static_field>validatedValue</static_field>").replace("myValue", "<instance_field>myValue</instance_field>").replace("validateValue", "<class_function>validateValue</class_function>").replace("createInstance", "<static_function>createInstance</static_function>").replace("notWhiteSpace", "<static_function>notWhiteSpace</static_function>").replace("varUrl", "<global_var>varUrl</global_var>").replace("declareUrl", "<global_var>declareUrl</global_var>").replace("resultValue", "<local_var>resultValue</local_var>").replace("valueParameter", "<parameter>valueParameter</parameter>").replace("TypeParameter", "<type_parameter>TypeParameter</type_parameter>").replaceAll("(replace|concat|push)", "<interface_method_call>$1</interface_method_call>").replaceAll("(ModuleValidator|CharUtils)", "<module_name>$1</module_name>").replace("globalFunction", "<global_function>globalFunction</global_function>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/TypeScriptColorSettingsPage", "getDemoText"));
        }
        return string;
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ADDITIONAL_HIGHLIGHT_DESCRIPTORS;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (ATTRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/TypeScriptColorSettingsPage", "getAttributeDescriptors"));
        }
        return ATTRS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/TypeScriptColorSettingsPage", "getColorDescriptors"));
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        if ("TypeScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/TypeScriptColorSettingsPage", "getDisplayName"));
        }
        return "TypeScript";
    }

    static {
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("parameter", TypeScriptHighlighter.TS_PARAMETER);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("local_var", TypeScriptHighlighter.TS_LOCAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("global_var", TypeScriptHighlighter.TS_GLOBAL_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("global_function", TypeScriptHighlighter.TS_GLOBAL_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("instance_field", TypeScriptHighlighter.TS_INSTANCE_MEMBER_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("class_function", TypeScriptHighlighter.TS_INSTANCE_MEMBER_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("static_function", TypeScriptHighlighter.TS_STATIC_MEMBER_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("static_field", TypeScriptHighlighter.TS_STATIC_MEMBER_VARIABLE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("class", TypeScriptHighlighter.TS_CLASS);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("interface", TypeScriptHighlighter.TS_INTERFACE);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("interface_method_call", TypeScriptHighlighter.TS_GLOBAL_FUNCTION);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("module_name", TypeScriptHighlighter.TS_MODULE_NAME);
        ADDITIONAL_HIGHLIGHT_DESCRIPTORS.put("type_parameter", TypeScriptHighlighter.TS_TYPE_PARAMETER);
    }
}

