/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.index.JSImplicitElementsIndexFileTypeProvider;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSImplicitElementsIndex
extends FileBasedIndexExtension<String, Collection<JSElementProxy>> {
    public static final ID<String, Collection<JSElementProxy>> INDEX_ID = ID.create((String)"js.implicit.elements.index");
    private final KeyDescriptor<String> myKeyDescriptor = new EnumeratorStringDescriptor();
    private final DataIndexer<String, Collection<JSElementProxy>, FileContent> myIndexer = new DataIndexer<String, Collection<JSElementProxy>, FileContent>(){

        @NotNull
        public Map<String, Collection<JSElementProxy>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$1", "map"));
            }
            Map<String, Collection<JSElementProxy>> map = JSIndexContent.indexFile(inputData).getImplicitElements();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$1", "map"));
            }
            return map;
        }
    };

    @NotNull
    public ID<String, Collection<JSElementProxy>> getName() {
        ID<String, Collection<JSElementProxy>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<JSElementProxy>, FileContent> getIndexer() {
        DataIndexer<String, Collection<JSElementProxy>, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        KeyDescriptor<String> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<JSElementProxy>> getValueExternalizer() {
        DataExternalizer<Collection<JSElementProxy>> dataExternalizer = new DataExternalizer<Collection<JSElementProxy>>(){

            public void save(@NotNull DataOutput out, Collection<JSElementProxy> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$2", "save"));
                }
                if (value == null) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)0);
                    return;
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (JSElementProxy proxy : value) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)proxy.getOffset());
                    proxy.getBuilder().toImplicitElement().serialize(out);
                }
            }

            public Collection<JSElementProxy> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/lang/javascript/index/JSImplicitElementsIndex$2", "read"));
                }
                int size = DataInputOutputUtil.readINT((DataInput)in);
                if (size == 0) {
                    return null;
                }
                ArrayList<JSElementProxy> result = new ArrayList<JSElementProxy>(size);
                for (int i = 0; i < size; ++i) {
                    int offset = DataInputOutputUtil.readINT((DataInput)in);
                    JSImplicitElementImpl.Builder element = JSImplicitElementImpl.deserialize(in);
                    result.add(new JSElementProxy(element, offset));
                }
                return result;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(Holder.FILE_TYPES);
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/index/JSImplicitElementsIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return JSFileElementType.getVersion() + 1;
    }

    public static class JSElementProxy {
        private final int myOffset;
        private final JSImplicitElementImpl.Builder myElement;

        public JSElementProxy(JSImplicitElementImpl.Builder builder, int offset) {
            this.myElement = builder;
            this.myOffset = offset;
        }

        public JSImplicitElementImpl.Builder getBuilder() {
            return this.myElement;
        }

        public int getOffset() {
            return this.myOffset;
        }
    }

    public static class Holder {
        public static final FileType[] FILE_TYPES = JSImplicitElementsIndexFileTypeProvider.Provider.getFileTypes();

        public static boolean containFileType(FileType type) {
            return ArrayUtil.contains((Object)type, (Object[])FILE_TYPES);
        }
    }
}

