/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class CreateFieldFromParameterAction
extends CreateJSVariableIntentionAction {
    private PsiElement myAnchor;

    public CreateFieldFromParameterAction(String fieldName) {
        super(fieldName, true, false);
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        CreateFieldFromParameterAction.addAccessModifier(template, referenceExpression, file, staticContext, CreateFieldFromParameterAction.findClass(anchorParent));
        template.addTextSegment(DialectDetector.isTypeScript((PsiElement)referenceExpression) ? "" : VAR_STATEMENT_START);
        template.addTextSegment(referenceExpression.getReferencedName());
        JSParameter parameter = (JSParameter)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myAnchor, (Class[])new Class[]{JSParameter.class});
        if (parameter != null) {
            String typeString;
            JSType type = parameter.getType();
            String string = typeString = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
            if (!StringUtil.isEmpty((String)typeString)) {
                template.addTextSegment(":");
                template.addTextSegment(typeString);
            }
        }
        this.addSemicolonSegment(template, file);
    }

    @Override
    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        JSParameter parameter = (JSParameter)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSParameter.class});
        if (parameter != null) {
            this.myAnchor = psiElement;
            String text = this.myReferencedName;
            JSExpressionStatement block = (JSExpressionStatement)JSChangeUtil.createStatementFromText(psiElement.getProject(), text, JSUtils.getDialect(psiElement.getContainingFile())).getPsi();
            JSReferenceExpression expression = (JSReferenceExpression)block.getExpression();
            Pair pair = Pair.create((Object)expression, (Object)psiElement);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/CreateFieldFromParameterAction", "calculateAnchors"));
            }
            return pair;
        }
        Pair<JSReferenceExpression, PsiElement> pair = super.calculateAnchors(psiElement);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/CreateFieldFromParameterAction", "calculateAnchors"));
        }
        return pair;
    }
}

