/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLastCommaInArrayLiteralInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.last.comma.in.array.literal.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
                if (DialectDetector.isTypeScript((PsiElement)node)) {
                    return;
                }
                PsiElement child = JSLastCommaInArrayLiteralInspection.findErrorNode(node);
                if (child != null) {
                    JSPrefixExpression prefixExpr;
                    if (!DialectDetector.isActionScript((PsiElement)node) && (prefixExpr = (JSPrefixExpression)ObjectUtils.tryCast((Object)node.getParent(), JSPrefixExpression.class)) != null && prefixExpr.getOperationSign() == JSTokenTypes.MINUS) {
                        return;
                    }
                    holder.registerProblem(child, JSBundle.message((String)"javascript.validation.message.unneeded.comma", (Object[])new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", child.getNode())});
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    @Nullable
    public static PsiElement findErrorNode(@NotNull JSArrayLiteralExpression node) {
        ASTNode childNode;
        PsiElement child;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection", "findErrorNode"));
        }
        PsiElement lastChild = node.getLastChild();
        PsiElement psiElement = child = lastChild != null ? lastChild.getPrevSibling() : null;
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getPrevSibling();
        }
        if (child != null && (childNode = child.getNode()) != null && childNode.getElementType() == JSTokenTypes.COMMA) {
            return child;
        }
        return null;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSLastCommaInArrayLiteralInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

