/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.lang.javascript.inspections.JSMismatchedCollectionQueryUpdateInspectionBase;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;

public class JSMismatchedCollectionQueryUpdateInspection
extends JSMismatchedCollectionQueryUpdateInspectionBase {
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2, 10, 4));
        ListTable table1 = new ListTable(new ListWrappingTableModel(this.myQueryNames, "Query name starts with"));
        JPanel tablePanel1 = JSMismatchedCollectionQueryUpdateInspection.createAddRemovePanel(table1);
        ListTable table2 = new ListTable(new ListWrappingTableModel(this.myUpdateNames, "Update name starts with"));
        JPanel tablePanel2 = JSMismatchedCollectionQueryUpdateInspection.createAddRemovePanel(table2);
        panel.add(tablePanel1);
        panel.add(tablePanel2);
        return panel;
    }

    protected static JPanel createAddRemovePanel(final ListTable table) {
        return ToolbarDecorator.createDecorator((JTable)table).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                final ListWrappingTableModel tableModel = table.getModel();
                tableModel.addRow();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int lastRowIndex = tableModel.getRowCount() - 1;
                        Rectangle rectangle = table.getCellRect(lastRowIndex, 0, true);
                        table.scrollRectToVisible(rectangle);
                        table.editCellAt(lastRowIndex, 0);
                        ListSelectionModel selectionModel = table.getSelectionModel();
                        selectionModel.setSelectionInterval(lastRowIndex, lastRowIndex);
                        TableCellEditor editor = table.getCellEditor();
                        Component component = editor.getTableCellEditorComponent((JTable)table, null, true, lastRowIndex, 0);
                        component.requestFocus();
                    }
                });
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TableCellEditor editor = table.getCellEditor();
                        if (editor != null) {
                            editor.stopCellEditing();
                        }
                        ListSelectionModel selectionModel = table.getSelectionModel();
                        int minIndex = selectionModel.getMinSelectionIndex();
                        int maxIndex = selectionModel.getMaxSelectionIndex();
                        if (minIndex == -1 || maxIndex == -1) {
                            return;
                        }
                        ListWrappingTableModel tableModel = table.getModel();
                        for (int i = minIndex; i <= maxIndex; ++i) {
                            if (!selectionModel.isSelectedIndex(i)) continue;
                            tableModel.removeRow(i);
                        }
                        int count = tableModel.getRowCount();
                        if (count <= minIndex) {
                            selectionModel.setSelectionInterval(count - 1, count - 1);
                        } else if (minIndex <= 0) {
                            if (count > 0) {
                                selectionModel.setSelectionInterval(0, 0);
                            }
                        } else {
                            selectionModel.setSelectionInterval(minIndex - 1, minIndex - 1);
                        }
                    }
                });
            }
        }).disableUpDownActions().createPanel();
    }
}

