/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSUnfilteredForInLoopInspection
extends JSInspection {
    @NonNls
    private static final String HAS_OWN_PROPERTY = "hasOwnProperty";
    public boolean mySkipPrimitives = false;

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unfiltered.for.in.loop.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JSBundle.message((String)"js.unfiltered.for.in.loop.skip.primitives", (Object[])new Object[0]), JSBundle.message((String)"js.unfiltered.for.in.loop.skip.primitives.tooltip", (Object[])new Object[0]), "mySkipPrimitives");
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSForInStatement(JSForInStatement forInStatement) {
                if (!forInStatement.isForEach()) {
                    JSExpression qualifier;
                    JSExpression methodExpression;
                    JSExpression collection = forInStatement.getCollectionExpression();
                    boolean hasPossibleIterationProblem = true;
                    if (collection instanceof JSCallExpression && (methodExpression = ((JSCallExpression)collection).getMethodExpression()) instanceof JSReferenceExpression && "keys".equals(((JSReferenceExpression)methodExpression).getReferencedName()) && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) instanceof JSReferenceExpression && "Object".equals(qualifier.getText())) {
                        hasPossibleIterationProblem = false;
                    }
                    JSExpression propertyName = null;
                    JSVarStatement declarationStatement = forInStatement.getDeclarationStatement();
                    if (declarationStatement != null) {
                        JSVariable[] variables = declarationStatement.getVariables();
                        if (variables.length > 0) {
                            propertyName = variables[0].getNameIdentifier();
                        }
                    } else {
                        propertyName = forInStatement.getVariableExpression();
                    }
                    if (hasPossibleIterationProblem && propertyName != null && collection != null) {
                        boolean collectionIsPrimitive;
                        boolean forInHasNoProblemDueToCollectionType = false;
                        JSType collectionType = JSResolveUtil.getExpressionJSType(collection);
                        boolean bl = collectionIsPrimitive = JSUnfilteredForInLoopInspection.this.isPrimitiveCollection(collectionType) || JSUnfilteredForInLoopInspection.this.isPrimitiveCollection(JSTypeUtils.resolveType(collectionType));
                        if (collectionType != null && "flash.utils.Dictionary".equals(collectionType.getResolvedTypeText()) || collectionIsPrimitive && JSUnfilteredForInLoopInspection.this.mySkipPrimitives) {
                            forInHasNoProblemDueToCollectionType = true;
                        }
                        JSStatement body = forInStatement.getBody();
                        if (!forInHasNoProblemDueToCollectionType && body != null) {
                            JSExpression finalPropertyName = propertyName;
                            body.accept((PsiElementVisitor)new JSRecursiveElementVisitor((PsiElement)finalPropertyName, collectionIsPrimitive, forInStatement, collection){
                                final List<JSIfStatement> conditionals = new SmartList();
                                boolean definitivelyFiltered;
                                boolean definitivelyFilteredInIf;
                                JSStatement definitivelyFilteredInIfBlock;
                                private String propertyNameText = this.val$finalPropertyName.getText();
                                final /* synthetic */ PsiElement val$finalPropertyName;
                                final /* synthetic */ boolean val$collectionIsPrimitive;
                                final /* synthetic */ JSForInStatement val$forInStatement;
                                final /* synthetic */ JSExpression val$collection;
                                {
                                    this.val$finalPropertyName = psiElement;
                                    this.val$collectionIsPrimitive = bl;
                                    this.val$forInStatement = jSForInStatement;
                                    this.val$collection = jSExpression;
                                }

                                public void visitJSReferenceExpression(JSReferenceExpression node) {
                                    PsiElement parent;
                                    if (node.getQualifier() == null && this.propertyNameText.equals(node.getReferencedName()) && !((parent = node.getParent()) instanceof JSBinaryExpression) && !(parent instanceof JSPrefixExpression)) {
                                        boolean hasProperCheck;
                                        boolean bl = hasProperCheck = this.definitivelyFiltered || this.definitivelyFilteredInIf;
                                        if (!hasProperCheck) {
                                            for (JSIfStatement ifStatement : this.conditionals) {
                                                if (!this.hasNecessaryCheck(ifStatement, (PsiElement)node, this.propertyNameText)) continue;
                                                hasProperCheck = true;
                                                break;
                                            }
                                        }
                                        if (!hasProperCheck) {
                                            LocalQuickFix[] localQuickFixArray;
                                            if (this.val$collectionIsPrimitive && !JSUnfilteredForInLoopInspection.this.mySkipPrimitives) {
                                                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                                                localQuickFixArray = localQuickFixArray2;
                                                localQuickFixArray2[0] = new EnableSkipPrimitivesFix();
                                            } else {
                                                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                                            }
                                            LocalQuickFix[] fixes = localQuickFixArray;
                                            holder.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.unfiltered.for.in.loop", (Object[])new Object[0]), fixes);
                                        }
                                    }
                                    super.visitJSReferenceExpression(node);
                                }

                                private boolean hasNecessaryCheck(JSIfStatement ifStatement, PsiElement context, String propertyNameText) {
                                    JSExpression methodExpression;
                                    IElementType sign;
                                    JSBinaryExpression binaryExpression;
                                    IElementType type;
                                    boolean hasNecessaryCheck = false;
                                    boolean negatedCondition = false;
                                    JSExpression condition = ifStatement.getCondition();
                                    boolean expectNegation = true;
                                    while (condition instanceof JSBinaryExpression && ((type = (binaryExpression = (JSBinaryExpression)condition).getOperationSign()) == JSTokenTypes.OROR || type == JSTokenTypes.ANDAND)) {
                                        IElementType conditionBinaryOpType;
                                        condition = binaryExpression.getLOperand();
                                        if (type != JSTokenTypes.ANDAND) continue;
                                        expectNegation = false;
                                        IElementType iElementType = conditionBinaryOpType = condition instanceof JSBinaryExpression ? ((JSBinaryExpression)condition).getOperationSign() : null;
                                        if (condition instanceof JSCallExpression || conditionBinaryOpType == JSTokenTypes.OROR || conditionBinaryOpType == JSTokenTypes.ANDAND) continue;
                                        condition = binaryExpression.getROperand();
                                    }
                                    if (expectNegation && condition instanceof JSPrefixExpression && ((JSPrefixExpression)condition).getOperationSign() == JSTokenTypes.EXCL && PsiTreeUtil.findCommonParent((PsiElement)context, (PsiElement)condition) == condition) {
                                        condition = ((JSPrefixExpression)condition).getExpression();
                                        negatedCondition = true;
                                    }
                                    if (condition instanceof JSBinaryExpression && JSTokenTypes.EQUALITY_OPERATIONS.contains(sign = ((JSBinaryExpression)condition).getOperationSign())) {
                                        if (sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ) {
                                            negatedCondition = !negatedCondition;
                                        }
                                        JSExpression lOperand = ((JSBinaryExpression)condition).getLOperand();
                                        JSExpression rOperand = ((JSBinaryExpression)condition).getROperand();
                                        if (lOperand instanceof JSLiteralExpression && ((JSLiteralExpression)lOperand).isBooleanLiteral()) {
                                            condition = rOperand;
                                            if (lOperand.getNode().findChildByType(JSTokenTypes.FALSE_KEYWORD) != null) {
                                                negatedCondition = !negatedCondition;
                                            }
                                        } else if (rOperand instanceof JSLiteralExpression && ((JSLiteralExpression)rOperand).isBooleanLiteral()) {
                                            condition = lOperand;
                                            if (rOperand.getNode().findChildByType(JSTokenTypes.FALSE_KEYWORD) != null) {
                                                boolean bl = negatedCondition = !negatedCondition;
                                            }
                                        }
                                    }
                                    if (condition instanceof JSCallExpression && (methodExpression = ((JSCallExpression)condition).getMethodExpression()) instanceof JSReferenceExpression) {
                                        JSExpression qualifier;
                                        JSExpression[] arguments;
                                        JSReferenceExpression calledMethod = (JSReferenceExpression)methodExpression;
                                        String referencedName = calledMethod.getReferencedName();
                                        JSArgumentList argumentList = ((JSCallExpression)condition).getArgumentList();
                                        JSExpression[] jSExpressionArray = arguments = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
                                        if ("call".equals(referencedName)) {
                                            if (arguments.length == 2 && propertyNameText.equals(arguments[1].getText()) && this.isProperCollectionIteration(arguments[0])) {
                                                JSExpression qualifier3;
                                                JSExpression qualifier2;
                                                JSElement sourceElement;
                                                JSNamespaceEvaluationResult type2;
                                                JSExpression qualifier4 = calledMethod.getQualifier();
                                                if (qualifier4 instanceof JSReferenceExpression && (type2 = JSSymbolUtil.evaluateNamespaceLocally((JSReferenceExpression)qualifier4)) != null && (sourceElement = type2.getSource()) instanceof JSExpression) {
                                                    qualifier4 = (JSExpression)sourceElement;
                                                }
                                                if (qualifier4 instanceof JSReferenceExpression && JSUnfilteredForInLoopInspection.HAS_OWN_PROPERTY.equals(((JSReferenceExpression)qualifier4).getReferencedName()) && (qualifier2 = ((JSReferenceExpression)qualifier4).getQualifier()) instanceof JSReferenceExpression && "prototype".equals(((JSReferenceExpression)qualifier2).getReferencedName()) && (qualifier3 = ((JSReferenceExpression)qualifier2).getQualifier()) instanceof JSReferenceExpression && "Object".equals(((JSReferenceExpression)qualifier3).getReferencedName())) {
                                                    hasNecessaryCheck = true;
                                                }
                                            }
                                        } else if (JSUnfilteredForInLoopInspection.HAS_OWN_PROPERTY.equals(referencedName) && arguments.length == 1 && propertyNameText.equals(arguments[0].getText()) && (this.isReference(qualifier = calledMethod.getQualifier()) || qualifier instanceof JSThisExpression) && this.isProperCollectionIteration(qualifier)) {
                                            hasNecessaryCheck = true;
                                        }
                                    }
                                    if (hasNecessaryCheck) {
                                        JSStatement then = ifStatement.getThen();
                                        if (negatedCondition) {
                                            if (then instanceof JSBlockStatement && !ControlFlowUtils.blockMayCompleteNormally((JSBlockStatement)then) || then instanceof JSContinueStatement && ((JSContinueStatement)then).getStatementToContinue() == this.val$forInStatement) {
                                                this.definitivelyFiltered = true;
                                            }
                                        } else if (then instanceof JSBlockStatement ? ControlFlowUtils.blockMayCompleteNormally((JSBlockStatement)then) : ControlFlowUtils.statementMayCompleteNormally(then)) {
                                            this.definitivelyFilteredInIf = true;
                                            this.definitivelyFilteredInIfBlock = then;
                                        }
                                    }
                                    return hasNecessaryCheck;
                                }

                                private boolean isProperCollectionIteration(JSExpression qualifier) {
                                    return !this.isReference(this.val$collection) || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)this.val$collection, (PsiElement)qualifier);
                                }

                                private boolean isReference(JSExpression collection) {
                                    return collection instanceof JSReferenceExpression || collection instanceof JSIndexedPropertyAccessExpression;
                                }

                                public void visitJSIfStatement(JSIfStatement node) {
                                    this.conditionals.add(node);
                                    super.visitJSIfStatement(node);
                                    this.conditionals.remove(this.conditionals.size() - 1);
                                }

                                public void visitJSStatement(JSStatement node) {
                                    boolean definitivelyFilteredInIf = this.definitivelyFilteredInIf;
                                    JSStatement definitivelyFilteredInIfBlock = this.definitivelyFilteredInIfBlock;
                                    super.visitJSStatement(node);
                                    if (definitivelyFilteredInIf && node == definitivelyFilteredInIfBlock) {
                                        this.definitivelyFilteredInIf = false;
                                        this.definitivelyFilteredInIfBlock = null;
                                    } else {
                                        this.definitivelyFilteredInIf = definitivelyFilteredInIf;
                                        this.definitivelyFilteredInIfBlock = definitivelyFilteredInIfBlock;
                                    }
                                }
                            });
                        }
                    }
                }
                super.visitJSForInStatement(forInStatement);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private boolean isPrimitiveCollection(JSType collectionType) {
        return collectionType instanceof JSArrayTypeImpl || collectionType instanceof JSPrimitiveArrayType || collectionType instanceof JSRecordType || collectionType instanceof JSObjectType;
    }

    private class EnableSkipPrimitivesFix
    implements LocalQuickFix {
        private EnableSkipPrimitivesFix() {
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"js.unfiltered.for.in.loop.skip.primitives", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$EnableSkipPrimitivesFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$EnableSkipPrimitivesFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$EnableSkipPrimitivesFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/JSUnfilteredForInLoopInspection$EnableSkipPrimitivesFix", "applyFix"));
            }
            JSUnfilteredForInLoopInspection.this.mySkipPrimitives = true;
        }
    }
}

