/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReference;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JSUnusedLocalSymbolsInspection
extends JSInspection {
    public boolean myIgnoreUnusedFunctionParameters;
    public boolean myIgnoreUnusedCatchParameters = true;
    public static final String SHORT_NAME = JSUnusedLocalSymbolsInspection.calcShortNameFromClass(JSUnusedLocalSymbolsInspection.class);
    private static Key<Map<ProblemsHolder, Map<PsiElement, ConcurrentMap<JSNamedElement, Boolean>>>> ourUnusedScopeMapKey = Key.create((String)"js.unusedMap");

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.unused.local.symbol.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, final LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)node, session, holder);
            }

            public void visitJSParameter(JSParameter node) {
                ConcurrentMap unusedParametersStatus;
                PsiElement scopeNode = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, JSCatchBlock.class});
                if (scopeNode == null || scopeNode instanceof JSCatchBlock && JSUnusedLocalSymbolsInspection.this.myIgnoreUnusedCatchParameters) {
                    return;
                }
                if (scopeNode instanceof JSFunction) {
                    String className;
                    DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
                    boolean js = dialect != null && dialect.isJavaScript();
                    JSSourceElement[] body = ((JSFunction)scopeNode).getBody();
                    if (js && (body.length == 0 || PsiTreeUtil.findChildOfType((PsiElement)body[0], JSStatement.class) == null)) {
                        return;
                    }
                    PsiComment docComment = JSDocumentationUtils.findDocCommentWider(scopeNode);
                    if (docComment instanceof JSDocComment && ((JSDocComment)docComment).hasAbstractTag()) {
                        return;
                    }
                    JSType context = JSContextResolver.resolveContext((PsiElement)node).getType();
                    String string = className = context != null ? JSTypeUtils.getQualifiedNameMatchingType(context, false) : null;
                    if (className != null && JSSymbolUtil.isInterface(className, (PsiElement)node)) {
                        return;
                    }
                }
                if ((unusedParametersStatus = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap(scopeNode, session, holder)) == null) {
                    return;
                }
                JSUnusedLocalSymbolsInspection.this.addUnusedElementIfNotUsedBefore((JSNamedElement)node, unusedParametersStatus);
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                for (PsiReference ref : node.getReferences()) {
                    if (ref instanceof CssReference || ref instanceof JSModuleBaseReference) continue;
                    if (ref instanceof PsiPolyVariantReference) {
                        this.registerReferencedFromReferences(((PsiPolyVariantReference)ref).multiResolve(false));
                        continue;
                    }
                    this.registerReferencedFromReference(ref.resolve());
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (JSResolveUtil.isSelfReference((PsiElement)node)) {
                    return;
                }
                ResolveResult[] results = node.multiResolve(false);
                if ("arguments".equals(node.getText()) && results.length == 1 && results[0].getElement() instanceof ImplicitJSVariableImpl) {
                    JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
                    if (function == null) {
                        return;
                    }
                    ConcurrentMap unusedSymbolsStatus = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap((PsiElement)function, session, holder);
                    if (unusedSymbolsStatus == null) {
                        return;
                    }
                    for (JSParameter p : function.getParameterVariables()) {
                        unusedSymbolsStatus.put(p, Boolean.FALSE);
                    }
                    return;
                }
                this.registerReferencedFromReferences(results);
            }

            public void visitJSDocTagValue(JSDocTagValue tagValue) {
                for (PsiReference reference : tagValue.getReferences()) {
                    JSElementIndexingData indexingData;
                    JSDocComment docComment;
                    PsiElement resolve;
                    if (!(reference instanceof JSDocReference) || (resolve = reference.resolve()) == null || (docComment = JSStubBasedPsiTreeUtil.findDocComment(resolve)) == null || (indexingData = docComment.getIndexingData()) == null || ContainerUtil.isEmpty((Collection)indexingData.getTypedefs())) continue;
                    this.registerReferencedFromReferences(((JSDocReference)reference).multiResolve(false));
                }
            }

            public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
                ES6ImportExportDeclaration declaration = node.getDeclaration();
                if (declaration == null || declaration.getFromClause() != null) {
                    return;
                }
                ResolveResult[] results = node.multiResolve(false);
                this.registerReferencedFromReferences(results);
            }

            private void registerReferencedFromReferences(ResolveResult[] results) {
                for (ResolveResult r : results) {
                    PsiElement element = r.getElement();
                    this.registerReferencedFromReference(element);
                }
            }

            private void registerReferencedFromReference(PsiElement element) {
                if (element instanceof JSNamedElement && (!(element instanceof JSFunction) || JSUnusedLocalSymbolsInspection.isSupportedFunction((JSFunction)element))) {
                    ConcurrentMap unusedSet;
                    assert (!(element instanceof JSFunctionExpression));
                    JSElement scopeHandler = JSUnusedLocalSymbolsInspection.getScopeNode((JSNamedElement)element);
                    if (scopeHandler != null && (unusedSet = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap((PsiElement)scopeHandler, session, holder)) != null) {
                        unusedSet.put((JSNamedElement)element, Boolean.FALSE);
                        if (element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
                            ConcurrentMap parentUnusedMap;
                            JSElement parentScopeHandler;
                            PsiElement elementParent = element.getParent();
                            JSElement jSElement = parentScopeHandler = elementParent instanceof JSNamedElement ? JSUnusedLocalSymbolsInspection.getScopeNode((JSNamedElement)elementParent) : null;
                            if (parentScopeHandler != null && (parentUnusedMap = JSUnusedLocalSymbolsInspection.this.getUnusedDeclarationsMap((PsiElement)parentScopeHandler, session, holder)) != null) {
                                parentUnusedMap.put((JSNamedElement)elementParent, Boolean.FALSE);
                            }
                        }
                    }
                }
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.visitJSFunctionDeclaration((JSFunction)node);
            }

            public void visitJSNamespaceDeclaration(JSNamespaceDeclaration node) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)node, session, holder);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)node, session, holder);
            }

            public void visitJSClass(JSClass aClass) {
                JSUnusedLocalSymbolsInspection.this.handleLocalDeclaration((JSNamedElement)aClass, session, holder);
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static boolean isSupportedFunction(JSFunction element) {
        return !(element instanceof JSFunctionExpression) && !(element.getParent() instanceof JSProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDeclarationHost(PsiElement node, Map<JSNamedElement, Boolean> unusedDeclarationsStatus, ProblemsHolder holder) {
        if (node instanceof JSFile && node.getContext() != null) {
            return;
        }
        if (unusedDeclarationsStatus == null || unusedDeclarationsStatus.size() == 0) {
            return;
        }
        try {
            if (node instanceof JSFunction && ((JSFunction)node).getBody().length == 0) {
                return;
            }
            LocalLiteralOccurrenceChecker checker = null;
            int nonCounted = -2;
            int lastUsedParameterIndex = -2;
            TObjectIntHashMap parameterIndexMap = null;
            ThreeState participatesInHierarchy = ThreeState.UNSURE;
            for (Map.Entry<JSNamedElement, Boolean> e : unusedDeclarationsStatus.entrySet()) {
                PsiElement highlightedElement;
                ASTNode nameIdentifier;
                JSNamedElement p = e.getKey();
                if (!p.isValid() || e.getValue() == Boolean.FALSE) continue;
                JSNamedElementKind namedElementKind = JSNamedElementKind.kind(p, true);
                boolean asinfo = false;
                if (RefUtil.isImplicitUsage((PsiElement)p)) continue;
                if (p instanceof JSParameter) {
                    if (this.myIgnoreUnusedFunctionParameters && node instanceof JSFunction) continue;
                    if (node instanceof JSFunction) {
                        boolean ecma;
                        boolean bl = ecma = node.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                        if (ecma && node instanceof JSFunctionExpression) continue;
                        JSParameter[] params = ((JSFunction)node).getParameterVariables();
                        if (lastUsedParameterIndex == -2) {
                            BitSet unusedSet = new BitSet(params.length);
                            parameterIndexMap = new TObjectIntHashMap();
                            for (int i = 0; i < params.length; ++i) {
                                parameterIndexMap.put((Object)params[i], i);
                            }
                            for (Map.Entry<JSNamedElement, Boolean> entry : unusedDeclarationsStatus.entrySet()) {
                                JSNamedElement param = entry.getKey();
                                if (!(param instanceof JSParameter) || entry.getValue() == Boolean.FALSE) continue;
                                unusedSet.set(parameterIndexMap.get((Object)((JSParameter)param)));
                            }
                            lastUsedParameterIndex = -1;
                            for (int i = params.length - 1; i >= 0; --i) {
                                if (unusedSet.get(i)) continue;
                                lastUsedParameterIndex = i;
                                break;
                            }
                        }
                        if (!(p.getParent() instanceof JSDestructuringProperty) && parameterIndexMap.get((Object)((JSParameter)p)) < lastUsedParameterIndex && node instanceof JSFunctionExpression) continue;
                        if (participatesInHierarchy == ThreeState.UNSURE) {
                            JSFunction fun = (JSFunction)node;
                            JSAttributeList attributeList = fun.getAttributeList();
                            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                                participatesInHierarchy = ThreeState.YES;
                            } else {
                                ThreeState threeState = participatesInHierarchy = JSInheritanceUtil.participatesInHierarchy(fun) ? ThreeState.YES : ThreeState.NO;
                            }
                        }
                        if (participatesInHierarchy == ThreeState.YES) {
                            asinfo = true;
                        }
                    }
                    if ((nameIdentifier = p.findNameIdentifier()) == null) continue;
                    highlightedElement = nameIdentifier.getPsi();
                } else {
                    nameIdentifier = p.findNameIdentifier();
                    if (nameIdentifier == null) continue;
                    highlightedElement = nameIdentifier.getPsi();
                }
                String name = p.getName();
                if (checker == null) {
                    checker = new LocalLiteralOccurrenceChecker(node);
                }
                if (checker.isUsedInLiterals(name) || name != null && name.startsWith("ignore")) continue;
                String message = JSUnusedLocalSymbolsInspection.unusedMessage(namedElementKind);
                SmartList fixes = new SmartList();
                if (!(asinfo || node instanceof JSFunction && ((JSFunction)node).isSetProperty())) {
                    FixAndIntentionAction fix = JSFixFactory.getInstance().removeElementLocalQuickFix(namedElementKind, name);
                    fix.registerElementRefForFix(highlightedElement, null);
                    fixes.add(fix);
                }
                if (holder.isOnTheFly() && node instanceof JSFunction && p instanceof JSParameter) {
                    JSFixFactory.getInstance().addFixesForFields((JSFunction)node, highlightedElement, name, (List<LocalQuickFix>)fixes);
                }
                LocalQuickFix[] quickFixes = fixes.size() == 0 ? LocalQuickFix.EMPTY_ARRAY : fixes.toArray(new LocalQuickFix[fixes.size()]);
                holder.registerProblem(highlightedElement, message, asinfo ? ProblemHighlightType.INFORMATION : ProblemHighlightType.LIKE_UNUSED_SYMBOL, quickFixes);
            }
        }
        finally {
            unusedDeclarationsStatus.clear();
        }
    }

    static String unusedMessage(JSNamedElementKind namedElementKind) {
        return JSBundle.message((String)"js.unused.symbol", (Object[])new Object[]{StringUtil.decapitalize((String)JSBundle.message((String)namedElementKind.humanReadableKey(), (Object[])new Object[0]))});
    }

    private void handleLocalDeclaration(JSNamedElement node, LocalInspectionToolSession session, ProblemsHolder holder) {
        JSElement scopeNode = JSUnusedLocalSymbolsInspection.getScopeNode(node);
        if (scopeNode == null) {
            return;
        }
        ConcurrentMap<JSNamedElement, Boolean> unusedLocalDefsSet = this.getUnusedDeclarationsMap((PsiElement)scopeNode, session, holder);
        if (unusedLocalDefsSet == null) {
            return;
        }
        if (this.isLocallyDefined(node, (PsiElement)scopeNode)) {
            this.addUnusedElementIfNotUsedBefore(node, unusedLocalDefsSet);
        }
    }

    static boolean isLocallyDefined(JSNamedElement node) {
        return JSUnusedLocalSymbolsInspection.checkIfLocallyDefined(node, (PsiElement)JSUnusedLocalSymbolsInspection.getScopeNode(node));
    }

    protected static boolean checkIfLocallyDefined(JSNamedElement node, PsiElement scopeNode) {
        if (node instanceof JSFunction && !JSUnusedLocalSymbolsInspection.isSupportedFunction((JSFunction)node)) {
            return false;
        }
        if (!(node instanceof JSAttributeListOwner)) {
            return false;
        }
        if (!(scopeNode instanceof JSClass) && !(scopeNode instanceof JSFile)) {
            return true;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)node).getAttributeList();
        if (scopeNode instanceof JSFile && ((JSFile)scopeNode).isCommonJSModule() && (attributeList == null || attributeList.getExplicitAccessType() != JSAttributeList.AccessType.PUBLIC)) {
            return true;
        }
        if (attributeList == null) {
            return false;
        }
        if (DialectDetector.isTypeScript((PsiElement)node) && TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)node)) {
            return false;
        }
        PsiElement nodeParent = node.getParent();
        return attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || DialectDetector.isActionScript(scopeNode) && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL && nodeParent instanceof JSFile && nodeParent.getContext() == null;
    }

    protected boolean isLocallyDefined(JSNamedElement node, PsiElement scopeNode) {
        return JSUnusedLocalSymbolsInspection.checkIfLocallyDefined(node, scopeNode);
    }

    protected void addUnusedElementIfNotUsedBefore(JSNamedElement node, ConcurrentMap<JSNamedElement, Boolean> unusedLocalDefsSet) {
        unusedLocalDefsSet.putIfAbsent(node, Boolean.TRUE);
    }

    private static JSElement getScopeNode(JSNamedElement node) {
        if (node instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)node).getStub() != null) {
            return null;
        }
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, JSCatchBlock.class, JSClass.class, JSFile.class});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<JSNamedElement, Boolean> getUnusedDeclarationsMap(PsiElement parent, LocalInspectionToolSession session, ProblemsHolder holder) {
        ConcurrentMap unusedMap;
        Map map = (Map)session.getUserData(this.getUnsedScopeMapKey());
        Map unusedFileMap = (Map)map.get(holder);
        if (unusedFileMap == null) {
            LocalInspectionToolSession localInspectionToolSession = session;
            synchronized (localInspectionToolSession) {
                unusedFileMap = (Map)map.get(holder);
                if (unusedFileMap == null) {
                    unusedFileMap = new THashMap();
                    map.put(holder, unusedFileMap);
                }
            }
        }
        if ((unusedMap = (ConcurrentMap)unusedFileMap.get(parent)) == null) {
            LocalInspectionToolSession localInspectionToolSession = session;
            synchronized (localInspectionToolSession) {
                unusedMap = (ConcurrentMap)unusedFileMap.get(parent);
                if (unusedMap == null) {
                    unusedMap = ContainerUtil.newConcurrentMap();
                    unusedFileMap.put(parent, unusedMap);
                }
            }
        }
        return unusedMap;
    }

    protected Key<Map<ProblemsHolder, Map<PsiElement, ConcurrentMap<JSNamedElement, Boolean>>>> getUnsedScopeMapKey() {
        return ourUnusedScopeMapKey;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "inspectionStarted"));
        }
        super.inspectionStarted(session, isOnTheFly);
        session.putUserDataIfAbsent(this.getUnsedScopeMapKey(), (Object)new THashMap());
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "inspectionFinished"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/intellij/lang/javascript/inspections/JSUnusedLocalSymbolsInspection", "inspectionFinished"));
        }
        super.inspectionFinished(session, problemsHolder);
        Map map = (Map)session.getUserData(this.getUnsedScopeMapKey());
        if (map == null) {
            return;
        }
        Map currentFileMap = (Map)map.get(problemsHolder);
        if (currentFileMap == null) {
            return;
        }
        for (Map.Entry e : currentFileMap.entrySet()) {
            this.processDeclarationHost((PsiElement)e.getKey(), (Map)e.getValue(), problemsHolder);
        }
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.ignore.unused.function.parameters", (Object[])new Object[0]), "myIgnoreUnusedFunctionParameters");
        optionsPanel.addCheckbox(JSBundle.message((String)"javascript.ignore.unused.catch.parameters", (Object[])new Object[0]), "myIgnoreUnusedCatchParameters");
        return optionsPanel;
    }

    static class LocalLiteralOccurrenceChecker
    implements Processor<WordOccurrence> {
        private final Map<String, List<JSLiteralExpression>> myCurrentScopeLiteralElements = new THashMap();
        private final WordsScanner myWordsScanner;
        private String myName;
        private boolean myResult;

        public LocalLiteralOccurrenceChecker(PsiElement node) {
            node.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitJSLiteralExpression(JSLiteralExpression node) {
                    if (node.isQuotedLiteral()) {
                        String value = StringUtil.stripQuotesAroundValue((String)node.getText());
                        List expressions = (List)myCurrentScopeLiteralElements.get(value);
                        if (expressions == null) {
                            expressions = new SmartList();
                            myCurrentScopeLiteralElements.put(value, expressions);
                        }
                        expressions.add(node);
                    }
                }
            });
            this.myWordsScanner = ((FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(node.getLanguage())).getWordsScanner();
        }

        public boolean isUsedInLiterals(String name) {
            if (name == null) {
                return false;
            }
            this.myName = name;
            this.myResult = false;
            for (Map.Entry<String, List<JSLiteralExpression>> entry : this.myCurrentScopeLiteralElements.entrySet()) {
                this.myWordsScanner.processWords((CharSequence)entry.getKey(), (Processor)this);
                if (!this.myResult) continue;
                block1: for (JSLiteralExpression literal : entry.getValue()) {
                    for (PsiReference ref : literal.getReferences()) {
                        if (ref instanceof JSModuleBaseReference) continue block1;
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean process(WordOccurrence wordOccurrence) {
            if (CharArrayUtil.regionMatches((CharSequence)wordOccurrence.getBaseText(), (int)wordOccurrence.getStart(), (int)wordOccurrence.getEnd(), (CharSequence)this.myName) && this.myName.length() == wordOccurrence.getEnd() - wordOccurrence.getStart()) {
                this.myResult = true;
                return false;
            }
            return true;
        }
    }
}

