/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveElementLocalQuickFix
extends FixAndIntentionAction
implements BatchQuickFix<CommonProblemDescriptor> {
    private final String myName;
    private final JSNamedElementKind myKind;

    public RemoveElementLocalQuickFix(JSNamedElementKind kind, String name) {
        this.myKind = kind;
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"js.unused.symbol.remove", (Object[])new Object[]{StringUtil.decapitalize((String)JSBundle.message((String)this.myKind.humanReadableKey(), (Object[])new Object[0])), this.myName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/RemoveElementLocalQuickFix", "getName"));
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        PsiElement element = psiElement;
        while (!(element instanceof JSNamedElement)) {
            element = element.getParent();
        }
        final FormatFixer fi = FormatFixer.create(element, FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
        Runnable reformatAfterSuccess = new Runnable(){

            @Override
            public void run() {
                DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        fi.fixFormat();
                    }
                });
            }
        };
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{element}, (boolean)false, (Runnable)reformatAfterSuccess);
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/RemoveElementLocalQuickFix", "applyFix"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/javascript/inspections/RemoveElementLocalQuickFix", "applyFix"));
        }
        if (psiElementsToIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/intellij/lang/javascript/inspections/RemoveElementLocalQuickFix", "applyFix"));
        }
        for (CommonProblemDescriptor descriptor : descriptors) {
            PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
            if (psiElement == null) continue;
            while (!(psiElement instanceof JSNamedElement)) {
                psiElement = psiElement.getParent();
            }
            psiElementsToIgnore.add(psiElement);
        }
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray(psiElementsToIgnore), (boolean)false, (Runnable)refreshViews);
    }
}

