/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringConcatenationToES6TemplateIntention
extends JavaScriptIntention {
    private static final Set<Class<? extends JSExpression>> ACCEPTED_EXPRESSIONS = new HashSet<Class<? extends JSExpression>>();
    private static final Condition<PsiElement> BINARY_EXPRESSION_PREDICATE;

    public JSStringConcatenationToES6TemplateIntention() {
        this.setText(JSBundle.message((String)"js.replace.string.concatenation.with.es6.template", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!DialectDetector.isES6Dialect(element)) {
            return false;
        }
        if (element.getContainingFile() instanceof JSFile || PsiTreeUtil.getParentOfType((PsiElement)element, JSEmbeddedContent.class, (boolean)false) != null) {
            return JSStringConcatenationToES6TemplateIntention.findSuitableExpression(element, new Factory<ExpressionIterator>(){

                public ExpressionIterator create() {
                    return new ExpressionIterator(true);
                }
            });
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "invoke"));
        }
        JSStringConcatenationToES6TemplateIntention.findSuitableExpression(element, new TemplateAssembler(project, true));
    }

    @NotNull
    private static String unquoteUnescape(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "unquoteUnescape"));
        }
        String string = StringUtil.unquoteString((String)element.getText());
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (!escaped) {
                if ('\\' == ch) {
                    escaped = true;
                    continue;
                }
                sb.append(ch);
                continue;
            }
            if ('\"' != ch && '\'' != ch) {
                sb.append('\\');
            }
            sb.append(ch);
            escaped = false;
        }
        String string2 = sb.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "unquoteUnescape"));
        }
        return string2;
    }

    private static boolean findSuitableExpression(@NotNull PsiElement element, @NotNull Factory<ExpressionIterator> factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "findSuitableExpression"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "findSuitableExpression"));
        }
        List<JSBinaryExpression> list = JSStringConcatenationToES6TemplateIntention.findExpressionsList(element);
        if (list == null) {
            PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)element);
            if (host != null) {
                list = JSStringConcatenationToES6TemplateIntention.findExpressionsList((PsiElement)host);
            }
            if (list == null) {
                return JSStringConcatenationToES6TemplateIntention.tryLiteralVariant(element, factory);
            }
        }
        Collections.reverse(list);
        for (JSBinaryExpression expression : list) {
            ExpressionIterator expressionIterator = (ExpressionIterator)factory.create();
            if (!expressionIterator.iterateBinaryExpression((JSExpression)expression)) continue;
            return true;
        }
        return JSStringConcatenationToES6TemplateIntention.tryLiteralVariant(element, factory);
    }

    private static boolean tryLiteralVariant(@NotNull PsiElement element, @NotNull Factory<ExpressionIterator> factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "tryLiteralVariant"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "tryLiteralVariant"));
        }
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            return ((ExpressionIterator)factory.create()).forQuotedLiteral(element);
        }
        if (element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == JSTokenTypes.STRING_LITERAL && element.getParent() instanceof JSLiteralExpression) {
            return ((ExpressionIterator)factory.create()).forQuotedLiteral(element);
        }
        return false;
    }

    @Nullable
    private static List<JSBinaryExpression> findExpressionsList(@NotNull PsiElement element) {
        JSBinaryExpression parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "findExpressionsList"));
        }
        ArrayList<JSBinaryExpression> list = new ArrayList<JSBinaryExpression>();
        JSBinaryExpression previous = null;
        while ((parent = (JSBinaryExpression)PsiTreeUtil.findFirstParent((PsiElement)(previous == null ? element : previous.getParent()), BINARY_EXPRESSION_PREDICATE)) != null) {
            list.add(parent);
            previous = parent;
        }
        if (previous == null) {
            return null;
        }
        return list;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.replace.string.concatenation.with.es6.template.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention", "getFamilyName"));
        }
        return string;
    }

    static {
        ACCEPTED_EXPRESSIONS.add(JSCallExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSReferenceExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSPostfixExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSPrefixExpression.class);
        ACCEPTED_EXPRESSIONS.add(JSIndexedPropertyAccessExpression.class);
        BINARY_EXPRESSION_PREDICATE = new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return element instanceof JSBinaryExpression;
            }
        };
    }

    private static class TemplateAssembler
    implements Factory<ExpressionIterator> {
        private final StringBuilder mySb;
        private final Project myProject;
        private final boolean myIsTopLevel;

        public TemplateAssembler(Project project, boolean isTopLevel) {
            this.myIsTopLevel = isTopLevel;
            this.mySb = new StringBuilder();
            this.myProject = project;
        }

        public ExpressionIterator create() {
            return new ExpressionIterator(this.myIsTopLevel){

                @Override
                public boolean forQuotedLiteral(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$TemplateAssembler$1", "forQuotedLiteral"));
                    }
                    PsiFile dummy = PsiFileFactory.getInstance((Project)myProject).createFileFromText((Language)JavascriptLanguage.INSTANCE, (CharSequence)("`" + StringUtil.unquoteString((String)element.getText()) + "`"));
                    element.replace(PsiTreeUtil.findChildOfType((PsiElement)dummy, JSLiteralExpression.class));
                    return true;
                }

                @Override
                protected void onLeafElement(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$TemplateAssembler$1", "onLeafElement"));
                    }
                    if (element instanceof JSLiteralExpression) {
                        mySb.append(JSStringConcatenationToES6TemplateIntention.unquoteUnescape(element));
                    }
                    for (Class aClass : ACCEPTED_EXPRESSIONS) {
                        if (!aClass.isAssignableFrom(element.getClass())) continue;
                        mySb.append("${").append(element.getText()).append("}");
                        break;
                    }
                }

                @Override
                protected void onMatch(JSExpression expression) {
                    if (myIsTopLevel) {
                        PsiFile dummy = PsiFileFactory.getInstance((Project)myProject).createFileFromText((Language)JavascriptLanguage.INSTANCE, (CharSequence)("`" + mySb.toString() + "`"));
                        expression.replace((JSExpression)PsiTreeUtil.findChildOfType((PsiElement)dummy, JSLiteralExpression.class));
                    }
                }

                @Override
                protected boolean onParenthesizedExpression(JSParenthesizedExpression operand) {
                    TemplateAssembler assembler = new TemplateAssembler(myProject, false);
                    ExpressionIterator expressionIterator = assembler.create();
                    expressionIterator.iterateBinaryExpression(operand.getInnerExpression());
                    if (!expressionIterator.myFoundQuotedLiteral) {
                        mySb.append("${").append(operand.getText()).append("}");
                        this.myReferenceFound |= expressionIterator.myReferenceFound;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    private static class ExpressionIterator {
        protected boolean myFoundQuotedLiteral;
        protected boolean myReferenceFound;
        protected boolean myWrong;
        protected final ArrayDeque<JSExpression> myQueue;
        private final boolean myIsTopLevel;

        public ExpressionIterator(boolean topLevel) {
            this.myIsTopLevel = topLevel;
            this.myQueue = new ArrayDeque();
        }

        public boolean forQuotedLiteral(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$ExpressionIterator", "forQuotedLiteral"));
            }
            return true;
        }

        public boolean iterateBinaryExpression(JSExpression element) {
            this.myQueue.add(element);
            while (!this.myQueue.isEmpty()) {
                JSExpression expression = this.myQueue.removeFirst();
                if (expression instanceof JSBinaryExpression) {
                    JSBinaryExpression binary = (JSBinaryExpression)expression;
                    if (this.myIsTopLevel && binary.getOperationSign() != JSTokenTypes.PLUS) {
                        return false;
                    }
                    if (!this.checkOperand(binary.getLOperand())) {
                        if (this.myWrong) {
                            return false;
                        }
                        this.addToQueue(binary.getROperand(), false);
                        this.addToQueue(binary.getLOperand(), true);
                        continue;
                    }
                    if (this.checkOperand(binary.getROperand())) continue;
                    if (this.myWrong) {
                        return false;
                    }
                    this.addToQueue(binary.getROperand(), true);
                    continue;
                }
                if (this.checkOperand(expression)) continue;
                if (this.myWrong) {
                    return false;
                }
                this.addToQueue(expression, true);
            }
            boolean result = this.myFoundQuotedLiteral;
            if (result) {
                this.onMatch(element);
            }
            return result;
        }

        protected void onMatch(JSExpression element) {
        }

        private void addToQueue(@Nullable JSExpression expression, boolean unRollParenthesizes) {
            if (expression == null) {
                return;
            }
            expression = unRollParenthesizes && expression instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)expression).getInnerExpression() : expression;
            this.myQueue.addFirst(expression);
        }

        private boolean checkOperand(JSExpression operand) {
            if (operand == null) {
                return false;
            }
            if (operand instanceof JSParenthesizedExpression) {
                return this.onParenthesizedExpression((JSParenthesizedExpression)operand);
            }
            if (operand instanceof JSBinaryExpression) {
                return false;
            }
            if (operand instanceof JSLiteralExpression) {
                if (((JSLiteralExpression)operand).isQuotedLiteral()) {
                    this.myFoundQuotedLiteral = true;
                }
                this.onLeafElement((PsiElement)operand);
                return true;
            }
            for (Class aClass : ACCEPTED_EXPRESSIONS) {
                if (!aClass.isAssignableFrom(operand.getClass())) continue;
                this.myReferenceFound = true;
                this.onLeafElement((PsiElement)operand);
                return true;
            }
            this.myWrong = true;
            return false;
        }

        protected boolean onParenthesizedExpression(JSParenthesizedExpression operand) {
            TemplateAssembler assembler = new TemplateAssembler(operand.getProject(), false);
            ExpressionIterator expressionIterator = assembler.create();
            expressionIterator.iterateBinaryExpression(operand.getInnerExpression());
            if (!expressionIterator.myFoundQuotedLiteral) {
                this.myReferenceFound |= expressionIterator.myReferenceFound;
                return true;
            }
            return false;
        }

        protected void onLeafElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSStringConcatenationToES6TemplateIntention$ExpressionIterator", "onLeafElement"));
            }
        }

        public boolean isFoundQuotedLiteral() {
            return this.myFoundQuotedLiteral;
        }
    }
}

