/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureProcessor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptModifierIntention
extends JavaScriptIntention
implements LowPriorityAction {
    private static final String REFACTORING_NAME = "Change visibility";

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "invoke"));
        }
        TypeScriptFunction method = this.getFunction(element);
        if (method != null) {
            this.invokeForFunction(project, element, (JSFunction)method);
            return;
        }
        JSVariable field = this.getField(element);
        if (field != null) {
            this.invokeForField(project, element, field);
        }
    }

    private void invokeForField(@NotNull Project project, @NotNull PsiElement element, JSVariable field) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "invokeForField"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "invokeForField"));
        }
        JSAttributeList.AccessType type = this.getInspectionAccessType();
        JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)field, type, null);
    }

    private void invokeForFunction(@NotNull Project project, @NotNull PsiElement element, JSFunction method) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "invokeForFunction"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "invokeForFunction"));
        }
        if (method == null) {
            return;
        }
        if ((method = this.getParentFunction(method, project, element)) == null) {
            return;
        }
        JSParameter[] parameters = method.getParameterVariables();
        JSParameterInfo[] infos = new JSParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            infos[i] = JSParameterInfo.build(parameters[i], i);
        }
        JSType type = method.getReturnType();
        String stringType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
        JSChangeSignatureProcessor processor = new JSChangeSignatureProcessor(method, this.getInspectionAccessType(), method.getName(), stringType, infos, Collections.emptySet());
        processor.setPrepareSuccessfulSwingThreadCallback(new Runnable(){

            @Override
            public void run() {
            }
        });
        processor.run();
    }

    @Nullable
    protected JSFunction getParentFunction(@Nullable JSFunction method, @NotNull Project project, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "getParentFunction"));
        }
        if (method == null) {
            return null;
        }
        Map<JSClass, JSFunction> map = JSInheritanceUtil.findDeclaringClassesMap(method);
        if (map.size() != 1) {
            return method;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map.entrySet());
        if (item == null) {
            return method;
        }
        JSFunction value = (JSFunction)item.getValue();
        if (value.equals(method)) {
            return method;
        }
        return this.getParentFunction(value, project, context);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof JSFile)) {
            return false;
        }
        if (!DialectDetector.isTypeScript(element)) {
            return false;
        }
        return this.checkForFunction(project, element) || this.checkForField(project, element);
    }

    private boolean checkForFunction(@NotNull Project project, @NotNull PsiElement element) {
        JSClass parentClass;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "checkForFunction"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "checkForFunction"));
        }
        TypeScriptFunction function = this.getFunction(element);
        if (function == null || function.getAttributeList() == null || function.isConstructor()) {
            return false;
        }
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)function);
        if (jsClass == null || jsClass.isInterface()) {
            return false;
        }
        JSFunction parentFunction = this.getParentFunction((JSFunction)function, project, element);
        if (parentFunction != function && ((parentClass = JSResolveUtil.getClassOfContext((PsiElement)parentFunction)) == null || parentClass.isInterface())) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)function);
        return modifier != this.getInspectionAccessType();
    }

    private boolean checkForField(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "checkForField"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "checkForField"));
        }
        JSVariable field = this.getField(element);
        if (field == null || field.getAttributeList() == null) {
            return false;
        }
        JSAttributeList.AccessType modifier = this.getCurrentModifier((JSAttributeListOwner)field);
        return modifier != this.getInspectionAccessType();
    }

    @Nullable
    protected JSAttributeList.AccessType getCurrentModifier(@NotNull JSAttributeListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "getCurrentModifier"));
        }
        JSAttributeList list = owner.getAttributeList();
        if (list == null) {
            return null;
        }
        return list.getAccessType();
    }

    @Nullable
    protected JSVariable getField(@NotNull PsiElement current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "getField"));
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)current, JSStatement.class);
        if (statement == null || !(statement instanceof JSVarStatement)) {
            return null;
        }
        JSVarStatement varStatement = (JSVarStatement)statement;
        PsiElement parent = varStatement.getParent();
        if (parent instanceof JSClass && !(parent instanceof TypeScriptEnum)) {
            int length;
            if (current.getParent() instanceof JSAttributeList && (length = varStatement.getVariables().length) == 1) {
                return varStatement.getVariables()[0];
            }
            return (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)current, JSVariable.class);
        }
        return null;
    }

    @Nullable
    protected TypeScriptFunction getFunction(@NotNull PsiElement current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "getFunction"));
        }
        PsiElement parent = current.getParent();
        if (parent instanceof JSAttributeList) {
            parent = parent.getParent();
        }
        return parent instanceof TypeScriptFunction ? (TypeScriptFunction)parent : null;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = "Make '" + JSVisibilityUtil.accessTypeToKeyword(this.getInspectionAccessType(), DialectOptionHolder.TS) + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/TypeScriptModifierIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public abstract JSAttributeList.AccessType getInspectionAccessType();
}

