/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLibraryUtil {
    public static final String[] MIN_SUFFIXES = new String[]{".min.", "-min.", "-yui-compressed"};
    public static final HashMap<String, String> MIN_TO_DEV_VERSION_MAP = new HashMap();
    private static final String[] LIBRARY_DIR_NAMES = new String[]{"node_modules", "bower_components"};
    private static final String JS_EXT = ".js";
    private static final String[] HTTP_PREFIXES;

    private JSLibraryUtil() {
    }

    public static boolean containsLibURL(String location) {
        return HtmlUtil.hasHtmlPrefix((String)location) && location.endsWith(JS_EXT);
    }

    public static String getDevVersionLocation(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/lang/javascript/library/JSLibraryUtil", "getDevVersionLocation"));
        }
        if (!location.endsWith(JS_EXT)) {
            return location;
        }
        String oldFileName = JSLibraryUtil.extractFileName(location);
        String fileName = oldFileName;
        if (MIN_TO_DEV_VERSION_MAP.containsKey((Object)fileName)) {
            return location.replace(oldFileName, (CharSequence)MIN_TO_DEV_VERSION_MAP.get((Object)fileName));
        }
        for (String minSuffix : MIN_SUFFIXES) {
            if (!fileName.contains(minSuffix)) continue;
            fileName = oldFileName.replace(minSuffix, ".");
            return location.replace(oldFileName, fileName);
        }
        return location;
    }

    public static String makeUniqueFileName(String filePath, boolean adjustFileName) {
        String path = filePath;
        for (String prefix : HTTP_PREFIXES) {
            if (!filePath.contains(prefix)) continue;
            path = filePath.replace(prefix, "http_");
            break;
        }
        if (adjustFileName) {
            String fileName = JSLibraryUtil.extractFileName(filePath);
            if (MIN_TO_DEV_VERSION_MAP.containsKey((Object)fileName)) {
                path = path.replace(fileName, (CharSequence)MIN_TO_DEV_VERSION_MAP.get((Object)fileName));
            } else {
                for (String minSuffix : MIN_SUFFIXES) {
                    if (!filePath.contains(minSuffix)) continue;
                    path = path.replace(minSuffix, ".");
                    break;
                }
            }
        }
        return path.replace('/', '_').replace('\\', '_');
    }

    public static String extractFileName(String filePath) {
        int fileSepIndex = filePath.lastIndexOf(47);
        if (fileSepIndex < 0) {
            fileSepIndex = filePath.lastIndexOf(File.separatorChar);
        }
        return fileSepIndex >= 0 ? filePath.substring(fileSepIndex + 1, filePath.length()) : filePath;
    }

    @Nullable
    public static String getCanonicalUrl(String path) {
        File file = new File(path);
        try {
            return VfsUtilCore.pathToUrl((String)file.getCanonicalPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getLibName(String location) {
        int dotIndex;
        String libName = JSLibraryUtil.extractFileName(location);
        if (!MIN_TO_DEV_VERSION_MAP.containsKey((Object)libName)) {
            for (String minSuffix : MIN_SUFFIXES) {
                if (!libName.contains(minSuffix)) continue;
                libName = libName.replace(minSuffix, ".");
                break;
            }
        }
        if ((dotIndex = libName.lastIndexOf(46)) >= 0) {
            libName = libName.substring(0, dotIndex);
        }
        return libName;
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isProbableLibraryFile"));
        }
        return JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, null);
    }

    public static boolean isProbableLibraryFile(@NotNull VirtualFile file, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isProbableLibraryFile"));
        }
        return JSLibraryUtil.hasDirectoryInPath(file, LIBRARY_DIR_NAMES, fileToStop);
    }

    private static boolean hasDirectoryInPath(@NotNull VirtualFile file, @NotNull String[] dirNames, @Nullable VirtualFile fileToStop) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "hasDirectoryInPath"));
        }
        if (dirNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirNames", "com/intellij/lang/javascript/library/JSLibraryUtil", "hasDirectoryInPath"));
        }
        for (VirtualFile parent = file.getParent(); !(parent == null || fileToStop != null && parent.equals(fileToStop)); parent = parent.getParent()) {
            CharSequence name = parent.getNameSequence();
            for (String dirName : dirNames) {
                if (!StringUtil.equals((CharSequence)dirName, (CharSequence)name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isProbableLibraryPath(@NotNull String file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSLibraryUtil", "isProbableLibraryPath"));
        }
        String name = FileUtil.toSystemDependentName((String)file);
        for (String s : FileUtil.splitPath((String)name)) {
            if (!ArrayUtil.contains((String)s, (String[])LIBRARY_DIR_NAMES)) continue;
            return true;
        }
        return false;
    }

    static {
        MIN_TO_DEV_VERSION_MAP.put((Object)"dojo.xd.js", (Object)"dojo.xd.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"dojo.js", (Object)"dojo.js.uncompressed.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"ext-core.js", (Object)"ext-core-debug.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"swfobject.js", (Object)"swfobject_src.js");
        MIN_TO_DEV_VERSION_MAP.put((Object)"webfont.js", (Object)"webfont_debug.js");
        HTTP_PREFIXES = new String[]{"http://", "https://"};
    }
}

