/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPredefinedLibrariesData {
    private final Set<String> myLibraryNames;
    private final Set<VirtualFile> myLibraryFiles;
    private final Map<String, VirtualFile> myLibraryFileByNameMap;

    private JSPredefinedLibrariesData(@NotNull Set<String> libraryNames, @NotNull Set<VirtualFile> libraryFiles) {
        if (libraryNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryNames", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "<init>"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "<init>"));
        }
        this.myLibraryNames = libraryNames;
        this.myLibraryFiles = Collections.unmodifiableSet(libraryFiles);
        this.myLibraryFileByNameMap = ContainerUtilRt.newHashMap((int)libraryFiles.size());
        for (VirtualFile libraryFile : libraryFiles) {
            this.myLibraryFileByNameMap.put(libraryFile.getName(), libraryFile);
        }
    }

    public boolean isPredefinedLibrary(@NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "isPredefinedLibrary"));
        }
        return this.myLibraryNames.contains(libraryName);
    }

    @NotNull
    public Set<VirtualFile> getLibraryFiles() {
        Set<VirtualFile> set = this.myLibraryFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "getLibraryFiles"));
        }
        return set;
    }

    @Nullable
    public VirtualFile findPredefinedFileByName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "findPredefinedFileByName"));
        }
        return this.myLibraryFileByNameMap.get(fileName);
    }

    public boolean isPredefinedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "isPredefinedFile"));
        }
        return this.myLibraryFiles.contains(file);
    }

    public static JSPredefinedLibrariesData create(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSPredefinedLibrariesData", "create"));
        }
        HashSet result = ContainerUtil.newHashSet();
        result.addAll(JSPredefinedLibraryProvider.getAllRequiredLibraryFiles());
        HashSet libraryNames = ContainerUtil.newHashSet();
        Set<ScriptingLibraryModel> models = JSPredefinedLibraryProvider.getAllPredefinedLibraries(project);
        for (ScriptingLibraryModel model : models) {
            libraryNames.add(model.getName());
            result.addAll(model.getSourceFiles());
        }
        return new JSPredefinedLibrariesData(libraryNames, result);
    }
}

