/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.BidirectionalMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSPredefinedLibraryRenamingManager {
    private final BidirectionalMap<String, String> myPresentationBySerializationNameMap = new BidirectionalMap();

    public JSPredefinedLibraryRenamingManager() {
        for (JSPredefinedLibraryProvider provider : (JSPredefinedLibraryProvider[])JSPredefinedLibraryProvider.EP_NAME.getExtensions()) {
            this.myPresentationBySerializationNameMap.putAll(provider.getPredefinedLibraryRenamingMap());
        }
    }

    @NotNull
    protected String getSerializationNameByPresentationName(@NotNull String presentationName) {
        if (presentationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationName", "com/intellij/lang/javascript/library/JSPredefinedLibraryRenamingManager", "getSerializationNameByPresentationName"));
        }
        List serializationNames = this.myPresentationBySerializationNameMap.getKeysByValue((Object)presentationName);
        if (serializationNames != null && serializationNames.size() == 1) {
            String string = (String)serializationNames.get(0);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryRenamingManager", "getSerializationNameByPresentationName"));
            }
            return string;
        }
        String string = presentationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryRenamingManager", "getSerializationNameByPresentationName"));
        }
        return string;
    }

    @NotNull
    protected String getPresentationNameBySerializationName(@NotNull String serializationName) {
        if (serializationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializationName", "com/intellij/lang/javascript/library/JSPredefinedLibraryRenamingManager", "getPresentationNameBySerializationName"));
        }
        String presentationName = (String)this.myPresentationBySerializationNameMap.get((Object)serializationName);
        String string = (String)ObjectUtils.notNull((Object)presentationName, (Object)serializationName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSPredefinedLibraryRenamingManager", "getPresentationNameBySerializationName"));
        }
        return string;
    }
}

