/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class EslintUtil {
    public static final String DEFAULT_CONFIG_FILENAME = ".eslintrc";
    public static final String DEFAULT_IGNORE_FILENAME = ".eslintignore";
    public static final String PACKAGE_NAME = "eslint";

    private EslintUtil() {
    }

    @NotNull
    public static String getAbsoluteOrRelativePathToProjectRoot(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        VirtualFile root = project.getBaseDir();
        if (root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        return string;
    }

    public static boolean isEslintConfigFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        PsiFile file = element.getContainingFile();
        if (file != null) {
            file = file.getOriginalFile();
        }
        return file != null && EslintUtil.isEslintConfigFile(file);
    }

    public static boolean isEslintConfigFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        return ((Object)((Object)EslintConfigFileType.INSTANCE)).equals(vFile.getFileType());
    }
}

