/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.importer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.NavigateToPropertyInConfig;
import com.intellij.lang.javascript.linter.jscs.JscsConfiguration;
import com.intellij.lang.javascript.linter.jscs.JscsPreset;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.lang.javascript.linter.jscs.importer.AppliedRule;
import com.intellij.lang.javascript.linter.jscs.importer.ImportRule;
import com.intellij.lang.javascript.linter.jscs.importer.JscsRulesForCodeStyle;
import com.intellij.lang.javascript.linter.jscs.importer.PairImportRule;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.Function;
import com.intellij.util.containers.hash.HashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JscsSchemeImportWorker {
    private Map<JscsOption, ImportRule> myRulesMap;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    private final Map<JscsOption, VirtualFile> myRulesSources;
    private final Set<String> myUnknown;
    private HashMap<JscsOption, PairImportRule> myPairRules;

    public JscsSchemeImportWorker(@NotNull Project project, @NotNull VirtualFile selectedFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImportWorker", "<init>"));
        }
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImportWorker", "<init>"));
        }
        this.myProject = project;
        this.myFile = selectedFile;
        this.myRulesSources = new HashMap();
        this.myUnknown = new HashSet<String>();
    }

    @Nullable
    public CodeStyleScheme importScheme(Getter<CodeStyleScheme> factory, JscsPreset preset, String jscsPath) throws SchemeImportException {
        AppliedRule rule;
        Map<JscsOption, JsonElement> map = this.combineConfigs(preset, jscsPath);
        if (map.isEmpty()) {
            String message = "JSCS scheme was not imported from '" + jscsPath + "': no rules were found.";
            JscsConfiguration.IMPORT_CONFIG_NOTIFICATION.createNotification(message, NotificationType.INFORMATION).setImportant(false).notify(this.myProject);
            throw new SchemeImportException(message).setWarning();
        }
        CodeStyleScheme scheme = (CodeStyleScheme)factory.get();
        CodeStyleSettings settings = scheme.getCodeStyleSettings();
        CommonCodeStyleSettings languageSettings = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings jsCodeStyleSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        HashMap applied = new HashMap();
        HashSet<JscsOption> skipped = new HashSet<JscsOption>();
        for (Map.Entry<JscsOption, JsonElement> entry : map.entrySet()) {
            rule = this.myRulesMap.get((Object)entry.getKey());
            if (rule != null && ((ImportRule)rule).apply(entry.getValue(), languageSettings, jsCodeStyleSettings)) {
                applied.put(entry.getKey(), rule);
                continue;
            }
            skipped.add(entry.getKey());
        }
        for (Map.Entry<JscsOption, Object> entry : this.myPairRules.entrySet()) {
            rule = (PairImportRule)entry.getValue();
            JscsOption pairRule = ((PairImportRule)rule).getPairRule();
            JscsOption option = entry.getKey();
            if (!skipped.contains((Object)option) || !skipped.contains((Object)pairRule) || !((PairImportRule)rule).apply(map.get((Object)option), map.get((Object)pairRule), languageSettings, jsCodeStyleSettings)) continue;
            skipped.remove((Object)option);
            skipped.remove((Object)pairRule);
            applied.put(option, rule);
        }
        this.showReport(scheme.getName(), (Map<JscsOption, AppliedRule>)applied, new ArrayList<JscsOption>(skipped));
        return scheme;
    }

    private Map<JscsOption, JsonElement> combineConfigs(JscsPreset preset, String jscsPath) throws SchemeImportException {
        this.myRulesMap = new HashMap();
        this.myPairRules = new HashMap();
        JscsRulesForCodeStyle.fillRules(this.myRulesMap, this.myPairRules);
        HashMap map = new HashMap();
        if (preset != null) {
            if (StringUtil.isEmptyOrSpaces((String)jscsPath)) {
                throw new SchemeImportException("Path to JSCS not provided");
            }
            File file = new File(jscsPath);
            file = !file.isAbsolute() ? new File(this.myProject.getBasePath(), jscsPath) : file;
            File presetFile = new File(file, "presets/" + preset.name() + ".json");
            if (!presetFile.exists()) {
                throw new SchemeImportException("Can not find " + preset.getDisplayName() + " file in " + presetFile.getPath());
            }
            VirtualFile presetVf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(presetFile);
            if (presetVf == null) {
                throw new SchemeImportException("Can not find " + preset.getDisplayName() + " file in " + presetFile.getPath());
            }
            map.putAll(this.readConfig(presetVf));
            for (JscsOption option : map.keySet()) {
                this.myRulesSources.put(option, presetVf);
            }
        }
        Map<JscsOption, JsonElement> configMap = this.readConfig(this.myFile);
        map.putAll(configMap);
        for (JscsOption option : configMap.keySet()) {
            this.myRulesSources.put(option, this.myFile);
        }
        return map;
    }

    private Map<JscsOption, JsonElement> readConfig(@NotNull VirtualFile file) throws SchemeImportException {
        JsonObject object;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImportWorker", "readConfig"));
        }
        String json = JscsSchemeImportWorker.loadJson(file);
        try {
            JsonElement rootElement = new JsonParser().parse(json);
            object = rootElement == null || !rootElement.isJsonObject() ? null : rootElement.getAsJsonObject();
        }
        catch (JsonParseException e) {
            object = null;
        }
        if (object == null) {
            JscsSchemeImportWorker.canNotParse(file);
            return null;
        }
        Set properties = object.entrySet();
        Iterator iterator = properties.iterator();
        HashMap map = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            JscsOption option = JscsOption.safeValueOf((String)next.getKey());
            if (option == null) {
                this.myUnknown.add((String)next.getKey());
                continue;
            }
            map.put(option, next.getValue());
        }
        return map;
    }

    private static void canNotParse(@NotNull VirtualFile file) throws SchemeImportException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImportWorker", "canNotParse"));
        }
        throw new SchemeImportException("Can not import from JSCS config file (" + file.getPath() + "): can not parse file.");
    }

    private static String loadJson(@NotNull VirtualFile selectedFile) throws SchemeImportException {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImportWorker", "loadJson"));
        }
        try {
            return VfsUtil.loadText((VirtualFile)selectedFile);
        }
        catch (IOException e) {
            throw new SchemeImportException((Throwable)e);
        }
    }

    private void showReport(String schemeName, Map<JscsOption, AppliedRule> applied, List<JscsOption> skipped) {
        StringBuilder sb = new StringBuilder("<b>JSCS: ").append(this.myFile.getName()).append(" (").append(this.myFile.getParent().getPath()).append(") successfully imported into '").append(schemeName).append("' scheme.</b><br/><br/>");
        JscsSchemeImportWorker.createReportContent(applied, skipped, this.myUnknown, sb);
        JscsConfiguration.IMPORT_CONFIG_NOTIFICATION.createNotification("", sb.toString(), NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                JscsOption option;
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImportWorker$1", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/linter/jscs/importer/JscsSchemeImportWorker$1", "hyperlinkUpdate"));
                }
                String description = event.getDescription();
                if (description.startsWith("#") && (option = JscsOption.safeValueOf(description.substring(1))) != null) {
                    VirtualFile source = (VirtualFile)JscsSchemeImportWorker.this.myRulesSources.get((Object)option);
                    assert (source != null);
                    if (source != null) {
                        NavigateToPropertyInConfig.navigate(JscsSchemeImportWorker.this.myProject, source, description.substring(1));
                    }
                }
            }
        }).setImportant(false).notify(this.myProject);
    }

    private static void createReportContent(Map<JscsOption, AppliedRule> applied, List<JscsOption> skipped, Set<String> unknownSet, StringBuilder sb) {
        if (applied.isEmpty() && skipped.isEmpty() && unknownSet.isEmpty()) {
            sb.append("No rules were found.");
            return;
        }
        boolean contentBefore = false;
        if (!applied.isEmpty()) {
            JscsSchemeImportWorker.reportApplied(applied, sb);
            contentBefore = true;
        }
        if (!skipped.isEmpty()) {
            if (contentBefore) {
                sb.append("<br/><br/>");
            }
            Collections.sort(skipped);
            sb.append("Skipped: ");
            sb.append(StringUtil.join(skipped, (Function)new Function<JscsOption, String>(){

                public String fun(JscsOption option) {
                    return JscsSchemeImportWorker.ruleUrl(option);
                }
            }, (String)", "));
        }
        if (!unknownSet.isEmpty()) {
            ArrayList<String> unknown = new ArrayList<String>(unknownSet);
            if (contentBefore) {
                sb.append("<br/><br/>");
            }
            Collections.sort(unknown);
            sb.append("Unknown:<br/>");
            sb.append(StringUtil.join(unknown, (String)"<br/>"));
        }
    }

    private static void reportApplied(Map<JscsOption, AppliedRule> applied, StringBuilder sb) {
        ArrayList<JscsOption> options = new ArrayList<JscsOption>(applied.keySet());
        Collections.sort(options);
        sb.append("Applied rules:<br/><br/>");
        for (JscsOption option : options) {
            AppliedRule rule = applied.get((Object)option);
            sb.append("<br/>").append(JscsSchemeImportWorker.ruleUrl(option)).append(":<br/>").append(rule.getResultDescription()).append("<br/><br/>").append("(from ").append(rule.getTextValue()).append(") ");
        }
    }

    private static String ruleUrl(JscsOption option) {
        return "<a href='#" + option.name() + "'>" + option.name() + "</a>";
    }
}

