/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.Function;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigFileView {
    private final JPanel myComponent;
    private final JRadioButton myDefaultRadioButton;
    private final JRadioButton myCustomRadioButton;
    private final TextFieldWithHistoryWithBrowseButton myCustomConfigField;
    private final List<Pair<JRadioButton, JComponent>> myRadioButtonWithContentList;
    private final JLabel myCustomConfigFileErrorLabel;

    public JSHintConfigFileView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "<init>"));
        }
        this.myDefaultRadioButton = new JBRadioButton(JSBundle.message((String)"jshint.config.option.default.name", (Object[])new Object[0]));
        JEditorPane defaultContentEditor = JSLinterUtil.createDefaultContent(JSBundle.message((String)"jshint.config.default.description", (Object[])new Object[0]));
        JPanel defaultContent = SwingHelper.wrapWithHorizontalStretch((JComponent)defaultContentEditor);
        this.myCustomRadioButton = new JBRadioButton(JSBundle.message((String)"jshint.config.option.custom.name", (Object[])new Object[0]));
        this.myCustomConfigField = JSHintConfigFileView.createCustomConfigField(project);
        this.myCustomConfigFileErrorLabel = new JLabel();
        this.myCustomConfigFileErrorLabel.setFont(UIUtil.getTitledBorderFont());
        JPanel customContent = JSHintConfigFileView.createCustomContent(this.myCustomConfigField, this.myCustomConfigFileErrorLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myDefaultRadioButton);
        buttonGroup.add(this.myCustomRadioButton);
        this.myRadioButtonWithContentList = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)this.myDefaultRadioButton, (Object)defaultContent), Pair.create((Object)this.myCustomRadioButton, (Object)customContent)});
        this.selectOption(this.myDefaultRadioButton, true);
        ((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                JSHintConfigFileView.this.updateCustomErrorMessage();
            }
        });
        this.myComponent = this.createResultPanel(this.myRadioButtonWithContentList);
    }

    private void selectOption(@NotNull JRadioButton radioButton, boolean selected) {
        if (radioButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "radioButton", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "selectOption"));
        }
        for (Pair<JRadioButton, JComponent> pair : this.myRadioButtonWithContentList) {
            boolean pairSelected = pair.getFirst() == radioButton ? selected : !selected;
            ((JRadioButton)pair.getFirst()).setSelected(pairSelected);
            UIUtil.setEnabled((Component)((Component)pair.getSecond()), (boolean)pairSelected, (boolean)true);
        }
        this.updateCustomErrorMessage();
    }

    private void updateCustomErrorMessage() {
        boolean visible = this.myCustomRadioButton.isSelected() && this.myCustomRadioButton.isEnabled();
        this.myCustomConfigFileErrorLabel.setVisible(visible);
        if (visible) {
            String errorMessage = JSHintConfigFileView.formatErrorMessage(((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getText());
            if (errorMessage != null) {
                String html = XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + errorMessage + "</font>"));
                this.myCustomConfigFileErrorLabel.setText(html);
            } else {
                this.myCustomConfigFileErrorLabel.setText("");
            }
        }
    }

    @Nullable
    private static String formatErrorMessage(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "formatErrorMessage"));
        }
        if (path.trim().isEmpty()) {
            return "Empty path";
        }
        File file = new File(path);
        if (!file.isAbsolute() || !file.isFile()) {
            return "No such file";
        }
        return null;
    }

    @NotNull
    private JPanel createResultPanel(@NotNull List<Pair<JRadioButton, JComponent>> contentByRadioButton) {
        if (contentByRadioButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentByRadioButton", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "createResultPanel"));
        }
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            final JRadioButton jRadioButton = (JRadioButton)pair.getFirst();
            jRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JSHintConfigFileView.this.selectOption(jRadioButton, jRadioButton.isSelected());
                }
            });
        }
        ArrayList components = ContainerUtil.newArrayList();
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            if (!components.isEmpty()) {
                components.add(Box.createVerticalStrut(10));
            }
            JRadioButton radioButton = (JRadioButton)pair.getFirst();
            components.add(radioButton);
            int leftMargin = radioButton.getInsets().left + radioButton.getMargin().left + JSLinterUtil.getRadioIconWidth() + radioButton.getIconTextGap();
            JPanel wrap = SwingHelper.wrapWithHorizontalStretch((JComponent)((JComponent)pair.getSecond()));
            wrap.setBorder(BorderFactory.createEmptyBorder(0, leftMargin, 0, 0));
            components.add(wrap);
        }
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel((Collection)components);
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Location", (boolean)false));
        JPanel jPanel2 = SwingHelper.wrapWithHorizontalStretch((JComponent)jPanel);
        if (jPanel2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "createResultPanel"));
        }
        return jPanel2;
    }

    @NotNull
    private static JPanel createCustomContent(@NotNull TextFieldWithHistoryWithBrowseButton configField, @NotNull JLabel configErrorLabel) {
        if (configField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configField", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "createCustomContent"));
        }
        if (configErrorLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configErrorLabel", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "createCustomContent"));
        }
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(configErrorLabel);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        JPanel jPanel = FormBuilder.createFormBuilder().setHorizontalGap(10).setVerticalGap(4).addLabeledComponent("&Path:", (JComponent)configField).addComponentToRightColumn((JComponent)panel).getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "createCustomContent"));
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createCustomConfigField(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "createCustomConfigField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"jshint.config.option.custom.browser.title", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), (NotNullProducer)new NotNullProducer<List<String>>(){

            @NotNull
            public List<String> produce() {
                List files = JSHintConfigFileView.listConfigFilesInContentScope(project);
                List filePaths = ContainerUtil.map((Collection)files, (Function)new Function<VirtualFile, String>(){

                    public String fun(VirtualFile file) {
                        return FileUtil.toSystemDependentName((String)file.getPath());
                    }
                });
                Collections.sort(filePaths);
                List list = filePaths;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView$3", "produce"));
                }
                return list;
            }
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "createCustomConfigField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private static List<VirtualFile> listConfigFilesInContentScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "listConfigFilesInContentScope"));
        }
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
        Collection configs = FileTypeIndex.getFiles((FileType)JSHintConfigFileType.INSTANCE, (GlobalSearchScope)scope);
        ArrayList result = ContainerUtil.newArrayList();
        for (VirtualFile config : configs) {
            String path;
            if (config == null || !config.isValid() || config.isDirectory() || (path = config.getPath()).contains("/node_modules/") || path.contains("/bower_components/")) continue;
            result.add(config);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "listConfigFilesInContentScope"));
        }
        return arrayList;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public void onEnabledStateChange(boolean enabled) {
        if (enabled) {
            this.selectOption(this.myDefaultRadioButton, this.myDefaultRadioButton.isSelected());
        }
        this.updateCustomErrorMessage();
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomRadioButton.isSelected();
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = StringUtil.notNullize((String)((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "getCustomConfigFilePath"));
        }
        return string;
    }

    public void setCustomConfigFileUsed(boolean used) {
        this.myCustomRadioButton.setSelected(used);
    }

    public void setCustomConfigFilePath(@NotNull String customConfigFilePath) {
        if (customConfigFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customConfigFilePath", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView", "setCustomConfigFilePath"));
        }
        TextFieldWithHistory history = (TextFieldWithHistory)this.myCustomConfigField.getChildComponent();
        history.setText(customConfigFilePath);
        history.addCurrentTextToHistory();
    }
}

