/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.jshint.JSHintInspection;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JSHintConfiguration", storages={@Storage(value="jsLinters/jshint.xml")})
public class JSHintConfiguration
extends JSLinterConfiguration<JSHintState> {
    private static final String JSHINT_ELEMENT_NAME = "jshint";
    private static final String JSHINT_VERSION_ATTRIBUTE_NAME = "version";
    private static final String IS_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-config-file";
    private static final String IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME = "use-custom-config-file";
    private static final String CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME = "custom-config-file-path";
    private static final String OPTION_ELEMENT_NAME = "option";
    private static final JSHintState DEFAULT_STATE = new JSHintState.Builder().setVersion("2.9.1").setOptionsState(new JSHintOptionsState.Builder().put(JSHintOption.FORIN, (Object)true).put(JSHintOption.NOARG, (Object)true).put(JSHintOption.NOEMPTY, (Object)true).put(JSHintOption.EQEQEQ, (Object)true).put(JSHintOption.BITWISE, (Object)true).put(JSHintOption.STRICT, (Object)true).put(JSHintOption.UNDEF, (Object)true).put(JSHintOption.CURLY, (Object)true).put(JSHintOption.NONEW, (Object)true).put(JSHintOption.BROWSER, (Object)true).put(JSHintOption.MAXERR, (Object)50).build()).build();

    public JSHintConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "<init>"));
        }
        super(project);
    }

    @Override
    protected void savePrivateSettings(@NotNull JSHintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "savePrivateSettings"));
        }
    }

    @Override
    @NotNull
    protected JSHintState loadPrivateSettings(@NotNull JSHintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "loadPrivateSettings"));
        }
        JSHintState jSHintState = state;
        if (jSHintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "loadPrivateSettings"));
        }
        return jSHintState;
    }

    @NotNull
    public static JSHintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "getInstance"));
        }
        JSHintConfiguration jSHintConfiguration = JSLinterConfiguration.getInstance(project, JSHintConfiguration.class);
        if (jSHintConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "getInstance"));
        }
        return jSHintConfiguration;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (JSHintInspection.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "getInspectionClass"));
        }
        return JSHintInspection.class;
    }

    @Override
    @NotNull
    protected Element toXml(@NotNull JSHintState state) {
        String customConfigFilePath;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "toXml"));
        }
        Element root = new Element(JSHINT_ELEMENT_NAME);
        root.setAttribute(JSHINT_VERSION_ATTRIBUTE_NAME, state.getVersion());
        root.setAttribute(IS_CONFIG_FILE_USED_ATTRIBUTE_NAME, String.valueOf(state.isConfigFileUsed()));
        if (state.isCustomConfigFileUsed()) {
            root.setAttribute(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME, Boolean.TRUE.toString());
        }
        if (!(customConfigFilePath = state.getCustomConfigFilePath()).isEmpty()) {
            root.setAttribute(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME, FileUtil.toSystemIndependentName((String)customConfigFilePath));
        }
        JSHintOptionsState optionsState = state.getOptionsState();
        List<String> optionKeysInOrder = JSHintConfiguration.sortOptionKeysInOrder(optionsState.getOptionKeys());
        for (String optionKey : optionKeysInOrder) {
            String valueStr;
            Object value;
            JSHintOption option = JSHintOption.findByName(optionKey);
            if (option == null || (value = optionsState.getValue(option)) == null) continue;
            if (value instanceof OptionEnumVariant) {
                OptionEnumVariant variant = (OptionEnumVariant)value;
                valueStr = variant.getValue().toString();
            } else {
                valueStr = value.toString();
            }
            Element child = new Element(OPTION_ELEMENT_NAME);
            child.setAttribute(option.getKey(), valueStr);
            root.addContent(child);
        }
        Element element = root;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "toXml"));
        }
        return element;
    }

    @NotNull
    private static List<String> sortOptionKeysInOrder(@NotNull Collection<String> optionKeys) {
        if (optionKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionKeys", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "sortOptionKeysInOrder"));
        }
        Object[] array = ArrayUtil.toStringArray(optionKeys);
        Arrays.sort(array);
        List<Object> list = Arrays.asList(array);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "sortOptionKeysInOrder"));
        }
        return list;
    }

    @Override
    @NotNull
    protected JSHintState fromXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "fromXml"));
        }
        JSHintState.Builder builder = new JSHintState.Builder();
        JSHintOptionsState optionsState = JSHintConfiguration.loadOptionsValues(element.getChildren());
        builder.setOptionsState(optionsState);
        String version = element.getAttributeValue(JSHINT_VERSION_ATTRIBUTE_NAME);
        if (StringUtil.isNotEmpty((String)version)) {
            builder.setVersion(version);
        }
        builder.setConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        builder.setCustomConfigFileUsed(Boolean.parseBoolean(element.getAttributeValue(IS_CUSTOM_CONFIG_FILE_USED_ATTRIBUTE_NAME)));
        String customConfigFilePath = StringUtil.notNullize((String)element.getAttributeValue(CUSTOM_CONFIG_FILE_PATH_ATTRIBUTE_NAME));
        builder.setCustomConfigFilePath(FileUtil.toSystemDependentName((String)customConfigFilePath));
        JSHintState jSHintState = builder.build();
        if (jSHintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "fromXml"));
        }
        return jSHintState;
    }

    @NotNull
    private static JSHintOptionsState loadOptionsValues(@NotNull List<Element> optionsElements) {
        if (optionsElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsElements", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "loadOptionsValues"));
        }
        JSHintOptionsState.Builder optionsValuesBuilder = new JSHintOptionsState.Builder();
        for (Element child : optionsElements) {
            if (!OPTION_ELEMENT_NAME.equals(child.getName())) continue;
            List attributes = child.getAttributes();
            for (Attribute attribute : attributes) {
                Object value;
                String optionName = attribute.getName();
                JSHintOption option = JSHintOption.findByName(optionName);
                if (option == null || (value = option.fromString(attribute.getValue())) == null) continue;
                optionsValuesBuilder.put(option, value);
            }
        }
        JSHintOptionsState jSHintOptionsState = optionsValuesBuilder.build();
        if (jSHintOptionsState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "loadOptionsValues"));
        }
        return jSHintOptionsState;
    }

    @Override
    @NotNull
    protected JSHintState getDefaultState() {
        JSHintState jSHintState = DEFAULT_STATE;
        if (jSHintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintConfiguration", "getDefaultState"));
        }
        return jSHintState;
    }
}

