/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintOptionCompletionObject;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionEnumVariant;
import com.intellij.lang.javascript.linter.option.OptionTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHintConfigCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getPosition();
        if (!JSHintConfigFileUtil.isJSHintConfigFile(position)) {
            return;
        }
        boolean insideStringLiteral = JSLinterConfigFileUtil.isStringLiteral(position.getParent());
        JsonProperty property = JSLinterConfigFileUtil.getProperty(position);
        if (!JSHintConfigCompletionContributor.isExtendsValuePlace(property, position)) {
            JSLinterConfigFileUtil.skipOtherCompletionContributors(parameters, result);
        }
        if (property == null) {
            return;
        }
        PsiElement propertyKeyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
        if (propertyKeyElement == null) {
            JSHintConfigCompletionContributor.completeJSHintOptions(result, insideStringLiteral);
            return;
        }
        if (position.getParent() == propertyKeyElement) {
            JSHintConfigCompletionContributor.completeJSHintOptions(result, insideStringLiteral);
        } else {
            JSHintOption option = JSHintOption.findByName(StringUtil.stripQuotesAroundValue((String)propertyKeyElement.getText()));
            ArrayList variants = Collections.emptyList();
            if (option != null) {
                if (OptionTypes.isBooleanOption(option)) {
                    variants = ContainerUtil.newArrayList((Object[])new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()});
                } else if (OptionTypes.isEnumOption(option)) {
                    OptionEnumType enumType = OptionTypes.getOptionEnumType(option);
                    variants = ContainerUtil.newArrayList();
                    for (OptionEnumVariant optionEnumVariant : enumType.getVariants()) {
                        String text = optionEnumVariant.getValueAsJsonStr();
                        if (insideStringLiteral) {
                            if (!(optionEnumVariant.getValue() instanceof String)) continue;
                            variants.add(StringUtil.stripQuotesAroundValue((String)text));
                            continue;
                        }
                        variants.add(text);
                    }
                }
                LookupElementRenderer<LookupElement> renderer = new LookupElementRenderer<LookupElement>(){

                    public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                        presentation.setItemText(element.getLookupString());
                        presentation.setItemTextBold(true);
                    }
                };
                for (String string : variants) {
                    LookupElementBuilder builder = LookupElementBuilder.create((String)string).withRenderer((LookupElementRenderer)renderer);
                    result.addElement((LookupElement)builder);
                }
            }
        }
    }

    private static boolean isExtendsValuePlace(@Nullable JsonProperty property, @NotNull PsiElement position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigCompletionContributor", "isExtendsValuePlace"));
        }
        if (property == null) {
            return false;
        }
        PsiElement keyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
        if (keyElement == null) {
            return false;
        }
        return JSLinterConfigFileUtil.isStringLiteral(position) && JSHintConfigFileUtil.isExtendsKey(keyElement);
    }

    private static void completeJSHintOptions(@NotNull CompletionResultSet result, boolean insideStringLiteral) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigCompletionContributor", "completeJSHintOptions"));
        }
        for (JSHintOption option : JSHintOption.values()) {
            JSHintConfigCompletionContributor.addCompletionVariant(result, insideStringLiteral, option, option.getKey());
            if (option.getKeyAlias() == null) continue;
            JSHintConfigCompletionContributor.addCompletionVariant(result, insideStringLiteral, option, option.getKeyAlias());
        }
        JSHintConfigCompletionContributor.addCompletionVariant(result, insideStringLiteral, null, "extends");
    }

    private static void addCompletionVariant(@NotNull CompletionResultSet result, boolean insideStringLiteral, final @Nullable JSHintOption option, @NotNull String variantName) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigCompletionContributor", "addCompletionVariant"));
        }
        if (variantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigCompletionContributor", "addCompletionVariant"));
        }
        String lookupString = insideStringLiteral ? variantName : StringUtil.wrapWithDoubleQuote((String)variantName);
        LookupElementBuilder builder = LookupElementBuilder.create((Object)new JSHintOptionCompletionObject(lookupString), (String)lookupString);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(element.getLookupString());
                presentation.setTypeGrayed(true);
                if (option != null) {
                    presentation.setTypeText(option.getShortDescription());
                }
            }
        });
        result.addElement((LookupElement)builder);
    }
}

