/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.version;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class BigArrayLiteralSplitter {
    private static final int MAX_ARRAY_LITERAL_SIZE = 1000;

    private static String transform(String text, Function<List<Integer>, String> processor) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            String sub;
            List<Integer> ints;
            int startBracketInd;
            int endBracketInd;
            char ch = text.charAt(i);
            if (ch == '[' && (endBracketInd = text.indexOf(93, startBracketInd = i)) != -1 && (ints = BigArrayLiteralSplitter.parseInts(sub = text.substring(startBracketInd + 1, endBracketInd))) != null && ints.size() > 1000) {
                String result = (String)processor.fun(ints);
                out.append(result);
                i = endBracketInd + 1;
                continue;
            }
            out.append(ch);
            ++i;
        }
        return out.toString();
    }

    private static List<Integer> parseInts(String sub) {
        Pattern pattern = Pattern.compile("\\s*,\\s*");
        String[] a = pattern.split(sub);
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String s : a) {
            try {
                int x = Integer.parseInt(s.trim());
                ints.add(x);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return ints;
    }

    public static void main(String[] args) throws IOException {
        String path = args[0];
        String text = FileUtil.loadFile((File)new File(path), (Charset)CharsetToolkit.UTF8_CHARSET);
        String out = BigArrayLiteralSplitter.transform(text, new Function<List<Integer>, String>(){

            public String fun(List<Integer> integers) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add("(function () {");
                lines.add("  var a = new Array(" + integers.size() + ");");
                lines.add("  var str = '" + StringUtil.join(integers, (String)",") + "';");
                lines.add("  var aStr = str.split(',');");
                lines.add("  var len = aStr.length;");
                lines.add("  for (var i = 0; i < len; i++) {");
                lines.add("    a.push(parseInt(aStr[i], 10));");
                lines.add("  }");
                lines.add("  return a;");
                lines.add("})()");
                return StringUtil.join(lines, (String)"\n");
            }
        });
        File outFile = new File(path + ".out");
        FileUtil.writeToFile((File)outFile, (String)out);
    }
}

