/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.intellij.lang.javascript.linter.tslint.TsLintConfigFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintJsonSchemaProviderFactory
implements JsonSchemaProviderFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLintJsonSchema");
    public static final String RELATIVE_PATH = "com/intellij/lang/javascript/linter/tslint/tslint-schema.json";
    private final JsonSchemaFileProvider[] myProviders = new JsonSchemaFileProvider[]{new JsonSchemaFileProvider(){

        public boolean isAvailable(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/tslint/TsLintJsonSchemaProviderFactory$1", "isAvailable"));
            }
            FileType type = file.getFileType();
            return ((Object)((Object)TsLintConfigFileType.INSTANCE)).equals(type);
        }

        @Nullable
        public Reader getSchemaReader() {
            try {
                return TsLintJsonSchemaProviderFactory.this.getSchemaFile();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
    }};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getSchemaFile() throws IOException {
        String jarPath = PathUtil.getJarPathForClass(this.getClass());
        File jarFile = new File(jarPath);
        if (!jarPath.endsWith(".jar")) {
            File file = new File(jarPath, RELATIVE_PATH);
            return new FileReader(file);
        }
        if (!jarFile.isFile()) {
            throw new RuntimeException("jar file cannot be null");
        }
        InputStream stream = null;
        JarFile jFile = new JarFile(jarFile);
        try {
            ZipEntry entry = jFile.getEntry(RELATIVE_PATH);
            if (entry == null) {
                throw new RuntimeException("Can not find template file to create proxy for runtime V8 heap snapshots taking: " + jarPath + "!/" + RELATIVE_PATH);
            }
            stream = jFile.getInputStream(entry);
            String text = new String(FileUtil.loadBytes((InputStream)stream), "UTF-8");
            StringReader stringReader = new StringReader(text);
            return stringReader;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            jFile.close();
        }
    }

    public JsonSchemaFileProvider[] getProviders(Project project) {
        return this.myProviders;
    }
}

