/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.intellij.lang.javascript.linter.JSLinterState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintState
implements JSLinterState {
    private final boolean myCustomConfigFileUsed;
    private String myCustomConfigFilePath;
    private final String myNodePath;
    private final String myPackagePath;
    @Nullable
    private final String myRulesDirectory;

    public TsLintState(boolean customConfigFileUsed, String customConfigFilePath, String nodePath, String packagePath, String rulesDirectory) {
        this.myCustomConfigFileUsed = customConfigFileUsed;
        this.myCustomConfigFilePath = customConfigFilePath;
        this.myNodePath = nodePath;
        this.myPackagePath = packagePath;
        this.myRulesDirectory = rulesDirectory;
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomConfigFileUsed;
    }

    public String getCustomConfigFilePath() {
        return this.myCustomConfigFilePath;
    }

    public void setCustomConfigFilePath(String customConfigFilePath) {
        this.myCustomConfigFilePath = customConfigFilePath;
    }

    public String getNodePath() {
        return this.myNodePath;
    }

    public String getPackagePath() {
        return this.myPackagePath;
    }

    @Nullable
    public String getRulesDirectory() {
        return this.myRulesDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsLintState state = (TsLintState)o;
        if (this.myCustomConfigFileUsed != state.myCustomConfigFileUsed) {
            return false;
        }
        if (this.myCustomConfigFilePath != null ? !this.myCustomConfigFilePath.equals(state.myCustomConfigFilePath) : state.myCustomConfigFilePath != null) {
            return false;
        }
        if (this.myNodePath != null ? !this.myNodePath.equals(state.myNodePath) : state.myNodePath != null) {
            return false;
        }
        if (this.myPackagePath != null ? !this.myPackagePath.equals(state.myPackagePath) : state.myPackagePath != null) {
            return false;
        }
        return !(this.myRulesDirectory != null ? !this.myRulesDirectory.equals(state.myRulesDirectory) : state.myRulesDirectory != null);
    }

    public int hashCode() {
        int result = this.myCustomConfigFileUsed ? 1 : 0;
        result = 31 * result + (this.myCustomConfigFilePath != null ? this.myCustomConfigFilePath.hashCode() : 0);
        result = 31 * result + (this.myNodePath != null ? this.myNodePath.hashCode() : 0);
        result = 31 * result + (this.myPackagePath != null ? this.myPackagePath.hashCode() : 0);
        result = 31 * result + (this.myRulesDirectory != null ? this.myRulesDirectory.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TsLintState{myCustomConfigFileUsed=" + this.myCustomConfigFileUsed + ", myCustomConfigFilePath='" + this.myCustomConfigFilePath + '\'' + ", myNodePath='" + this.myNodePath + '\'' + ", myPackagePath='" + this.myPackagePath + '\'' + ", myRulesDirectory='" + this.myRulesDirectory + '\'' + '}';
    }

    public static class Builder {
        private boolean myCustomConfigFileUsed;
        private String myCustomConfigFilePath;
        private String myNodePath;
        private String myPackagePath;
        @Nullable
        private String myRulesDirectory;

        public Builder() {
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myNodePath = "";
            this.myPackagePath = "";
            this.myRulesDirectory = null;
        }

        public Builder(@NotNull TsLintState state) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/TsLintState$Builder", "<init>"));
            }
            this.myCustomConfigFileUsed = false;
            this.myCustomConfigFilePath = "";
            this.myNodePath = "";
            this.myPackagePath = "";
            this.myRulesDirectory = null;
            this.myCustomConfigFileUsed = state.isCustomConfigFileUsed();
            this.myCustomConfigFilePath = state.getCustomConfigFilePath();
            this.myNodePath = state.getNodePath();
            this.myPackagePath = state.getPackagePath();
            this.myRulesDirectory = state.getRulesDirectory();
        }

        public Builder setCustomConfigFileUsed(boolean customConfigFileUsed) {
            this.myCustomConfigFileUsed = customConfigFileUsed;
            return this;
        }

        public Builder setCustomConfigFilePath(String customConfigFilePath) {
            this.myCustomConfigFilePath = customConfigFilePath;
            return this;
        }

        public Builder setNodePath(String nodePath) {
            this.myNodePath = nodePath;
            return this;
        }

        public Builder setPackagePath(String packagePath) {
            this.myPackagePath = packagePath;
            return this;
        }

        public Builder setRulesDirectory(@Nullable String rulesDirectory) {
            this.myRulesDirectory = rulesDirectory;
            return this;
        }

        public TsLintState build() {
            return new TsLintState(this.myCustomConfigFileUsed, this.myCustomConfigFilePath, this.myNodePath, this.myPackagePath, this.myRulesDirectory);
        }
    }
}

