/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.NodeJSSettingsManager;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.NodeSettingsUtil;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeLocalDependenciesAction
extends AnAction
implements DumbAware {
    public InstallNodeLocalDependenciesAction() {
        super("Run 'npm install'", null, AllIcons.Actions.Install);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "update"));
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        boolean show = project != null && packageJson != null;
        e.getPresentation().setEnabledAndVisible(show);
        if (show) {
            NpmCommand npmCommand = InstallNodeLocalDependenciesAction.guessNpmCommand(packageJson);
            e.getPresentation().setText("Run 'npm " + npmCommand.getCliOption() + "'");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "actionPerformed"));
        }
        Project project = e.getProject();
        VirtualFile packageJson = InstallNodeLocalDependenciesAction.getPackageJsonFile(e);
        if (project != null && packageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
        }
    }

    @NotNull
    public static NpmCommand guessNpmCommand(@NotNull VirtualFile packageJson) {
        VirtualFile nodeModulesDir;
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "guessNpmCommand"));
        }
        VirtualFile parent = packageJson.getParent();
        if (parent != null && (nodeModulesDir = parent.findChild("node_modules")) != null && nodeModulesDir.isDirectory()) {
            NpmCommand npmCommand = NpmCommand.UPDATE;
            if (npmCommand == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "guessNpmCommand"));
            }
            return npmCommand;
        }
        NpmCommand npmCommand = NpmCommand.INSTALL;
        if (npmCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "guessNpmCommand"));
        }
        return npmCommand;
    }

    @Nullable
    private static VirtualFile getPackageJsonFile(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "getPackageJsonFile"));
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (file != null && PackageJsonUtil.isPackageJsonFile(file) && file.isValid()) {
            return file;
        }
        return null;
    }

    public static void runAndShowConsole(@NotNull Project project, final @NotNull VirtualFile packageJson) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "runAndShowConsole"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "runAndShowConsole"));
        }
        InstallNodeLocalDependenciesAction.saveFile(packageJson);
        final NpmCommand npmCommand = InstallNodeLocalDependenciesAction.guessNpmCommand(packageJson);
        ExecutionEnvironmentBuilder builder = new ExecutionEnvironmentBuilder(project, DefaultRunExecutor.getRunExecutorInstance()).runProfile(new RunProfile(){

            @Nullable
            public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$1", "getState"));
                }
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$1", "getState"));
                }
                return new MyRunProfileState(environment.getProject(), packageJson, npmCommand, this);
            }

            public String getName() {
                if (NpmCommand.INSTALL == npmCommand) {
                    return "Node.js dependencies installation";
                }
                return "Node.js dependencies " + npmCommand.getCliOption();
            }

            @Nullable
            public Icon getIcon() {
                return AllIcons.Actions.Install;
            }
        });
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
    }

    private static void saveFile(@NotNull VirtualFile file) {
        Document doc;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "saveFile"));
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        if (fileDocumentManager.isFileModified(file) && (doc = fileDocumentManager.getDocument(file)) != null) {
            fileDocumentManager.saveDocument(doc);
        }
    }

    private static void editSettingsAndRestart(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull NodeSettings oldSettings, @NotNull NodeJSSettingsManager nodeJSSettingsManager) {
        NodeSettings newSettings;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "editSettingsAndRestart"));
        }
        if (packageJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "editSettingsAndRestart"));
        }
        if (oldSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldSettings", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "editSettingsAndRestart"));
        }
        if (nodeJSSettingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeJSSettingsManager", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction", "editSettingsAndRestart"));
        }
        boolean ok = nodeJSSettingsManager.editSettings(project);
        if (ok && !(newSettings = NodeSettingsUtil.getSettings(project)).getInterpreterPath().equals(oldSettings.getInterpreterPath())) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
        }
    }

    private static class MyRunProfileState
    implements RunProfileState {
        private final Project myProject;
        private final VirtualFile myPackageJson;
        private final NpmCommand myNpmCommand;
        private final RunProfile myRunProfile;

        public MyRunProfileState(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull NpmCommand npmCommand, @NotNull RunProfile runProfile) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            if (packageJson == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageJson", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            if (npmCommand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmCommand", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            if (runProfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "<init>"));
            }
            this.myProject = project;
            this.myPackageJson = packageJson;
            this.myNpmCommand = npmCommand;
            this.myRunProfile = runProfile;
        }

        @Nullable
        public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (runner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "execute"));
            }
            TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject);
            consoleBuilder.addFilter((Filter)new NodeStackTraceFilter(this.myProject));
            final NodeSettings settings = NodeSettingsUtil.getSettings(this.myProject);
            String npmExePath = settings.getGuessedNpmExePath();
            if (StringUtil.isEmpty((String)npmExePath)) {
                final NodeJSSettingsManager nodeJSSettingsManager = (NodeJSSettingsManager)ServiceManager.getService(NodeJSSettingsManager.class);
                if (nodeJSSettingsManager == null) {
                    return null;
                }
                int result = Messages.showOkCancelDialog((Project)this.myProject, (String)"Cannot locate npm executable file. Please check \"Node interpreter\" path.", (String)this.myRunProfile.getName(), (String)"Choose Interpreter", (String)"Cancel", (Icon)Messages.getErrorIcon());
                if (result == 0) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InstallNodeLocalDependenciesAction.editSettingsAndRestart(myProject, myPackageJson, settings, nodeJSSettingsManager);
                        }
                    }, ModalityState.NON_MODAL, this.myProject.getDisposed());
                }
                return null;
            }
            VirtualFile dir = this.myPackageJson.getParent();
            if (dir == null) {
                throw new ExecutionException("Cannot determine package.json directory");
            }
            GeneralCommandLine commandLine = MyRunProfileState.createCommandLine(dir, npmExePath, this.myNpmCommand);
            KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine, true);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
            ConsoleView console = consoleBuilder.getConsole();
            console.attachToProcess((ProcessHandler)processHandler);
            ConsoleProgress.install(console, (ProcessHandler)processHandler);
            return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
        }

        @NotNull
        private static GeneralCommandLine createCommandLine(@NotNull VirtualFile workingDir, @NotNull String npmExePath, @NotNull NpmCommand npmCommand) {
            if (workingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            if (npmExePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmExePath", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            if (npmCommand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "npmCommand", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
            CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)new File(workingDir.getPath()), (boolean)true);
            commandLine.setWorkDirectory(workingDir.getPath());
            commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
            commandLine.setExePath(npmExePath);
            commandLine.addParameter(npmCommand.getCliOption());
            GeneralCommandLine generalCommandLine = commandLine;
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/InstallNodeLocalDependenciesAction$MyRunProfileState", "createCommandLine"));
            }
            return generalCommandLine;
        }
    }
}

