/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class StatementParser<T extends JavaScriptParser>
extends JavaScriptParserBase<T> {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.parsing.StatementParsing");
    public static final Key<String> withinInterfaceKey = Key.create((String)"within.interface");
    public static final Key<Object> localVarsKey = Key.create((String)"local.vars.key");
    private static final TokenSet EXPORTABLE_ELEMENTS_KEYWORDS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.VAR_MODIFIERS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.FUNCTION_KEYWORD, JSTokenTypes.CLASS_KEYWORD, JSTokenTypes.ASYNC_KEYWORD, JSTokenTypes.TYPE_KEYWORD})});

    protected StatementParser(T parser) {
        super(parser);
    }

    public void parseSourceElement() {
        IElementType tokenType = this.builder.getTokenType();
        boolean acceptES6ExportImports = this.isAcceptES6ExportImports();
        Object functionParser = this.myJavaScriptParser.getFunctionParser();
        if (((FunctionParser)functionParser).isFunctionDeclarationStart()) {
            ((FunctionParser)functionParser).parseFunctionDeclaration();
        } else if (acceptES6ExportImports && tokenType == JSTokenTypes.IMPORT_KEYWORD) {
            this.parseES6ImportStatement();
        } else {
            if (acceptES6ExportImports && tokenType == JSTokenTypes.EXPORT_KEYWORD && this.tryParseES6ExportStatement()) {
                return;
            }
            this.doParseStatement(true);
        }
    }

    protected boolean isAcceptES6ExportImports() {
        return this.isJavaScript();
    }

    private void parsePackageBodyStatement() {
        this.doParseStatement(true);
    }

    public void parseStatement() {
        this.doParseStatement(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doParseStatement(boolean canHaveClasses) {
        firstToken = this.builder.getTokenType();
        if (firstToken == null) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
            return;
        }
        if (firstToken == JSTokenTypes.LBRACE) {
            this.parseBlock();
            return;
        }
        if (firstToken == JSTokenTypes.SEMICOLON) {
            this.parseEmptyStatement();
            return;
        }
        if (firstToken == JSTokenTypes.IF_KEYWORD) {
            this.parseIfStatement();
            return;
        }
        if (firstToken == JSTokenTypes.DO_KEYWORD || firstToken == JSTokenTypes.WHILE_KEYWORD || firstToken == JSTokenTypes.FOR_KEYWORD) {
            this.parseIterationStatement();
            return;
        }
        if (firstToken == JSTokenTypes.CONTINUE_KEYWORD) {
            this.parseContinueStatement();
            return;
        }
        if (firstToken == JSTokenTypes.BREAK_KEYWORD) {
            this.parseBreakStatement();
            return;
        }
        if (firstToken == JSTokenTypes.RETURN_KEYWORD) {
            this.parseReturnStatement();
            return;
        }
        if (firstToken == JSTokenTypes.WITH_KEYWORD) {
            this.parseWithStatement();
            return;
        }
        if (firstToken == JSTokenTypes.YIELD_KEYWORD) {
            this.parseExpressionStatement();
            return;
        }
        if (firstToken == JSTokenTypes.SWITCH_KEYWORD) {
            this.parseSwitchStatement();
            return;
        }
        if (firstToken == JSTokenTypes.THROW_KEYWORD) {
            this.parseThrowStatement();
            return;
        }
        if (firstToken == JSTokenTypes.TRY_KEYWORD) {
            this.parseTryStatement();
            return;
        }
        if (firstToken == JSTokenTypes.INCLUDE_KEYWORD) {
            this.parseIncludeDirective();
            return;
        }
        if (firstToken == JSTokenTypes.DEBUGGER_KEYWORD) {
            stmt = this.builder.mark();
            refExpr = this.builder.mark();
            this.builder.advanceLexer();
            refExpr.done(JSElementTypes.REFERENCE_EXPRESSION);
            this.forceCheckForSemicolon();
            stmt.done(JSElementTypes.EXPRESSION_STATEMENT);
            return;
        }
        functionParser = this.myJavaScriptParser.getFunctionParser();
        if ((JSTokenTypes.IDENTIFIER == firstToken || this.isModifier(firstToken) || JSTokenTypes.LBRACKET == firstToken || JSTokenTypes.AT == firstToken && functionParser.hasSupportDecorators()) && this.hasAttributeModifiers()) {
            marker = this.builder.mark();
            methodEmptiness = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
            if (!functionParser.parseAttributesList()) {
                marker.rollbackTo();
            } else {
                try {
                    if (this.builder.eof()) {
                        marker.drop();
                        return;
                    }
                    tokenType = this.builder.getTokenType();
                    if (tokenType == JSTokenTypes.FUNCTION_KEYWORD) {
                        functionParser.parseFunctionNoMarker(FunctionParser.Context.SOURCE_ELEMENT, marker);
                        return;
                    }
                    if (this.isExportDefault()) {
                        this.parseES6ExportDefaultAssignmentNoMarker(marker);
                        return;
                    }
                    if (JSTokenTypes.VAR_MODIFIERS.contains(tokenType)) {
                        this.parseVarStatementNoMarker(false, marker);
                        return;
                    }
                    if (tokenType == JSTokenTypes.NAMESPACE_KEYWORD && this.isECMAL4()) {
                        if (this.parseNamespaceNoMarker(marker)) {
                            return;
                        }
                        this.builder.advanceLexer();
                    }
                    if (this.parseDialectSpecificSourceElements(marker)) {
                        return;
                    }
                    if (tokenType == JSTokenTypes.CLASS_KEYWORD || tokenType == JSTokenTypes.INTERFACE_KEYWORD) {
                        this.parseClassOrInterfaceNoMarker(marker);
                        return;
                    }
                    if (tokenType == JSTokenTypes.LBRACE) {
                        this.parseBlockNoMarker(canHaveClasses != false ? BlockType.PACKAGE_OR_CLASS_BODY : BlockType.BLOCK, marker);
                        return;
                    }
                    this.builder.putUserData(FunctionParser.methodsEmptinessKey, null);
                    if (firstToken == JSTokenTypes.IDENTIFIER) {
                        marker.rollbackTo();
                    }
                    if (JSTokenTypes.COLON_COLON == this.builder.getTokenType()) {
                        marker.rollbackTo();
                        if (!this.parseExpressionStatement()) ** GOTO lbl121
                        return;
                    }
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.function.var.class.interface.namespace", (Object[])new Object[0]));
                    marker.drop();
                }
                finally {
                    this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodEmptiness);
                }
            }
        } else {
            if (firstToken == JSTokenTypes.CLASS_KEYWORD || firstToken == JSTokenTypes.INTERFACE_KEYWORD) {
                marker = this.startAttributeListOwner();
                this.parseClassOrInterfaceNoMarker(marker);
                return;
            }
            if (firstToken == JSTokenTypes.LET_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.LPAR) {
                this.parseLetBlock();
                return;
            }
            if (JSTokenTypes.VAR_MODIFIERS.contains(firstToken)) {
                marker = this.hasAttributeModifiers() != false ? this.startAttributeListOwner() : this.builder.mark();
                this.parseVarStatementNoMarker(false, marker);
                return;
            }
            if (firstToken == JSTokenTypes.FUNCTION_KEYWORD && this.isECMAL4()) {
                marker = this.startAttributeListOwner();
                functionParser.parseFunctionNoMarker(FunctionParser.Context.SOURCE_ELEMENT, marker);
                return;
            }
            if (firstToken == JSTokenTypes.NAMESPACE_KEYWORD && this.isECMAL4() && this.parseNamespaceNoMarker(marker = this.startAttributeListOwner())) {
                return;
            }
        }
lbl121:
        // 7 sources

        if (firstToken == JSTokenTypes.NAMESPACE_KEYWORD && this.isECMAL4() && this.parseNamespaceNoMarker(this.builder.mark())) {
            return;
        }
        if (functionParser.isFunctionDeclarationStart()) {
            functionParser.parseFunctionDeclaration();
            return;
        }
        if (this.isIdentifierToken(firstToken)) {
            labeledStatement = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
                this.parseStatement();
                labeledStatement.done(JSElementTypes.LABELED_STATEMENT);
                return;
            }
            labeledStatement.rollbackTo();
        }
        if (firstToken != JSTokenTypes.LBRACE && firstToken != JSTokenTypes.FUNCTION_KEYWORD && this.parseExpressionStatement()) {
            return;
        }
        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
        this.builder.advanceLexer();
    }

    protected boolean isModifier(IElementType token) {
        return JSTokenTypes.MODIFIERS.contains(token);
    }

    public boolean isExportDefault() {
        return this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.DEFAULT_KEYWORD;
    }

    protected boolean hasAttributeModifiers() {
        return this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD && EXPORTABLE_ELEMENTS_KEYWORDS.contains(this.builder.lookAhead(1));
    }

    protected boolean parseDialectSpecificSourceElements(PsiBuilder.Marker marker) {
        return false;
    }

    public void parseClassNoMarker(PsiBuilder.Marker block, boolean mayOmitName, boolean isExpression) {
        if (!this.isJSorTS() && !this.isIdentifierToken(this.builder.lookAhead(1))) {
            block.drop();
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
            this.builder.advanceLexer();
            return;
        }
        LOG.assertTrue(JSTokenTypes.CLASS_KEYWORD == this.builder.getTokenType());
        this.builder.advanceLexer();
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
        } else if (!mayOmitName) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            block.drop();
            return;
        }
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseTypeParameterList();
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.parseReferenceList(this.getClassExtendListElementType());
        }
        if (this.builder.getTokenType() == JSTokenTypes.IMPLEMENTS_KEYWORD) {
            this.parseReferenceList((IElementType)JSStubElementTypes.IMPLEMENTS_LIST);
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
        } else {
            this.builder.advanceLexer();
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
                    break;
                }
                this.parseClassMember();
            }
            this.builder.advanceLexer();
        }
        block.done(isExpression ? this.getClassExpressionElementType() : this.getClassElementType());
        block.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected IElementType getClassElementType() {
        return ES6ElementTypes.CLASS;
    }

    protected IElementType getClassExpressionElementType() {
        return ES6ElementTypes.CLASS_EXPRESSION;
    }

    protected IElementType getClassExtendListElementType() {
        return JSStubElementTypes.ES6_EXTENDS_LIST;
    }

    protected void parseClassMember() {
        ES6Parser es6Parser = new ES6Parser(this.builder);
        ((StatementParser)es6Parser.getStatementParser()).parseClassMember();
    }

    protected PsiBuilder.Marker startAttributeListOwner() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (!this.isLocalVarContext()) {
            PsiBuilder.Marker modifierListMarker = this.builder.mark();
            modifierListMarker.done(JSStubElementTypes.ATTRIBUTE_LIST);
        }
        return marker;
    }

    protected boolean parseExpressionStatement() {
        PsiBuilder.Marker exprStatement = this.builder.mark();
        if (((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional()) {
            this.forceCheckForSemicolon();
            exprStatement.done(JSElementTypes.EXPRESSION_STATEMENT);
            exprStatement.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        exprStatement.drop();
        return false;
    }

    private void parseLetBlock() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LET_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.LPAR);
        this.parseLetDeclarations();
        this.parseBlock();
        marker.done(JSElementTypes.LET_STATEMENT);
    }

    boolean parseLetDeclarations() {
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        boolean parsedSuccessfully = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true, false);
        if (parsedSuccessfully) {
            while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                parsedSuccessfully = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true, false);
                if (parsedSuccessfully) continue;
            }
        }
        return StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen") && parsedSuccessfully;
    }

    private boolean parseNamespaceNoMarker(@NotNull PsiBuilder.Marker useNSStatement) {
        if (useNSStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useNSStatement", "com/intellij/lang/javascript/parsing/StatementParser", "parseNamespaceNoMarker"));
        }
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NAMESPACE_KEYWORD);
        this.builder.advanceLexer();
        if (!JSKeywordSets.IDENTIFIER_TOKENS_SET.contains(this.builder.getTokenType())) {
            useNSStatement.rollbackTo();
            return false;
        }
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseQualifiedTypeName();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.PUBLIC_KEYWORD) {
                this.builder.advanceLexer();
            } else if (tokenType == JSTokenTypes.STRING_LITERAL || tokenType == JSTokenTypes.IDENTIFIER) {
                ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.string.literal", (Object[])new Object[0]));
            }
        }
        this.checkForSemicolon();
        useNSStatement.done(JSStubElementTypes.NAMESPACE_DECLARATION);
        useNSStatement.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return true;
    }

    public void parseIncludeDirective() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.INCLUDE_KEYWORD);
        PsiBuilder.Marker useNSStatement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSTokenTypes.STRING_LITERAL, "javascript.parser.message.expected.string.literal");
        this.checkForSemicolon();
        useNSStatement.done(JSStubElementTypes.INCLUDE_DIRECTIVE);
    }

    protected void parseClassOrInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/parsing/StatementParser", "parseClassOrInterfaceNoMarker"));
        }
        if (this.builder.getTokenType() == JSTokenTypes.CLASS_KEYWORD) {
            this.parseClassNoMarker(clazz, false, false);
        } else {
            assert (this.builder.getTokenType() == JSTokenTypes.INTERFACE_KEYWORD);
            this.parseInterfaceNoMarker(clazz);
        }
    }

    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/parsing/StatementParser", "parseInterfaceNoMarker"));
        }
        clazz.drop();
        if (!this.parseExpressionStatement()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
            this.builder.advanceLexer();
        }
    }

    public void parseReferenceList(IElementType doneToken) {
        IElementType tokenType = this.builder.getTokenType();
        LOG.assertTrue(tokenType == JSTokenTypes.EXTENDS_KEYWORD || tokenType == JSTokenTypes.IMPLEMENTS_KEYWORD);
        PsiBuilder.Marker referenceList = this.builder.mark();
        this.builder.advanceLexer();
        if (this.parseReferenceListMember()) {
            while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (!this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
                } else if (this.parseReferenceListMember()) continue;
                break;
            }
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.type.name", (Object[])new Object[0]));
        }
        referenceList.done(doneToken);
    }

    protected boolean parseReferenceListMember() {
        PsiBuilder.Marker startRefMember = this.builder.mark();
        boolean result = ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseQualifiedTypeName();
        if (result) {
            startRefMember.done((IElementType)JSStubElementTypes.EXTENDS_LIST_MEMBER);
        } else {
            startRefMember.drop();
        }
        return result;
    }

    private void parseTryStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.TRY_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        this.parseBlock();
        while (this.builder.getTokenType() == JSTokenTypes.CATCH_KEYWORD) {
            this.parseCatchBlock();
        }
        if (this.builder.getTokenType() == JSTokenTypes.FINALLY_KEYWORD) {
            this.builder.advanceLexer();
            this.parseBlock();
        }
        statement.done(JSElementTypes.TRY_STATEMENT);
    }

    private void parseCatchBlock() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.CATCH_KEYWORD);
        PsiBuilder.Marker block = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        IElementType identifierType = this.builder.getTokenType();
        if (JSKeywordSets.IDENTIFIER_TOKENS_SET.contains(identifierType)) {
            PsiBuilder.Marker param = this.builder.mark();
            this.builder.advanceLexer();
            if (!((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType() && this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                this.builder.advanceLexer();
                StatementParser.checkMatches(this.builder, identifierType, "javascript.parser.message.expected.identifier");
                StatementParser.checkMatches(this.builder, JSTokenTypes.INSTANCEOF_KEYWORD, "javascript.parser.message.expected.instanceof");
                StatementParser.checkMatches(this.builder, JSTokenTypes.IDENTIFIER, "javascript.parser.message.expected.identifier");
            }
            param.done(JSStubElementTypes.FORMAL_PARAMETER);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.parameter.name", (Object[])new Object[0]));
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.parseBlock();
        block.done(JSElementTypes.CATCH_BLOCK);
    }

    private void parseThrowStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.THROW_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.hasSemanticLinefeedBefore(this.builder)) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
            this.checkForSemicolon();
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
        statement.done(JSElementTypes.THROW_STATEMENT);
    }

    private void parseSwitchStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.SWITCH_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        StatementParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace");
        while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
            if (this.builder.eof()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.unexpected.end.of.file", (Object[])new Object[0]));
                statement.done(JSElementTypes.SWITCH_STATEMENT);
                return;
            }
            this.parseCaseOrDefaultClause();
        }
        this.builder.advanceLexer();
        statement.done(JSElementTypes.SWITCH_STATEMENT);
    }

    private void parseCaseOrDefaultClause() {
        IElementType token;
        IElementType firstToken = this.builder.getTokenType();
        PsiBuilder.Marker clause = this.builder.mark();
        if (firstToken != JSTokenTypes.CASE_KEYWORD && firstToken != JSTokenTypes.DEFAULT_KEYWORD) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.catch.or.default", (Object[])new Object[0]));
        }
        this.builder.advanceLexer();
        if (firstToken == JSTokenTypes.CASE_KEYWORD) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
        while ((token = this.builder.getTokenType()) != null && token != JSTokenTypes.CASE_KEYWORD && token != JSTokenTypes.DEFAULT_KEYWORD && token != JSTokenTypes.RBRACE) {
            this.parseStatement();
        }
        clause.done(JSElementTypes.CASE_CLAUSE);
    }

    private void parseWithStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WITH_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.parseStatement();
        statement.done(JSElementTypes.WITH_STATEMENT);
    }

    private void parseReturnStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.RETURN_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasNewLine = StatementParser.hasSemanticLinefeedBefore(this.builder);
        if (!hasNewLine) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional();
            this.checkForSemicolon();
        }
        statement.done((IElementType)JSElementTypes.RETURN_STATEMENT);
    }

    private void parseBreakStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BREAK_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.hasSemanticLinefeedBefore(this.builder) && this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
            this.builder.advanceLexer();
        }
        this.checkForSemicolon();
        statement.done(JSElementTypes.BREAK_STATEMENT);
    }

    private void parseContinueStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.CONTINUE_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.hasSemanticLinefeedBefore(this.builder) && this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
            this.builder.advanceLexer();
        }
        this.checkForSemicolon();
        statement.done(JSElementTypes.CONTINUE_STATEMENT);
    }

    private void parseIterationStatement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.DO_KEYWORD) {
            this.parseDoWhileStatement();
        } else if (tokenType == JSTokenTypes.WHILE_KEYWORD) {
            this.parseWhileStatement();
        } else if (tokenType == JSTokenTypes.FOR_KEYWORD) {
            this.parseForStatement();
        } else {
            LOG.error("Unknown iteration statement");
        }
    }

    private void parseForStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        boolean forin = this.parseForLoopHeader();
        this.parseStatement();
        statement.done(forin ? JSElementTypes.FOR_IN_STATEMENT : JSElementTypes.FOR_STATEMENT);
    }

    public boolean parseForLoopHeader() {
        boolean empty;
        boolean hasEach;
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        this.builder.advanceLexer();
        boolean bl = hasEach = this.builder.getTokenType() == JSTokenTypes.EACH_KEYWORD;
        if (hasEach) {
            this.builder.advanceLexer();
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        if (JSTokenTypes.VAR_MODIFIERS.contains(this.builder.getTokenType())) {
            this.parseVarStatement(true);
            empty = false;
        } else {
            empty = !((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional(false, false);
        }
        boolean forin = false;
        if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
            this.builder.advanceLexer();
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional();
            if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.semicolon", (Object[])new Object[0]));
            }
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpressionOptional();
        } else if (this.builder.getTokenType() == JSTokenTypes.IN_KEYWORD || this.builder.getTokenType() == JSTokenTypes.OF_KEYWORD) {
            forin = true;
            if (empty) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.forloop.left.hand.side.expression.or.variable.declaration", (Object[])new Object[0]));
            }
            this.builder.advanceLexer();
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.forloop.in.or.semicolon", (Object[])new Object[0]));
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        return forin;
    }

    private void parseWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.WHILE_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.parseStatement();
        statement.done(JSElementTypes.WHILE_STATEMENT);
    }

    private void parseDoWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DO_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        this.parseStatement();
        StatementParser.checkMatches(this.builder, JSTokenTypes.WHILE_KEYWORD, "javascript.parser.message.expected.while.keyword");
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        this.checkForSemicolon();
        statement.done(JSElementTypes.DOWHILE_STATEMENT);
    }

    private void parseIfStatement() {
        PsiBuilder.Marker ifStatement;
        ArrayList<PsiBuilder.Marker> ifMarkers;
        block5: {
            ifMarkers = null;
            while (true) {
                LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD);
                ifStatement = this.builder.mark();
                this.parseIfStatementHeader();
                this.parseStatement();
                if (this.builder.getTokenType() != JSTokenTypes.ELSE_KEYWORD) break block5;
                this.builder.advanceLexer();
                if (this.builder.getTokenType() != JSTokenTypes.IF_KEYWORD) break;
                if (ifMarkers == null) {
                    ifMarkers = new ArrayList<PsiBuilder.Marker>();
                }
                if (ifMarkers.size() < MAX_TREE_DEPTH) {
                    ifMarkers.add(ifStatement);
                    continue;
                }
                ifStatement.drop();
            }
            this.parseStatement();
        }
        ifStatement.done(JSElementTypes.IF_STATEMENT);
        if (ifMarkers != null) {
            for (int i = ifMarkers.size() - 1; i >= 0; --i) {
                ((PsiBuilder.Marker)ifMarkers.get(i)).done(JSElementTypes.IF_STATEMENT);
            }
        }
    }

    public void parseIfStatementHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD);
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseExpression();
        while (this.builder.getTokenType() == JSTokenTypes.OROR || this.builder.getTokenType() == JSTokenTypes.EQEQ) {
            this.builder.advanceLexer();
        }
        StatementParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
    }

    protected void parseEmptyStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.SEMICOLON);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        statement.done(JSElementTypes.EMPTY_STATEMENT);
    }

    private void parseVarStatement(boolean inForInitializationContext) {
        this.parseVarStatementNoMarker(inForInitializationContext, this.builder.mark());
    }

    protected void parseVarStatementNoMarker(boolean inForInitializationContext, @NotNull PsiBuilder.Marker var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/javascript/parsing/StatementParser", "parseVarStatementNoMarker"));
        }
        IElementType declType = this.builder.getTokenType();
        LOG.assertTrue(JSTokenTypes.VAR_MODIFIERS.contains(declType));
        if (this.builder.getUserData(withinInterfaceKey) != null) {
            this.builder.error(JSBundle.message((String)"interface.should.have.no.variable.declarations", (Object[])new Object[0]));
        }
        this.builder.advanceLexer();
        this.parseVarList(inForInitializationContext);
        if (!inForInitializationContext) {
            this.forceCheckForSemicolon();
        }
        var.done(JSStubElementTypes.VAR_STATEMENT);
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseVarList(boolean inForInitializationContext) {
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                StatementParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma");
            }
            this.parseVarDeclaration(!inForInitializationContext);
        } while (this.builder.getTokenType() == JSTokenTypes.COMMA);
    }

    public boolean checkForSemicolon() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.SEMICOLON) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public void forceCheckForSemicolon() {
        boolean b = this.checkForSemicolon();
        if (!b && !StatementParser.hasSemanticLinefeedBefore(this.builder)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.newline.or.semicolon", (Object[])new Object[0]));
        }
    }

    public void parseVarDeclaration(boolean allowIn) {
        if (((FunctionParser)this.myJavaScriptParser.getFunctionParser()).willParseDestructuringAssignment(false)) {
            ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseDestructuringElement(this.getVariableElementType(), true, true);
            return;
        }
        PsiBuilder.Marker var = this.builder.mark();
        if (!this.parseVarName(var)) {
            return;
        }
        ((JSPsiTypeParser)this.myJavaScriptParser.getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.parseVariableInitializer(allowIn);
        }
        var.done(this.getVariableElementType());
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    public IElementType getVariableElementType() {
        return JSStubElementTypes.VARIABLE;
    }

    public IElementType getFieldElementType() {
        return this.getVariableElementType();
    }

    protected boolean parseVarName(PsiBuilder.Marker var) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.variable.name", (Object[])new Object[0]));
            this.builder.advanceLexer();
            var.drop();
            return false;
        }
        this.builder.advanceLexer();
        return true;
    }

    protected boolean isLocalVarContext() {
        return this.builder.getUserData(localVarsKey) != null;
    }

    protected void parseVariableInitializer(boolean allowIn) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EQ);
        this.builder.advanceLexer();
        if (!((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(allowIn, false)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
        }
    }

    public void parseBlock() {
        this.parseBlockOrFunctionBody(BlockType.BLOCK);
    }

    public boolean parseFunctionBody() {
        return this.parseBlockOrFunctionBody(BlockType.FUNCTION_BODY);
    }

    protected boolean checkIdentifier(IElementType elementType) {
        if (this.isIdentifierToken(elementType)) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
        return false;
    }

    protected void parseES6FromDeclaration() {
        if (this.builder.getTokenType() != JSTokenTypes.FROM_KEYWORD) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.from", (Object[])new Object[0]));
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.string.literal", (Object[])new Object[0]));
            marker.done((IElementType)ES6ElementTypes.FROM_CLAUSE);
            return;
        }
        String literalError = ExpressionParser.validateLiteralText(this.builder.getTokenText());
        this.builder.advanceLexer();
        if (literalError != null) {
            this.builder.error(literalError);
        }
        marker.done((IElementType)ES6ElementTypes.FROM_CLAUSE);
    }

    protected boolean tryParseES6ExportStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        IElementType lookAhead = this.builder.lookAhead(1);
        if (lookAhead == JSTokenTypes.MULT || lookAhead == JSTokenTypes.LBRACE) {
            PsiBuilder.Marker exportDeclaration = this.builder.mark();
            this.builder.advanceLexer();
            this.parseES6ExportDeclarationBody(exportDeclaration);
            return true;
        }
        if (lookAhead == JSTokenTypes.DEFAULT_KEYWORD) {
            this.parseES6ExportDefaultAssignment();
            return true;
        }
        return false;
    }

    protected void parseES6ImportStatement() {
        boolean needError;
        PsiBuilder.Marker marker = this.builder.mark();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.IMPORT_KEYWORD);
        this.builder.advanceLexer();
        if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            needError = false;
            this.builder.advanceLexer();
        } else {
            if (this.builder.getTokenType() != JSTokenTypes.FROM_KEYWORD || !JSTokenTypes.STRING_LITERALS.contains(this.builder.lookAhead(1))) {
                needError = !this.parseES6ImportClause();
            } else {
                needError = false;
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.import.value", (Object[])new Object[0]));
            }
            this.parseES6FromDeclaration();
        }
        if (needError) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier.string.literal.or.lbrace", (Object[])new Object[0]));
        }
        this.forceCheckForSemicolon();
        marker.done((IElementType)ES6ElementTypes.IMPORT_DECLARATION);
    }

    protected boolean parseES6ImportClause() {
        boolean parsedAnything = false;
        boolean expectedComma = false;
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            parsedAnything = true;
            PsiBuilder.Marker importedBinding = this.builder.mark();
            this.builder.advanceLexer();
            importedBinding.done((IElementType)ES6ElementTypes.IMPORTED_BINDING);
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                expectedComma = true;
            }
        }
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            parsedAnything = true;
            if (expectedComma) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma", (Object[])new Object[0]));
            }
            this.builder.advanceLexer();
            this.parseES6ImportOrExportClause(true);
        } else if (this.builder.getTokenType() == JSTokenTypes.MULT) {
            parsedAnything = true;
            this.parseES6NamespaceImport();
        }
        return parsedAnything;
    }

    protected void parseES6NamespaceImport() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.MULT);
        PsiBuilder.Marker importedBinding = this.builder.mark();
        this.builder.advanceLexer();
        if (StatementParser.checkMatches(this.builder, JSTokenTypes.AS_KEYWORD, "javascript.parser.message.expected.as") && this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        }
        importedBinding.done((IElementType)ES6ElementTypes.IMPORTED_BINDING);
    }

    protected void parseES6ImportOrExportClause(boolean isImportClause) {
        while (true) {
            if (this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                this.builder.advanceLexer();
                break;
            }
            if (!this.parseES6ImportOrExportSpecifier(isImportClause)) break;
            if (this.builder.getTokenType() != JSTokenTypes.COMMA) continue;
            this.builder.advanceLexer();
        }
    }

    private boolean parseES6ImportOrExportSpecifier(boolean isImportSpecifier) {
        IElementType firstToken = this.builder.getTokenType();
        if (isImportSpecifier && JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken) || this.isIdentifierToken(firstToken) || firstToken == JSTokenTypes.DEFAULT_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD) {
                PsiBuilder.Marker alias = this.builder.mark();
                this.builder.advanceLexer();
                if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType())) {
                    this.builder.advanceLexer();
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                }
                alias.done((IElementType)(isImportSpecifier ? ES6ElementTypes.IMPORT_SPECIFIER_ALIAS : ES6ElementTypes.EXPORT_SPECIFIER_ALIAS));
            }
            marker.done((IElementType)(isImportSpecifier ? ES6ElementTypes.IMPORT_SPECIFIER : ES6ElementTypes.EXPORT_SPECIFIER));
            return true;
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(firstToken)) {
            PsiBuilder.Marker marker = isImportSpecifier ? this.builder.mark() : null;
            this.builder.advanceLexer();
            StatementParser.checkMatches(this.builder, JSTokenTypes.AS_KEYWORD, "javascript.parser.message.expected.as");
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType())) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
            }
            if (marker != null) {
                marker.done((IElementType)ES6ElementTypes.IMPORT_SPECIFIER);
            }
            return true;
        }
        this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
        return false;
    }

    protected void parseES6ExportDeclarationBody(PsiBuilder.Marker exportDeclaration) {
        if (this.builder.getTokenType() == JSTokenTypes.MULT) {
            this.builder.advanceLexer();
            this.parseES6FromDeclaration();
            this.forceCheckForSemicolon();
            exportDeclaration.done((IElementType)ES6ElementTypes.EXPORT_DECLARATION);
        } else if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            this.builder.advanceLexer();
            this.parseES6ImportOrExportClause(false);
            if (this.builder.getTokenType() == JSTokenTypes.FROM_KEYWORD) {
                this.parseES6FromDeclaration();
            }
            this.forceCheckForSemicolon();
            exportDeclaration.done((IElementType)ES6ElementTypes.EXPORT_DECLARATION);
        } else {
            LOG.error("* or { expected");
            exportDeclaration.drop();
        }
    }

    private void parseES6ExportDefaultAssignment() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.parseES6ExportDefaultAssignmentNoMarker(marker);
    }

    private void parseES6ExportDefaultAssignmentNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.EXPORT_KEYWORD);
        this.builder.advanceLexer();
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DEFAULT_KEYWORD);
        this.builder.advanceLexer();
        this.parseES6ExportDefaultAssignmentBody();
        this.forceCheckForSemicolon();
        marker.done((IElementType)ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseES6ExportDefaultAssignmentBody() {
        ((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(false, false);
    }

    protected boolean parseBlockOrFunctionBody(@NotNull BlockType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/parsing/StatementParser", "parseBlockOrFunctionBody"));
        }
        if (type == BlockType.PACKAGE_OR_CLASS_BODY) {
            if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
                return false;
            }
            this.builder.advanceLexer();
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
                    return false;
                }
                this.parsePackageBodyStatement();
            }
            this.builder.advanceLexer();
            return true;
        }
        return this.parseBlockNoMarker(type, this.builder.mark());
    }

    private boolean parseBlockNoMarker(BlockType type, @NotNull PsiBuilder.Marker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/lang/javascript/parsing/StatementParser", "parseBlockNoMarker"));
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            boolean allowExpressionAsFunctionBody;
            JSLanguageDialect dialect = (JSLanguageDialect)((Object)this.builder.getUserData(JS_DIALECT_KEY));
            boolean bl = allowExpressionAsFunctionBody = type == BlockType.ARROW_FUNCTION_BODY || type == BlockType.FUNCTION_BODY && dialect != null && dialect.getOptionHolder().hasFeature(JSLanguageFeature.EXPRESSION_CLOSURES);
            if (!allowExpressionAsFunctionBody || !((ExpressionParser)this.myJavaScriptParser.getExpressionParser()).parseAssignmentExpression(true, false)) {
                block.rollbackTo();
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
                return false;
            }
            block.drop();
            return true;
        }
        this.builder.advanceLexer();
        TIntStack braces = new TIntStack();
        boolean BRACE = true;
        int PAR = 2;
        braces.push(1);
        while (braces.size() > 0) {
            if (this.builder.eof()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
                block.collapse((IElementType)JSElementTypes.BLOCK_STATEMENT);
                return false;
            }
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.LBRACE) {
                braces.push(1);
            } else if (tokenType == JSTokenTypes.LPAR) {
                braces.push(2);
            } else if (tokenType == JSTokenTypes.RBRACE) {
                while (braces.size() > 0 && braces.peek() == 2) {
                    braces.pop();
                }
                if (braces.size() > 0) {
                    braces.pop();
                }
            } else if (tokenType == JSTokenTypes.RPAR) {
                while (braces.size() > 0 && braces.peek() == 1) {
                    braces.pop();
                }
                if (braces.size() > 0) {
                    braces.pop();
                }
            }
            this.builder.advanceLexer();
        }
        block.collapse((IElementType)JSElementTypes.BLOCK_STATEMENT);
        return true;
    }

    public void parseBlockBodyDeeply(@NotNull BlockType type) {
        boolean isLocalVars;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/parsing/StatementParser", "parseBlockBodyDeeply"));
        }
        IElementType firstToken = this.builder.getTokenType();
        if ((JSTokenTypes.IDENTIFIER == firstToken || this.isModifier(firstToken) || JSTokenTypes.LBRACKET == firstToken || JSTokenTypes.AT == firstToken && ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).hasSupportDecorators()) && this.hasAttributeModifiers()) {
            ((FunctionParser)this.myJavaScriptParser.getFunctionParser()).parseAttributesList();
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lbrace", (Object[])new Object[0]));
        }
        this.builder.advanceLexer();
        if (!(type != BlockType.FUNCTION_BODY && type != BlockType.ARROW_FUNCTION_BODY || (isLocalVars = this.isLocalVarContext()))) {
            this.builder.putUserData(localVarsKey, (Object)"");
        }
        boolean rBraceFound = false;
        while (!this.builder.eof()) {
            if (this.builder.getTokenType() == JSTokenTypes.RBRACE) {
                this.builder.advanceLexer();
                rBraceFound = true;
                continue;
            }
            if (type == BlockType.FUNCTION_BODY || type == BlockType.ARROW_FUNCTION_BODY) {
                this.parseSourceElement();
                continue;
            }
            assert (type == BlockType.BLOCK);
            this.parseStatement();
        }
        if (!rBraceFound) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.missing.rbrace", (Object[])new Object[0]));
        }
    }

    public static enum BlockType {
        FUNCTION_BODY,
        ARROW_FUNCTION_BODY,
        BLOCK,
        PACKAGE_OR_CLASS_BODY;

    }
}

