/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluationResult {
    @Nullable
    List<JSTypeEvaluationResultElement> myResults;

    @Nullable
    public JSType getType() {
        if (this.myResults == null) {
            return null;
        }
        if (this.myResults.size() == 1) {
            return this.myResults.get(0).myType;
        }
        ArrayList<JSType> types = new ArrayList<JSType>(this.myResults.size());
        JSTypeSource typeSource = null;
        for (JSTypeEvaluationResultElement result : this.myResults) {
            JSType type = result.getType();
            if (type == null) continue;
            if (typeSource == null) {
                typeSource = JSTypeSourceFactory.copyTypeSource(type.getSource(), false);
            }
            types.add(type);
        }
        return types.isEmpty() ? null : (types.size() == 1 ? (JSType)types.get(0) : new JSCompositeTypeImpl(typeSource, (List<JSType>)types));
    }

    @Nullable
    public JSNamespaceEvaluationResult toNamespaceEvaluationResult() {
        JSSymbolNamespace ns = null;
        JSElement source = null;
        for (JSTypeEvaluationResultElement result : this.getResults()) {
            JSSymbolNamespace currentNs;
            if (result.myNamespace != null) {
                currentNs = result.myNamespace;
                if (result.mySource instanceof JSElement) {
                    source = (JSElement)result.mySource;
                }
            } else {
                currentNs = JSNamespaceEvaluationResult.fromType(result.myType);
                if (currentNs != null) {
                    source = ((JSNamespaceEvaluationResult)currentNs).getSource();
                }
            }
            if (currentNs != null && ns != null) {
                return null;
            }
            ns = currentNs;
        }
        return ns == null ? null : new JSNamespaceEvaluationResult(ns.getQualifiedName(), ns.getJSContext(), ns.isExplicitlyDeclared(), ns.isDeclaration(), source);
    }

    public void addType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeEvaluationResult", "addType"));
        }
        this.addResultElement(type, null, source, null);
    }

    @Contract(value="null, null, null, _ -> fail")
    public void addResultElement(@Nullable JSType type, @Nullable JSSymbolNamespace namespace, @Nullable PsiElement source, @Nullable JSEvaluationResultContext context) {
        if (this.myResults == null) {
            this.myResults = new SmartList();
        }
        JSEvaluationResultContext notNullContext = (JSEvaluationResultContext)ObjectUtils.notNull((Object)context, (Object)JSEvaluationResultContext.EMPTY);
        if (type != null) {
            List types = ContainerUtil.mapNotNull(this.myResults, (Function)new Function<JSTypeEvaluationResultElement, JSType>(){

                public JSType fun(JSTypeEvaluationResultElement element) {
                    return element.getType();
                }
            });
            List<JSType> newTypes = JSTypeUtils.addPossibleOption(types, type);
            for (JSType newType : newTypes) {
                this.myResults.add(new JSTypeEvaluationResultElement(newType, namespace, source, notNullContext));
            }
            return;
        }
        JSTypeEvaluationResultElement e = new JSTypeEvaluationResultElement(null, namespace, source, notNullContext);
        for (JSTypeEvaluationResultElement result : this.myResults) {
            if (!e.isEquivalentTo(result)) continue;
            return;
        }
        this.myResults.add(e);
    }

    public boolean isEmpty() {
        return this.myResults == null || this.myResults.isEmpty();
    }

    @NotNull
    public List<JSTypeEvaluationResultElement> getResults() {
        List<JSTypeEvaluationResultElement> list = this.myResults != null ? this.myResults : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeEvaluationResult", "getResults"));
        }
        return list;
    }

    public static class JSTypeEvaluationResultElement {
        @Nullable
        private final JSType myType;
        @Nullable
        private final JSSymbolNamespace myNamespace;
        @Nullable
        private final PsiElement mySource;
        @NotNull
        private final JSEvaluationResultContext myEvaluationContext;

        private JSTypeEvaluationResultElement(@Nullable JSType type, @Nullable JSSymbolNamespace namespace, @Nullable PsiElement source, @NotNull JSEvaluationResultContext evaluationContext) {
            if (evaluationContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationContext", "com/intellij/lang/javascript/psi/JSTypeEvaluationResult$JSTypeEvaluationResultElement", "<init>"));
            }
            assert (type != null || namespace != null || source != null);
            this.myType = type;
            this.myNamespace = namespace;
            this.mySource = source;
            this.myEvaluationContext = evaluationContext;
        }

        @Nullable
        public JSType getType() {
            return this.myType;
        }

        @Nullable
        public JSSymbolNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }

        @NotNull
        public JSEvaluationResultContext getEvaluationContext() {
            JSEvaluationResultContext jSEvaluationResultContext = this.myEvaluationContext;
            if (jSEvaluationResultContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeEvaluationResult$JSTypeEvaluationResultElement", "getEvaluationContext"));
            }
            return jSEvaluationResultContext;
        }

        public boolean isEquivalentTo(@NotNull JSTypeEvaluationResultElement other) {
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/lang/javascript/psi/JSTypeEvaluationResult$JSTypeEvaluationResultElement", "isEquivalentTo"));
            }
            if (this.myType == null ? other.myType != null : other.myType == null || !this.myType.getTypeText(JSType.TypeTextFormat.SIMPLE).equals(other.myType.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                return false;
            }
            if (this.myNamespace == null ? other.myNamespace != null : other.myNamespace == null || !this.myNamespace.isEquivalentTo(other.myNamespace)) {
                return false;
            }
            if (!ComparatorUtil.equalsNullable((Object)this.mySource, (Object)other.mySource)) {
                return false;
            }
            return !(this.myEvaluationContext == null ? other.myEvaluationContext != null : other.myEvaluationContext == null || !this.myEvaluationContext.isEquivalentTo(other.myEvaluationContext));
        }
    }
}

