/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptParameterImpl
extends JSParameterImpl {
    public TypeScriptParameterImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptParameterImpl(JSParameterStub stub) {
        super(stub, TypeScriptElementTypes.TYPESCRIPT_PARAMETER);
    }

    protected JSType doGetDeclarationTypeStubSafe() {
        JSType type = TypeScriptPsiUtil.getTypeFromDeclaration(this);
        if (type == null) {
            return null;
        }
        boolean isRest = this.isRest();
        if (isRest) {
            JSGenericTypeImpl genericType;
            if (type instanceof JSArrayTypeImpl) {
                type = ((JSArrayTypeImpl)type).getType();
            } else if (type instanceof JSGenericTypeImpl && JSArrayTypeImpl.isGenericArray(genericType = (JSGenericTypeImpl)type)) {
                type = (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
            }
        }
        return type;
    }

    @Override
    @Nullable
    protected JSType doGetType() {
        JSExpression initializer;
        JSType type = this.doGetDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        PsiElement parent = this.getParent();
        if (!(parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringObject || (initializer = this.getInitializer()) == null)) {
            type = new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
        }
        return type;
    }

    @Override
    public boolean isOptional() {
        JSParameterStub parameterStub = (JSParameterStub)this.getStub();
        if (parameterStub != null) {
            return parameterStub.isOptional();
        }
        if (this.getNode().findChildByType(JSTokenTypes.QUEST) != null) {
            return true;
        }
        if (this.getInitializer() == null) {
            return false;
        }
        return this.isOptionalForParameterWithInitializer();
    }

    private boolean isOptionalForParameterWithInitializer() {
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getParentOfType((PsiElement)this, JSParameterList.class);
        if (parameterList == null) {
            return true;
        }
        boolean checkCurrent = false;
        for (JSParameter parameter : parameterList.getParameters()) {
            if (parameter == this) {
                checkCurrent = true;
                continue;
            }
            if (!checkCurrent) continue;
            if (parameter.isOptional() || parameter.isRest()) break;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    protected JSType doGetStubType(JSParameterStub stub) {
        String typeText = stub.getTypeString();
        if (typeText == null) {
            return this.doGetDeclarationTypeStubSafe();
        }
        return super.doGetStubType(stub);
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        JSType type = this.getType();
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        JSClass parentClass;
        JSAttributeList.AccessType accessType;
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType2 = accessType = attributeList != null ? attributeList.getExplicitAccessType() : null;
        if (JSAttributeList.TYPESCRIPT_ACCESS_TYPE_LIST.contains(accessType) && (parentClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this, JSClass.class)) != null) {
            Object object = accessType == JSAttributeList.AccessType.PRIVATE ? new LocalSearchScope((PsiElement)parentClass) : parentClass.getUseScope();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getUseScope"));
            }
            return object;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptParameterImpl", "getUseScope"));
        }
        return searchScope;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    protected boolean isTypeExplicitlyDeclared() {
        return true;
    }
}

