/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSParameterItemWithSource;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringParameterDecorator
implements JSParameterItemWithSource {
    private final JSDestructuringParameter myDestructuringParameter;

    public JSDestructuringParameterDecorator(JSDestructuringParameter destructuringParameter) {
        this.myDestructuringParameter = destructuringParameter;
    }

    @Nullable
    public String getName() {
        return this.myDestructuringParameter.getTarget().getText();
    }

    @Nullable
    public JSType getType() {
        JSType type = this.myDestructuringParameter.getType();
        if (type != null) {
            return type;
        }
        return this.buildTypeFromDestructuring();
    }

    public boolean isOptional() {
        return this.myDestructuringParameter.isOptional();
    }

    public boolean isRest() {
        return this.myDestructuringParameter.isRest();
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(this.getType(), this.isOptional(), this.isRest(), true);
        if (jSParameterTypeDecoratorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "getTypeDecorator"));
        }
        return jSParameterTypeDecoratorImpl;
    }

    @Nullable
    public JSType getTypeIncludingOverridden() {
        return this.getType();
    }

    @NotNull
    private JSType buildTypeFromDestructuring() {
        JSElement target = this.myDestructuringParameter.getTarget();
        Object object = target != null ? JSDestructuringParameterDecorator.buildElement((JSElement)this.myDestructuringParameter, target) : JSAnyType.get((PsiElement)this.myDestructuringParameter, true);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildTypeFromDestructuring"));
        }
        return object;
    }

    private static JSType buildDestructuringObject(@NotNull JSElement context, @NotNull JSDestructuringObject object) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildDestructuringObject"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildDestructuringObject"));
        }
        ArrayList member = ContainerUtil.newArrayList();
        for (JSDestructuringProperty property : object.getProperties()) {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            JSElement element = property.getDestructuringElement();
            member.add(new JSRecordTypeImpl.PropertySignatureImpl(name, JSDestructuringParameterDecorator.buildElement(context, element), false));
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)object, true), member);
    }

    @NotNull
    private static JSType buildElement(@NotNull JSElement context, @Nullable JSElement element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildElement"));
        }
        if (element instanceof JSDestructuringObject) {
            JSType jSType = JSDestructuringParameterDecorator.buildDestructuringObject(context, (JSDestructuringObject)element);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildElement"));
            }
            return jSType;
        }
        if (element instanceof JSDestructuringArray) {
            JSType jSType = JSDestructuringParameterDecorator.buildDestructuringArray(context, (JSDestructuringArray)element);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildElement"));
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)context, true);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildElement"));
        }
        return jSAnyType;
    }

    private static JSType buildDestructuringArray(@NotNull JSElement context, @NotNull JSDestructuringArray element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildDestructuringArray"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "buildDestructuringArray"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)context);
        JSElement[] elements = element.getElements();
        JSAnyType commonType = null;
        if (elements != null) {
            for (JSElement jsElement : elements) {
                JSType type = JSDestructuringParameterDecorator.buildElement(context, jsElement);
                if (type instanceof JSAnyType) {
                    commonType = type;
                    break;
                }
                commonType = commonType == null ? type : JSTypeUtils.getCommonType(commonType, type, holder);
            }
        }
        if (commonType == null) {
            commonType = JSAnyType.get((PsiElement)context, true);
        }
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
    }

    @NotNull
    public JSElement getSource() {
        JSDestructuringParameter jSDestructuringParameter = this.myDestructuringParameter;
        if (jSDestructuringParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterDecorator", "getSource"));
        }
        return jSDestructuringParameter;
    }
}

