/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterImpl
extends JSVariableBaseImpl<JSParameterStub, JSParameter>
implements JSParameter,
StubBasedPsiElement<JSVariableStubBase> {
    public JSParameterImpl(ASTNode node) {
        super(node);
    }

    public JSParameterImpl(JSParameterStub stub) {
        super(stub, JSStubElementTypes.FORMAL_PARAMETER);
    }

    public JSParameterImpl(JSParameterStub stub, JSStubElementType<JSParameterStub, JSParameter> elementType) {
        super(stub, elementType);
    }

    public JSFunction getDeclaringFunction() {
        JSElement owner = this.getOwner();
        return owner instanceof JSFunction ? (JSFunction)owner : null;
    }

    public boolean isRest() {
        JSParameterStub parameterStub = (JSParameterStub)this.getStub();
        if (parameterStub != null) {
            return parameterStub.isRest();
        }
        return this.getNode().findChildByType(JSTokenTypes.DOT_DOT_DOT) != null;
    }

    public boolean isOptional() {
        JSParameterStub parameterStub = (JSParameterStub)this.getStub();
        if (parameterStub != null) {
            return parameterStub.isOptional();
        }
        if (this.getInitializer() != null) {
            return true;
        }
        if (DialectDetector.isActionScript((PsiElement)this)) {
            return false;
        }
        PsiElement grandParent = this.getParent().getParent();
        if (!(grandParent instanceof JSFunctionBaseImpl)) {
            return false;
        }
        JSFunctionBaseImpl parent = (JSFunctionBaseImpl)grandParent;
        return parent.isOptional(this);
    }

    protected boolean isTypeExplicitlyDeclared() {
        JSParameterStub parameterStub = (JSParameterStub)this.getStub();
        if (parameterStub != null) {
            return parameterStub.isTypeExplicitlyDeclared();
        }
        JSType type = this.getType();
        if (type != null) {
            return type.getSource().isExplicitlyDeclared();
        }
        PsiElement grandParent = this.getParent().getParent();
        if (!(grandParent instanceof JSFunctionBaseImpl)) {
            return false;
        }
        JSFunctionBaseImpl parent = (JSFunctionBaseImpl)grandParent;
        return parent.isTypeExplicitlyDeclared(this);
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecorator jSParameterTypeDecorator = (JSParameterTypeDecorator)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<JSParameterTypeDecorator>(){

            @Nullable
            public CachedValueProvider.Result<JSParameterTypeDecorator> compute() {
                boolean isTypeRest;
                JSParameterStub stub = (JSParameterStub)JSParameterImpl.this.getStub();
                if (stub != null) {
                    isTypeRest = stub.isTypeRest();
                } else {
                    PsiElement grandParent;
                    isTypeRest = JSParameterImpl.this.isRest();
                    if (!isTypeRest && JSParameterImpl.this.getNode().findChildByType(JSTokenTypes.COLON) == null && (grandParent = JSParameterImpl.this.getParent().getParent()) instanceof JSFunctionBaseImpl) {
                        isTypeRest = ((JSFunctionBaseImpl)grandParent).isRest(JSParameterImpl.this);
                    }
                }
                JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(JSParameterImpl.this.getType(), JSParameterImpl.this.isOptional(), isTypeRest, JSParameterImpl.this.isTypeExplicitlyDeclared());
                return CachedValueProvider.Result.create((Object)decorator, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
        });
        if (jSParameterTypeDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterImpl", "getTypeDecorator"));
        }
        return jSParameterTypeDecorator;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSParameterImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSParameter((JSParameter)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public Icon getIcon(int flags) {
        return PlatformIcons.PARAMETER_ICON;
    }

    @Override
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    @Override
    public ASTNode findNameIdentifier() {
        return JSParameterImpl.findParameterNameIdentifier(this.getNode());
    }

    @Nullable
    public static ASTNode findParameterNameIdentifier(ASTNode node) {
        ASTNode identifier = JSVariableBaseImpl.findVariableNameIdentifier(node);
        if (identifier == null) {
            identifier = node.getFirstChildNode();
        }
        return identifier;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        ASTNode myNode = this.getNode();
        ASTNode parent = myNode.getTreeParent();
        if (parent.getElementType() == JSStubElementTypes.PARAMETER_LIST) {
            JSChangeUtil.removeRangeWithRemovalOfCommas(myNode, parent);
            return;
        }
        throw new IncorrectOperationException("Cannot delete variable from parent : " + parent.getElementType());
    }

    @Override
    @Nullable
    protected JSType doGetType() {
        ASTNode type;
        ASTNode astNode;
        ASTNode anchor;
        PsiElement grandParent = this.getParent().getParent();
        if (grandParent instanceof JSFunctionBaseImpl) {
            ASTNode typeExpr = JSPsiImplUtils.getTypeExpressionFromDeclaration((JSNamedElement)this);
            JSType typeFromDeclaration = JSPsiImplUtils.getTypeFromTypeExpr(typeExpr, (JSNamedElement)this);
            if (typeFromDeclaration != null) {
                return typeFromDeclaration;
            }
            JSFunctionBaseImpl function = (JSFunctionBaseImpl)grandParent;
            JSType typeFromComments = function.getTypeFromComments(this);
            if (typeFromComments == null) {
                return null;
            }
            typeFromComments.setSourceIfEmpty(JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            return typeFromComments;
        }
        JSType t = super.doGetType();
        if (t == null && (anchor = (astNode = this.getNode()).findChildByType(JSTokenTypes.INSTANCEOF_KEYWORD)) != null && (type = astNode.findChildByType(JSTokenTypes.IDENTIFIER_TOKENS_SET, anchor)) != null) {
            t = JSTypeUtils.createType(type.getText(), JSTypeSourceFactory.createTypeSource((PsiElement)this));
        }
        return t;
    }

    @Nullable
    public JSType getTypeIncludingOverridden() {
        JSParameter superParameter;
        JSFunction function;
        JSType type = super.getType();
        if (type == null && (function = this.getDeclaringFunction()) != null && function.isOverride() && (superParameter = JSInheritanceUtil.findMatchedSuperParameter(this, function)) != null) {
            return superParameter.getType();
        }
        return type;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiComment elt;
        JSElement fun = this.getOwner();
        assert (fun != null);
        if (fun instanceof JSFunction && (elt = JSDocumentationUtils.findFunctionComment((JSFunction)fun)) != null) {
            LocalSearchScope localSearchScope = new LocalSearchScope(new PsiElement[]{elt, fun});
            if (localSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterImpl", "getUseScope"));
            }
            return localSearchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)fun);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    private JSElement getOwner() {
        return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{JSFunction.class, JSCatchBlock.class});
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = this.isValid() ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    @Nullable
    public String getLiteralOrReferenceInitializerText() {
        JSParameterStub stub = (JSParameterStub)this.getStub();
        if (stub != null) {
            return stub.getLiteralOrReferenceInitializerText();
        }
        String result = super.getLiteralOrReferenceInitializerText();
        if (result != null) {
            return result;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)this);
        String name = this.getName();
        if (docComment instanceof JSDocComment && name != null) {
            return ((JSDocComment)docComment).getDefaultValue((JSQualifiedName)JSQualifiedNameImpl.create(name, null));
        }
        return null;
    }

    @NotNull
    public JSElement getSource() {
        JSParameterImpl jSParameterImpl = this;
        if (jSParameterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterImpl", "getSource"));
        }
        return jSParameterImpl;
    }
}

