/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItemWithSource;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSDestructuringParameterDecorator;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSParameterListStub;
import com.intellij.lang.javascript.psi.util.JSDestructuringVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSParameterListImpl
extends JSStubElementImpl<JSParameterListStub>
implements JSParameterList {
    private volatile JSParameter[] myParameters;
    private volatile JSParameterItemWithSource[] myCallParameters;

    public JSParameterListImpl(ASTNode node) {
        super(node);
    }

    public JSParameterListImpl(JSParameterListStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.PARAMETER_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public JSParameter[] getParameters() {
        JSParameter[] parameters = this.myParameters;
        if (parameters == null) {
            JSParameterListImpl jSParameterListImpl = this;
            synchronized (jSParameterListImpl) {
                parameters = this.myParameters;
                if (parameters == null) {
                    parameters = (JSParameter[])this.getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.PARAMETERS, (PsiElement[])JSParameter.EMPTY_ARRAY);
                    JSDestructuringContainer[] destructuringContainers = (JSDestructuringContainer[])this.getStubOrPsiChildren(JSElementTypes.DESTRUCTURING_CONTAINERS, (PsiElement[])JSDestructuringContainer.EMPTY_ARRAY);
                    if (destructuringContainers.length != 0) {
                        final ArrayList destrParameters = new ArrayList();
                        JSDestructuringVisitor visitor = new JSDestructuringVisitor(){

                            public void visitJSLocalVariable(JSLocalVariable node) {
                            }

                            @Override
                            public void visitJSParameter(JSParameter node) {
                                destrParameters.add(node);
                            }

                            @Override
                            public void visitJSVariable(JSVariable node) {
                            }
                        };
                        visitor.visitJSParameterList(this);
                        parameters = new JSParameter[destrParameters.size()];
                        destrParameters.toArray(parameters);
                    }
                    this.myParameters = parameters;
                }
            }
        }
        if (parameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "getParameters"));
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSParameterItemWithSource[] getCallParameters() {
        JSParameterItemWithSource[] parameters = this.myCallParameters;
        if (parameters != null) {
            return parameters;
        }
        JSParameterListImpl jSParameterListImpl = this;
        synchronized (jSParameterListImpl) {
            parameters = this.myCallParameters;
            if (parameters != null) {
                return parameters;
            }
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this);
            if (holder == null || !holder.hasFeature(JSLanguageFeature.DESTRUCTURING_PARAMETERS)) {
                JSParameter[] jsParameters = this.getParameters();
                this.myCallParameters = jsParameters;
                return jsParameters;
            }
            TokenSet allTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{JSExtendedLanguagesTokenSetProvider.PARAMETERS, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_PARAMETER})});
            PsiElement[] children = this.getStubOrPsiChildren(allTokens, PsiElement.ARRAY_FACTORY);
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiElement child : children) {
                if (child instanceof JSParameter) {
                    result.add((JSParameter)child);
                    continue;
                }
                if (!(child instanceof JSDestructuringParameter)) continue;
                result.add(new JSDestructuringParameterDecorator((JSDestructuringParameter)child));
            }
            JSParameterItemWithSource[] items = result.toArray(new JSParameterItemWithSource[0]);
            this.myCallParameters = items;
            return items;
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSParameterListImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSParameterList((JSParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public void clearCaches() {
        this.myParameters = null;
        this.myCallParameters = null;
        super.clearCaches();
    }
}

