/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicInheritorFilter
implements Condition<JSClass> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String mySuperClassName;
    private final boolean myStrict;
    private final boolean myCaching;
    @Nullable
    private GlobalSearchScope myScope;
    private Condition<JSClass> myCondition;

    public PublicInheritorFilter(@NotNull Project project, @NotNull String superClassName, @Nullable GlobalSearchScope scope, boolean strict) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/impl/PublicInheritorFilter", "<init>"));
        }
        if (superClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassName", "com/intellij/lang/javascript/psi/impl/PublicInheritorFilter", "<init>"));
        }
        this(project, superClassName, scope, strict, true);
    }

    public PublicInheritorFilter(@NotNull Project project, @NotNull String superClassName, @Nullable GlobalSearchScope scope, boolean strict, boolean caching) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/psi/impl/PublicInheritorFilter", "<init>"));
        }
        if (superClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassName", "com/intellij/lang/javascript/psi/impl/PublicInheritorFilter", "<init>"));
        }
        this.myProject = project;
        this.mySuperClassName = superClassName;
        this.myStrict = strict;
        this.myCaching = caching;
        this.setScope(scope);
    }

    private synchronized Condition<JSClass> getCondition() {
        if (DumbService.getInstance((Project)this.myProject).isDumb() || this.myScope == null) {
            return Conditions.alwaysFalse();
        }
        if (this.myCondition == null) {
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
            final PsiElement superClass = JSResolveUtil.unwrapProxy(resolver.findClassByQName(this.mySuperClassName, this.myScope));
            if (superClass instanceof JSClass) {
                Condition<JSClass> condition = new Condition<JSClass>(){

                    public boolean value(JSClass jsClass) {
                        JSAttributeList attributeList = jsClass.getAttributeList();
                        return attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC && JSInheritanceUtil.isParentClass(jsClass, (JSClass)superClass, PublicInheritorFilter.this.myStrict, PublicInheritorFilter.this.myScope);
                    }
                };
                this.myCondition = this.myCaching ? Conditions.cached((Condition)condition) : condition;
            } else {
                this.myCondition = Conditions.alwaysFalse();
            }
        }
        return this.myCondition;
    }

    public synchronized void setScope(@Nullable GlobalSearchScope scope) {
        this.myScope = scope;
        this.myCondition = null;
    }

    public boolean value(JSClass jsClass) {
        return this.getCondition().value((Object)jsClass);
    }

    @NotNull
    public String getSuperClassName() {
        String string = this.mySuperClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/PublicInheritorFilter", "getSuperClassName"));
        }
        return string;
    }
}

