/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedData;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentCachedDataBuilder;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.stubs.JSDocCommentStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocCommentImpl
extends JSImplicitElementProviderImpl<JSDocCommentStub>
implements JSDocComment,
StubBasedPsiElement<JSDocCommentStub> {
    private volatile PsiReference[] myRefs;
    private volatile long myModificationCount = -1L;
    private JSDocCommentCachedData myCachedData;

    public JSDocCommentImpl(ASTNode node) {
        super(node);
    }

    public JSDocCommentImpl(JSDocCommentStub stub, IStubElementType signature) {
        super(stub, signature);
    }

    public IElementType getTokenType() {
        return this.getNode().getElementType();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocComment((JSDocComment)this);
        } else {
            visitor.visitComment((PsiComment)this);
        }
    }

    public JSDocTag[] getTags() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof JSDocComment) {
            return ((JSDocComment)firstChild).getTags();
        }
        return (JSDocTag[])this.findChildrenByType(JSDocTokenTypes.DOC_TAG, JSDocTag.class);
    }

    public PsiElement getOwner() {
        return this.getParent();
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences());
    }

    @NotNull
    public PsiReference[] getReferences() {
        long count = this.getManager().getModificationTracker().getModificationCount();
        if (count != this.myModificationCount) {
            JSParameterTypeDecorator type;
            String text;
            final ArrayList result = new ArrayList();
            final PsiElement data = this.findChildByType(JSDocTokenTypes.DOC_COMMENT_DATA);
            PsiElement parent = this.getParent();
            if (data != null && (parent instanceof JSFunction && JSPsiImplUtils.getPrevSiblingIgnoreWhitespace((PsiElement)this) instanceof JSParameterList || parent instanceof JSParameterList) && (text = data.getText()).indexOf(10) == -1 && (type = new JSTypeParser(text, new JSTypeVisitor(){

                @Override
                public void visitSingleType(int startOffset, String name) {
                    if (!"void".equals(name)) {
                        JSDocReferenceSet set = new JSDocReferenceSet((PsiElement)JSDocCommentImpl.this, name, data.getStartOffsetInParent() + startOffset, false);
                        Collections.addAll(result, set.getReferences());
                    }
                }

                @Override
                public void visitRecordProperty(int startOffset, String name, @Nullable String recordPropertyType) {
                }
            }).parseParameterType()) == null) {
                result.clear();
            }
            Collections.addAll(result, ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this));
            this.myRefs = result.toArray(new PsiReference[result.size()]);
            this.myModificationCount = count;
        }
        if (this.myRefs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getReferences"));
        }
        return this.myRefs;
    }

    @NotNull
    public List<String> getGenericParameters() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            List list = stub.getGenericParameters();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getGenericParameters"));
            }
            return list;
        }
        this.initCachedData();
        List<String> list = this.myCachedData.getGenericParameters();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getGenericParameters"));
        }
        return list;
    }

    @Nullable
    public JSAttributeList.AccessType getAccessType() {
        this.initCachedData();
        return this.myCachedData.getAccessType();
    }

    @Nullable
    public String getExplicitName() {
        this.initCachedData();
        JSQualifiedName className = this.myCachedData.getClassName();
        return className != null ? className.getName() : this.myCachedData.getExplicitName();
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        this.initCachedData();
        return this.myCachedData.getNamespace();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        this.initCachedData();
        return this.myCachedData.isNamespaceExplicitlyDeclared();
    }

    @Nullable
    public String getType() {
        this.initCachedData();
        return this.myCachedData.getType();
    }

    @Nullable
    public Map<JSQualifiedName, String> getProperties() {
        this.initCachedData();
        return this.myCachedData.getProperties();
    }

    @NotNull
    public JSContext getJSContext() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getJSContext"));
            }
            return jSContext;
        }
        this.initCachedData();
        JSContext jSContext = this.myCachedData.getContext();
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getJSContext"));
        }
        return jSContext;
    }

    public boolean isClassExplicitly() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            return stub.isClassExplicitly();
        }
        this.initCachedData();
        return this.myCachedData.isClassExplicitly();
    }

    public boolean hasInterfaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            return stub.hasInterfaceTag();
        }
        this.initCachedData();
        return this.myCachedData.isInterface();
    }

    public boolean hasDeprecatedTag() {
        this.initCachedData();
        return this.myCachedData.hasDeprecatedTag();
    }

    public boolean hasConstructsTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            return stub.hasConstructsTag();
        }
        this.initCachedData();
        return this.myCachedData.hasConstructsTag();
    }

    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            JSDocComment.BrowserFamily browserFamily = stub.getBrowserFamily();
            if (browserFamily == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getBrowserFamily"));
            }
            return browserFamily;
        }
        this.initCachedData();
        JSDocComment.BrowserFamily browserFamily = this.myCachedData.getBrowserFamily();
        if (browserFamily == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getBrowserFamily"));
        }
        return browserFamily;
    }

    public boolean hasNamespaceTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            return stub.hasNamespaceTag();
        }
        this.initCachedData();
        return this.myCachedData.hasNamespaceTag();
    }

    public boolean hasAbstractTag() {
        JSDocCommentStub stub = (JSDocCommentStub)this.getStub();
        if (stub != null) {
            return stub.hasAbstractTag();
        }
        this.initCachedData();
        return this.myCachedData.hasAbstractTag();
    }

    @Nullable
    public String getLendsTagValue() {
        this.initCachedData();
        return this.myCachedData.getLendsTagValue();
    }

    @Nullable
    public String getDefaultValue(@NotNull JSQualifiedName parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "getDefaultValue"));
        }
        this.initCachedData();
        return this.myCachedData.getDefaultValue(parameterName);
    }

    @Override
    @Nullable
    protected JSElementIndexingData calculateIndexingData() {
        Map<JSQualifiedName, String> properties;
        JSType parse;
        String enumType;
        Collection<String> baseTypes;
        this.initCachedData();
        JSElementIndexingDataImpl indexingData = null;
        PsiElement element = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)this);
        JSQualifiedNameImpl qualifiedName = element instanceof JSQualifiedNamedElement ? JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)element)) : null;
        for (Pair<String, String> typedef : this.myCachedData.getTypedefs()) {
            if (typedef.first == null || typedef.second == null) continue;
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            indexingData.addTypedef((String)typedef.first, (String)typedef.second);
        }
        JSQualifiedName className = this.myCachedData.getClassName();
        if (className != null) {
            boolean addClassFromComment;
            String classNameTag = className.getQualifiedName();
            boolean classNameIsMorePrecise = qualifiedName == null || !qualifiedName.getQualifiedName().endsWith(classNameTag);
            boolean bl = addClassFromComment = element == null || classNameIsMorePrecise;
            if (classNameIsMorePrecise) {
                qualifiedName = className;
            }
            if (addClassFromComment || qualifiedName.getParent() != null) {
                SmartList elements;
                if (indexingData == null) {
                    indexingData = new JSElementIndexingDataImpl();
                }
                if ((elements = indexingData.getImplicitElements()) == null) {
                    elements = new SmartList();
                    indexingData.setImplicitElements((Collection<JSImplicitElement>)elements);
                }
                if (addClassFromComment) {
                    JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName.getName(), (PsiElement)this).setNamespace(qualifiedName.getParent()).setType(JSImplicitElement.Type.Class).setProperties(JSImplicitElement.Property.MinorImportance);
                    indexingData.addImplicitElement(new JSImplicitElementImpl(builder));
                }
                JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, (Collection<JSImplicitElement>)elements, (PsiElement)this);
            }
        }
        String name = this.myCachedData.getExplicitName();
        JSQualifiedName namespace = this.myCachedData.getNamespace();
        if (name != null || element instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpression((JSReferenceExpression)element)) {
            if (name == null) {
                qualifiedName = JSQualifiedNameImpl.fromQualifiedName(element.getText());
                name = qualifiedName.getName();
                namespace = qualifiedName.getParent();
            } else {
                qualifiedName = JSQualifiedNameImpl.create(name, namespace);
            }
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            JSImplicitElement.Type elementType = this.myCachedData.isInterface() ? JSImplicitElement.Type.Interface : (this.myCachedData.isClassExplicitly() ? JSImplicitElement.Type.Class : (this.myCachedData.hasNamespaceTag() ? JSImplicitElement.Type.Namespace : (this.myCachedData.seemsToBeFunction() ? JSImplicitElement.Type.Function : JSImplicitElement.Type.Variable)));
            PsiElement attachedElement = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)this);
            if (attachedElement instanceof JSReferenceExpression) {
                attachedElement = attachedElement.getParent();
            }
            if (!(attachedElement instanceof JSNamedElement) || !name.equals(((JSNamedElement)attachedElement).getName())) {
                this.addImplicitElement(indexingData, name, namespace, elementType);
            }
            if (!this.myCachedData.seemsToBeFunction() && elementType == JSImplicitElement.Type.Namespace) {
                SmartList elements = indexingData.getImplicitElements();
                if (elements == null) {
                    elements = new SmartList();
                    indexingData.setImplicitElements((Collection<JSImplicitElement>)elements);
                }
                JSStubIndexingUtils.addImplicitNamespaces(qualifiedName, (Collection<JSImplicitElement>)elements, (PsiElement)this);
            }
        }
        if ((baseTypes = this.myCachedData.getBaseTypes()) != null && !baseTypes.isEmpty()) {
            String currentName = null;
            if (this.myCachedData.hasConstructsTag()) {
                String explicitName;
                PsiComment parentComment;
                JSObjectLiteralExpression parent = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)this, JSObjectLiteralExpression.class);
                if (parent != null && (parentComment = JSDocumentationUtils.findDocComment((PsiElement)parent)) instanceof JSDocComment && (explicitName = ((JSDocComment)parentComment).getExplicitName()) != null) {
                    currentName = JSQualifiedNameImpl.create(explicitName, ((JSDocComment)parentComment).getNamespace()).getQualifiedName();
                }
            } else if (qualifiedName != null) {
                currentName = qualifiedName.getQualifiedName();
            }
            if (currentName != null) {
                if (indexingData == null) {
                    indexingData = new JSElementIndexingDataImpl();
                }
                for (String baseType : baseTypes) {
                    indexingData.addBaseType(currentName, baseType);
                }
            }
        }
        if ((enumType = this.myCachedData.getEnumType()) != null && qualifiedName != null && ((parse = new JSTypeParser(enumType, JSTypeSource.EMPTY).parse()) instanceof JSTypeImpl || parse instanceof JSSpecialNamedTypeImpl)) {
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            indexingData.addBaseType(qualifiedName.getQualifiedName(), parse.getTypeText(JSType.TypeTextFormat.SIMPLE));
        }
        if (!((properties = this.myCachedData.getProperties()) == null || properties.size() == 1 && qualifiedName != null && qualifiedName.getName().equals(((JSQualifiedName)ContainerUtil.getFirstItem(properties.keySet())).getName()))) {
            JSRecordType propertiesType;
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            if ((propertiesType = JSTypeUtils.buildRecordTypeFromProperties(properties, this.myCachedData.getOptionals(), JSTypeSource.EMPTY)) != null) {
                Collection<JSImplicitElement> elements = JSTypeUtils.getImplicitMembersFromRecordType(propertiesType, qualifiedName, (PsiElement)this);
                indexingData.addImplicitElements(elements);
            }
        }
        if (qualifiedName != null) {
            indexingData = this.processRecordType(indexingData, this.myCachedData.getType(), qualifiedName);
        }
        for (Pair<String, String> typedef : this.myCachedData.getTypedefs()) {
            String typedefName = (String)typedef.first;
            if (typedefName == null || typedefName.equals(name)) continue;
            if (indexingData == null) {
                indexingData = new JSElementIndexingDataImpl();
            }
            JSQualifiedNameImpl typedefQName = JSQualifiedNameImpl.fromNamepath(typedefName);
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(typedefQName, (PsiElement)this).setType(JSImplicitElement.Type.Interface);
            indexingData.addImplicitElement(builder.toImplicitElement());
            indexingData = this.processRecordType(indexingData, (String)typedef.second, typedefQName);
        }
        List<Pair<JSQualifiedName, String>> parameters = this.myCachedData.getParameters();
        if (parameters != null) {
            JSQualifiedNameImpl baseName = JSQualifiedNameImpl.create("options", qualifiedName);
            JSRecordType mergedParametersType = JSTypeUtils.buildRecordTypeFromQualifiedNames(parameters, Collections.emptySet(), JSTypeSource.EMPTY);
            if (mergedParametersType != null) {
                for (JSRecordType.TypeMember member : mergedParametersType.getTypeMembers()) {
                    JSQualifiedNameImpl baseParameterNs;
                    Collection<JSImplicitElement> members;
                    JSType type;
                    if (!(member instanceof JSRecordType.PropertySignature) || !((type = ((JSRecordType.PropertySignature)member).getType()) instanceof JSRecordType) || (members = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)type, baseParameterNs = JSQualifiedNameImpl.create(((JSRecordType.PropertySignature)member).getName(), baseName), (PsiElement)this)).isEmpty()) continue;
                    if (indexingData == null) {
                        indexingData = new JSElementIndexingDataImpl();
                    }
                    indexingData.addImplicitElements(members);
                }
            }
        }
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            indexingData = (JSElementIndexingDataImpl)handler.processJSDocComment(this, indexingData);
        }
        return indexingData;
    }

    private void addImplicitElement(@NotNull JSElementIndexingDataImpl indexingData, String name, JSQualifiedName namespace, JSImplicitElement.Type elementType) {
        if (indexingData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexingData", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "addImplicitElement"));
        }
        JSContext context = this.myCachedData.getContext();
        if (this.myCachedData.seemsToBeFunction()) {
            ArrayList<Pair<String, JSParameterTypeDecorator>> parameters = new ArrayList<Pair<String, JSParameterTypeDecorator>>();
            for (Pair<String, String> pair : JSDocumentationUtils.findParameters((PsiElement)this)) {
                JSParameterTypeDecorator decorator = JSTypeUtils.createParameterType((String)pair.second, JSTypeSource.EXPLICITLY_DECLARED);
                if (decorator == null) {
                    decorator = JSParameterTypeDecoratorImpl.EMPTY;
                }
                parameters.add((Pair<String, JSParameterTypeDecorator>)Pair.create((Object)pair.first, (Object)decorator));
            }
            JSImplicitElementImpl.Builder builder = new JSImplicitFunctionImpl.Builder(name, (PsiElement)this).setParameters(parameters).setReturnType(this.myCachedData.getReturnType()).setNamespace(namespace).setContext(context);
            JSImplicitFunctionImpl implicitFunction = new JSImplicitFunctionImpl((JSImplicitFunctionImpl.Builder)builder);
            indexingData.addImplicitElement(implicitFunction);
        } else {
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)this).setNamespace(namespace).setType(elementType).setContext(context).setTypeString(this.myCachedData.getType());
            if (this.myCachedData.hasLendsTag()) {
                builder.setProperties(JSImplicitElement.Property.MinorImportance);
            }
            indexingData.addImplicitElement(new JSImplicitElementImpl(builder));
        }
    }

    @Nullable
    private JSElementIndexingDataImpl processRecordType(@Nullable JSElementIndexingDataImpl data, @Nullable String typeName, @NotNull JSQualifiedName namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "processRecordType"));
        }
        JSType type = JSTypeUtils.createType(typeName, JSTypeSource.EMPTY);
        if (type instanceof JSRecordType) {
            Collection<JSImplicitElement> members = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)type, namespace, (PsiElement)this);
            if (data == null && !members.isEmpty()) {
                data = new JSElementIndexingDataImpl();
            }
            if (!members.isEmpty()) {
                assert (data != null);
                data.addImplicitElements(members);
            }
        }
        return data;
    }

    public static boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    private static JSDocCommentCachedData calculateCachedData(ASTNode node) {
        JSDocCommentCachedData cachedData = new JSDocCommentCachedData();
        JSDocumentationUtils.processDocumentationTextFromComment(node, new JSDocCommentCachedDataBuilder(cachedData, node));
        return cachedData;
    }

    private void initCachedData() {
        PsiElement element;
        String qualifiedName;
        if (this.myCachedData != null) {
            return;
        }
        JSDocCommentCachedData cachedData = JSDocCommentImpl.calculateCachedData(this.getNode());
        List<Pair<String, String>> typedefs = cachedData.getTypedefs();
        for (int i = 0; i < typedefs.size(); ++i) {
            Pair<String, String> typedef = typedefs.get(i);
            String typedefName = (String)typedef.first;
            if (typedefName == null) {
                typedefName = JSDocumentationUtils.findNameOfClassAppliedTo((PsiComment)this);
            }
            String typedefType = (String)typedef.second;
            Map<JSQualifiedName, String> properties = cachedData.getProperties();
            if (properties != null && !properties.isEmpty()) {
                Object newType = JSTypeUtils.buildRecordTypeFromProperties(properties, cachedData.getOptionals(), JSTypeSource.EMPTY);
                assert (newType != null);
                JSType typedefJSType = JSTypeUtils.createType(typedefType, JSTypeSource.EMPTY);
                if (!(typedefJSType instanceof JSObjectType)) {
                    newType = new JSCompositeTypeImpl(JSTypeSource.EMPTY, new JSType[]{newType, typedefJSType});
                }
                typedefType = newType.getTypeText();
                cachedData.clearProperties();
            } else if (cachedData.seemsToBeFunction() && typedefs.size() == 1) {
                SmartList decorators = new SmartList();
                for (Pair pair : JSDocumentationUtils.findParameters((PsiElement)this)) {
                    JSParameterTypeDecorator decorator = JSTypeUtils.createParameterType((String)pair.second, JSTypeSource.EXPLICITLY_DECLARED);
                    if (decorator == null) {
                        decorator = JSParameterTypeDecoratorImpl.EMPTY;
                    }
                    decorators.add(decorator);
                }
                JSType returnType = JSTypeUtils.createType(JSDocumentationUtils.findReturnType((PsiElement)this), JSTypeSource.EMPTY);
                if (!decorators.isEmpty() || returnType != null) {
                    JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(JSTypeSource.EMPTY, (List<JSParameterTypeDecorator>)decorators, returnType);
                    typedefType = jSFunctionTypeImpl.getTypeText(JSType.TypeTextFormat.SERIALIZED);
                }
            }
            typedefs.set(i, (Pair<String, String>)Pair.create((Object)typedefName, (Object)(typedefType != null ? typedefType : "*")));
        }
        if (cachedData.getAlias() != null && (qualifiedName = JSDocumentationUtils.getQualifiedNameFromPsi(element = JSDocumentationUtils.findAttachedElementFromComment((PsiComment)this))) != null) {
            cachedData.addTypedef(cachedData.getAlias(), qualifiedName);
        }
        this.myCachedData = cachedData;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedData = null;
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String newText) {
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "updateText"));
        }
        ASTNode newTree = JSChangeUtil.createJSTreeFromText(this.getProject(), newText);
        return newTree.getElementType() == JSStubElementTypes.DOC_COMMENT ? (JSDocComment)newTree.getPsi() : this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocCommentImpl", "createLiteralTextEscaper"));
        }
        return literalTextEscaper;
    }

    @Nullable
    public String getThisType() {
        this.initCachedData();
        return this.myCachedData.getThisType();
    }
}

