/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.ES6ExportValueAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.ES6ImportAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptConfigAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessibilityProcessingHandler {
    public static final String AS3_NAMESPACE_VALUE = "http://adobe.com/AS3/2006/builtin";
    protected boolean acceptPrivateMembers = true;
    protected boolean acceptProtectedMembers = true;
    private boolean acceptProtectedMembersSet;
    private boolean myAcceptOnlyExportedSymbols;
    protected boolean processStatics;
    protected boolean allowUnqualifiedStaticsFromInstance;
    protected String myTypeName;
    protected String myClassScopeTypeName;
    protected boolean myClassDeclarationStarted;
    @Nullable
    protected final PsiElement place;
    protected boolean myProcessingInheritedClasses;
    private boolean myClassScopeExplicitlySet;
    private Collection<JSAccessibilityChecker> myCheckers;
    private static Collection<JSAccessibilityChecker> CHECKERS = ContainerUtil.newArrayList((Object[])new JSAccessibilityChecker[]{ES6ImportAccessibilityChecker.INSTANCE, ES6ExportValueAccessibilityChecker.INSTANCE, TypeScriptConfigAccessibilityChecker.INSTANCE, TypeScriptModuleAccessibilityChecker.INSTANCE});

    public AccessibilityProcessingHandler(@Nullable PsiElement _place) {
        this.place = _place;
        this.allowUnqualifiedStaticsFromInstance = this.place instanceof JSReferenceExpression && ((JSReferenceExpression)this.place).getQualifier() == null;
    }

    public boolean accepts(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler", "accepts"));
        }
        if (resolveProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveProcessor", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler", "accepts"));
        }
        String errorFromCheckers = this.processCheckers(element, resolveProcessor);
        if (!StringUtil.isEmpty((String)errorFromCheckers)) {
            resolveProcessor.addPossibleCandidateResult(element, errorFromCheckers);
            return false;
        }
        if (element instanceof JSVariable || element instanceof JSFunction || element instanceof JSNamespaceDeclaration) {
            return this.acceptsForMembersVisibility((JSPsiElementBase)element, resolveProcessor);
        }
        return !this.processStatics || !this.myClassDeclarationStarted || !(element instanceof JSImplicitElement) || ((JSImplicitElement)element).getType() != JSImplicitElement.Type.Tag;
    }

    protected boolean acceptsForMembersVisibility(@NotNull JSPsiElementBase element, @NotNull SinkResolveProcessor resolveProcessor) {
        PsiElement elt;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler", "acceptsForMembersVisibility"));
        }
        if (resolveProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveProcessor", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler", "acceptsForMembersVisibility"));
        }
        if (DialectDetector.isES6((PsiElement)element) && !(JSPsiImplUtils.getExecutionScope((PsiElement)element) instanceof JSClass)) {
            return true;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (this.place != null && JSResolveUtil.findParent((PsiElement)element) instanceof TypeScriptModule ? !PsiTreeUtil.isAncestor((PsiElement)JSResolveUtil.findParent((PsiElement)element), (PsiElement)JSResolveUtil.findParent(this.place), (boolean)false) : JSResolveUtil.getClassOfContext(this.place) != JSResolveUtil.getClassOfContext((PsiElement)element)) {
            if (!this.acceptPrivateMembers && accessType == JSAttributeList.AccessType.PRIVATE) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.private.member.is.not.accessible.message");
                return false;
            }
            if (!this.acceptProtectedMembers && accessType == JSAttributeList.AccessType.PROTECTED && (this.myClassScopeTypeName != null || AccessibilityProcessingHandler.isParentClassContext((PsiElement)element))) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.protected.member.is.not.accessible.message");
                return false;
            }
        }
        if ((elt = JSResolveUtil.findParent((PsiElement)element)) instanceof TypeScriptObjectType) {
            return this.isProcessStatics();
        }
        if (this.processStatics) {
            if (element.getJSContext() != JSContext.STATIC) {
                return false;
            }
            if (!DialectDetector.isTypeScript((PsiElement)element) && this.myTypeName != null && elt instanceof JSClass && !this.myTypeName.equals(((JSClass)elt).getQualifiedName())) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
                return false;
            }
        } else {
            if (DialectDetector.isES6((PsiElement)element) && element.getJSContext() == JSContext.STATIC) {
                return false;
            }
            if (this.myClassDeclarationStarted && !this.allowUnqualifiedStaticsFromInstance && element.getJSContext() == JSContext.STATIC) {
                resolveProcessor.addPossibleCandidateResult((PsiElement)element, "javascript.static.member.is.not.accessible.message");
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected String processCheckers(@NotNull PsiElement element, @NotNull SinkResolveProcessor resolveProcessor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler", "processCheckers"));
        }
        if (resolveProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveProcessor", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler", "processCheckers"));
        }
        Iterable<JSAccessibilityChecker> allCheckers = CHECKERS;
        if (this.myCheckers != null) {
            allCheckers = ContainerUtil.concat((Iterable[])new Iterable[]{allCheckers, this.myCheckers});
        }
        for (JSAccessibilityChecker checker : allCheckers) {
            String check;
            if (!checker.isAvailable(this, resolveProcessor) || StringUtil.isEmpty((String)(check = checker.check(this.place, element)))) continue;
            return check;
        }
        return null;
    }

    protected static boolean isParentClassContext(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler", "isParentClassContext"));
        }
        PsiElement parent = JSResolveUtil.findParent(element);
        return parent instanceof JSClass || parent instanceof TypeScriptFunction && ((TypeScriptFunction)parent).isConstructor();
    }

    public void setTypeName(String qualifiedName) {
        this.myTypeName = qualifiedName;
    }

    public void configureClassScope(JSClass jsClass) {
        this.myClassScopeExplicitlySet = true;
        this.confugureCurrentClassScope(jsClass);
    }

    private void confugureCurrentClassScope(JSClass jsClass) {
        if (jsClass != null) {
            this.myClassScopeTypeName = jsClass.getQualifiedName();
            this.acceptProtectedMembersSet = false;
        } else {
            this.acceptProtectedMembers = false;
            this.acceptProtectedMembersSet = true;
        }
    }

    public void startingParent(PsiElement parent) {
        this.myClassDeclarationStarted = parent instanceof JSClass;
        if (parent instanceof JSClass) {
            JSClass jsClass = (JSClass)parent;
            final String qName = jsClass.getQualifiedName();
            if (!this.myProcessingInheritedClasses && !this.myClassScopeExplicitlySet) {
                this.confugureCurrentClassScope(JSResolveUtil.getClassOfContext(this.place));
            }
            if (this.acceptPrivateMembers) {
                boolean bl = this.acceptPrivateMembers = qName != null && qName.equals(this.myClassScopeTypeName);
            }
            if (!this.acceptProtectedMembersSet) {
                this.acceptProtectedMembersSet = true;
                if (this.myClassScopeTypeName != null) {
                    PsiElement element;
                    this.acceptProtectedMembers = this.myClassScopeTypeName.equals(qName);
                    if (!this.acceptProtectedMembers && this.place != null && (element = this.getClassScopeType(parent)) instanceof JSClass) {
                        boolean b = element.processDeclarations((PsiScopeProcessor)new ResolveProcessor(null){
                            {
                                super(name);
                                this.setTypeContext(true);
                                this.setToProcessMembers(false);
                                this.setToProcessHierarchy(true);
                                this.setLocalResolve(true);
                            }

                            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                                if (element == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$1", "execute"));
                                }
                                if (state == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/AccessibilityProcessingHandler$1", "execute"));
                                }
                                if (!(element instanceof JSClass)) {
                                    return true;
                                }
                                String classQName = ((JSClass)element).getQualifiedName();
                                return classQName != null && !classQName.equals(qName);
                            }
                        }, ResolveState.initial(), element, element);
                        boolean bl = this.acceptProtectedMembers = !b;
                        if (this.place instanceof JSReferenceExpression && !(((JSReferenceExpression)this.place).getQualifier() instanceof JSSuperExpression)) {
                            this.acceptProtectedMembers = this.acceptProtectedMembers && this.processStatics;
                        }
                    }
                }
            }
        } else if (parent instanceof TypeScriptModule) {
            if (this.acceptPrivateMembers) {
                String qName = ((TypeScriptModule)parent).getQualifiedName();
                this.acceptPrivateMembers = qName != null && qName.equals(this.myClassScopeTypeName);
            }
        } else if (parent instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)parent).getAttributeList();
            if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && !DialectDetector.isES6(parent)) {
                this.processStatics = true;
            }
        } else if (parent instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTag) {
            this.processStatics = false;
        }
    }

    private PsiElement getClassScopeType(PsiElement parent) {
        if (DialectDetector.isTypeScript(parent)) {
            return JSClassResolver.getInstance().findClassByQName(this.myClassScopeTypeName, JSResolveUtil.getResolveScope(parent));
        }
        return JSClassResolver.findClassFromNamespace(this.myClassScopeTypeName, this.place);
    }

    public void setProcessStatics(boolean processStatics) {
        this.processStatics = processStatics;
    }

    public void setAllowUnqualifiedStaticsFromInstance(boolean allowUnqualifiedStaticsFromInstance) {
        this.allowUnqualifiedStaticsFromInstance = allowUnqualifiedStaticsFromInstance;
    }

    public boolean isProcessStatics() {
        return this.processStatics;
    }

    public void setAcceptOnlyExportedSymbols() {
        this.myAcceptOnlyExportedSymbols = true;
    }

    public void setAcceptOnlyExportedSymbols(boolean value) {
        this.myAcceptOnlyExportedSymbols = value;
    }

    public boolean isAcceptOnlyExportedSymbols() {
        return this.myAcceptOnlyExportedSymbols;
    }

    public void addChecker(JSAccessibilityChecker checker) {
        if (this.myCheckers == null) {
            this.myCheckers = new SmartList();
        }
        this.myCheckers.add(checker);
    }
}

