/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ActionScriptResolveUtil {
    @NonNls
    private static final String SCRIPT_TAG_NAME = "Script";
    private static final List<Class<? extends JSElement>> ANONYMOUS_EVENT_LISTENER_CLASSES = Arrays.asList(JSFunctionExpression.class, JSParenthesizedExpression.class, JSCallExpression.class, JSExpressionStatement.class, JSFile.class);

    public static boolean isAnonymousEventHandlerTag(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlText && !SCRIPT_TAG_NAME.equals(((XmlTag)context.getParent()).getLocalName());
    }

    public static boolean isAnonymousEventHandlerAttribute(JSFile jsFile) {
        PsiElement context = jsFile.getContext();
        return context instanceof XmlAttributeValue;
    }

    public static boolean isAnonymousEventHandler(JSFunctionExpression expr) {
        JSFile file = (JSFile)ActionScriptResolveUtil.iterateUp((PsiElement)expr, ANONYMOUS_EVENT_LISTENER_CLASSES);
        return file != null && (ActionScriptResolveUtil.isAnonymousEventHandlerTag(file) || ActionScriptResolveUtil.isAnonymousEventHandlerAttribute(file));
    }

    @Nullable
    public static <T> T computeIfInsideAnonymousEventHandler(PsiElement psiElement, Function<JSFunctionExpression, T> function) {
        while (psiElement instanceof JSExpression) {
            psiElement = psiElement.getParent();
        }
        if (psiElement instanceof JSArgumentList) {
            JSExpression methodExpression = ((JSCallExpression)psiElement.getParent()).getMethodExpression();
            if (methodExpression instanceof JSParenthesizedExpression) {
                methodExpression = ((JSParenthesizedExpression)methodExpression).getInnerExpression();
            }
            if (methodExpression instanceof JSFunctionExpression && ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)methodExpression)) {
                return (T)function.fun((Object)((JSFunctionExpression)methodExpression));
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement iterateUp(PsiElement element, List<Class<? extends JSElement>> classes) {
        Iterator<Class<? extends JSElement>> i = classes.iterator();
        while (i.hasNext()) {
            if (element == null || !i.next().isInstance(element)) {
                return null;
            }
            if (!i.hasNext()) continue;
            element = element.getParent();
        }
        return element;
    }
}

