/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypesEvaluator {
    private static JSGenericTypesEvaluator INSTANCE = null;
    private static final Key<MultiMap<String, JSType>> ourGenericArgumentsMapKey = Key.create((String)"generic.arguments");

    protected JSGenericTypesEvaluator() {
    }

    public static JSGenericTypesEvaluator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JSGenericTypesEvaluator();
        }
        return INSTANCE;
    }

    public final JSType evaluateGenerics(@Nullable JSType type, JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, null);
    }

    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType type, JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter) {
        JSExpression qualifier;
        JSFunctionItem functionItem;
        if (type == null) {
            return null;
        }
        if (resolvedFunction != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolvedFunction)) != null) {
            resolvedFunction = functionItem;
        }
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            type = this.evaluateGenericsFromQualifier(type, qualifier, (JSReferenceExpression)methodExpression);
        }
        if (methodExpression != null && methodExpression.getParent() instanceof JSCallExpression && resolvedFunction instanceof JSFunctionItem) {
            JSParameterItem[] parameters;
            ArrayList<JSType> parameterTypes = new ArrayList<JSType>();
            for (JSParameterItem parameter : parameters = ((JSFunctionItem)resolvedFunction).getParameters()) {
                parameterTypes.add(parameter.getType());
            }
            JSExpression[] arguments = ((JSCallExpression)methodExpression.getParent()).getArguments();
            MultiMap<String, JSType> genericArguments = JSGenericTypesEvaluator.inferGenericArgumentsFromCall(parameterTypes, arguments);
            type = JSTypeUtils.applyGenericArguments(type, JSGenericTypesEvaluator.intersectGenerics(genericArguments, reporter), reporter);
        }
        return type;
    }

    public static Map<String, JSType> intersectGenerics(MultiMap<String, JSType> map, @Nullable GenericErrorReporter reporter) {
        HashMap result = ContainerUtil.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            JSType type;
            Collection value = (Collection)entry.getValue();
            assert (value.size() > 0);
            if (value.size() == 1) {
                result.put(entry.getKey(), ContainerUtil.getFirstItem((Collection)value));
                continue;
            }
            Collection types = (Collection)entry.getValue();
            boolean hasImplicitly = false;
            for (JSType type2 : types) {
                if (type2 != null && type2.getSource().isExplicitlyDeclared()) continue;
                hasImplicitly = true;
                break;
            }
            if ((type = JSGenericTypesEvaluator.intersectTypes(types)) != null) {
                result.put(entry.getKey(), type);
                continue;
            }
            if (reporter != null && hasImplicitly) continue;
        }
        return result;
    }

    @Nullable
    public static JSType intersectTypes(@NotNull Collection<JSType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "intersectTypes"));
        }
        List typesForSearch = ContainerUtil.skipNulls((Collection)ContainerUtil.newArrayList(types));
        JSType firstNamed = null;
        for (JSType type : types) {
            JSType currentType;
            JSTypeSource source;
            if (firstNamed == null && type instanceof JSNamedType) {
                firstNamed = type;
            }
            if (type == null || (source = type.getSource()).isTypeScript() && !(currentType = JSTypeUtils.getValuableType(type)).getSource().isExplicitlyDeclared()) continue;
            boolean result = true;
            for (JSType jsType : typesForSearch) {
                if (jsType == type || type.isDirectlyAssignableType(jsType, null)) continue;
                result = false;
                break;
            }
            if (!result) continue;
            return type;
        }
        return null;
    }

    private static MultiMap<String, JSType> inferGenericArgumentsFromCall(List<JSType> parameterTypes, JSExpression[] arguments) {
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        for (int i = 0; i < arguments.length && i < parameterTypes.size(); ++i) {
            JSType exprType = JSResolveUtil.getExpressionJSType(arguments[i]);
            JSType paramType = parameterTypes.get(i);
            if (paramType instanceof JSTypeofTypeImpl) {
                paramType = paramType.substitute();
            }
            if (!JSTypeUtils.hasGenericParameter(paramType)) continue;
            JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType);
        }
        return genericArguments;
    }

    public static MultiMap<String, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType) {
        if (exprType == null || paramType == null) {
            return MultiMap.EMPTY;
        }
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType);
        return genericArguments;
    }

    private static void matchGenericTypes(@NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "matchGenericTypes"));
        }
        if (paramType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramType", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "matchGenericTypes"));
        }
        paramType = JSTypeUtils.applyCompositeMapping(paramType, new Function<JSType, JSType>(){

            public JSType fun(JSType type) {
                if (!(type instanceof JSGenericParameterImpl)) {
                    return type;
                }
                return new JSGenericParameterImpl(type.getTypeText(), type.getSource(), ((JSGenericParameterImpl)type).getConstraintType()){

                    @Override
                    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
                        if (processingContext == null) {
                            return true;
                        }
                        MultiMap genericArgumentsMap = (MultiMap)processingContext.get(ourGenericArgumentsMapKey);
                        if (genericArgumentsMap != null && !(elementType instanceof JSGenericParameterImpl)) {
                            genericArgumentsMap.putValue((Object)this.getTypeText(), (Object)this.replaceGenericParameters(elementType));
                        }
                        return true;
                    }

                    @Override
                    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
                        MultiMap genericArgumentsMap;
                        if (type instanceof JSGenericParameterImpl) {
                            return this.getTypeText().equals(type.getTypeText());
                        }
                        if (type != null && processingContext != null && (genericArgumentsMap = (MultiMap)processingContext.get(ourGenericArgumentsMapKey)) != null) {
                            genericArgumentsMap.putValue((Object)this.getTypeText(), (Object)this.replaceGenericParameters(type));
                        }
                        return false;
                    }

                    private JSType replaceGenericParameters(JSType type) {
                        if (JSTypeUtils.hasGenericParameter(type)) {
                            type = JSTypeUtils.applyCompositeMapping(type, new Function<JSType, JSType>(){

                                public JSType fun(JSType type) {
                                    if (type instanceof JSGenericParameterImpl) {
                                        return JSAnyType.get((PsiElement)this.getScope(), false);
                                    }
                                    return type;
                                }
                            });
                        }
                        return type;
                    }
                };
            }
        });
        paramType.isDirectlyAssignableType(exprType, processingContext);
    }

    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, JSReferenceExpression methodExpression) {
        JSType qualifierType;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSQualifiedNamedElement && namespaceElement.isValid()) {
            PsiFile file = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSQualifiedNamedElement)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                final List<String> genericParameters = javaScriptGenericParameters;
                type = JSTypeUtils.applyCompositeMapping(type, new Function<JSType, JSType>(){

                    public JSType fun(JSType type) {
                        if (type instanceof JSTypeImpl && genericParameters.contains(type.getTypeText())) {
                            return new JSGenericParameterImpl(type.getTypeText(), type.getSource());
                        }
                        return type;
                    }
                });
            }
        }
        if (javaScriptGenericParameters != null && JSTypeUtils.hasGenericParameter(type) && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null) {
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
        }
        JSType jSType = type;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "evaluateGenericsFromQualifier"));
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        if (genericType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericType", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        if (parentClassNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClassNamespace", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        if (qName == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(genericType, scope);
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "findTypeArgumentsForClassInHierarchy"));
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        if (parentClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClassName", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<Object> pathToSuperClass = new ArrayList<Object>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String string : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(string, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeArguments);
            typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "applyTypeSubstitutorUpToParentClass"));
        }
        return jSTypeSubstitutor;
    }

    private static JSTypeSubstitutor getTypeArgumentsMap(JSType genericType, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator", "getTypeArgumentsMap"));
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            return JSTypeSubstitutor.EMPTY;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.put((Object)genericParameters.get(i), (Object)arguments.get(i));
            }
        }
        return typeArguments;
    }

    public static interface GenericErrorReporter {
        public void error(String var1);
    }
}

